/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public class HierarchicalPortConstraintProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Hierarchical port constraint processing", 1.0f);
        this.processEasternAndWesternPortDummies(layeredGraph);
        this.processNorthernAndSouthernPortDummies(layeredGraph);
        this.getMonitor().done();
    }

    private void processEasternAndWesternPortDummies(LayeredGraph layeredGraph) {
        if (!layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
            return;
        }
        List<Layer> layers = layeredGraph.getLayers();
        this.processEasternAndWesternPortDummies(layers.get(0));
        this.processEasternAndWesternPortDummies(layers.get(layers.size() - 1));
    }

    private void processEasternAndWesternPortDummies(Layer layer) {
        LNode[] nodes = layer.getNodes().toArray(new LNode[0]);
        Arrays.sort(nodes, new NodeComparator());
        LNode lastHierarchicalDummy = null;
        LNode[] lNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) break;
            PortSide externalPortSide = node.getProperty(Properties.EXT_PORT_SIDE);
            if (externalPortSide == PortSide.WEST || externalPortSide == PortSide.EAST) {
                if (lastHierarchicalDummy != null) {
                    lastHierarchicalDummy.setProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT, node);
                }
                lastHierarchicalDummy = node;
            }
            ++n2;
        }
    }

    private void processNorthernAndSouthernPortDummies(LayeredGraph layeredGraph) {
        PortConstraints portConstraints = layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isSideFixed()) {
            return;
        }
        boolean onlyReplaceOriginalDummy = !portConstraints.isOrderFixed();
        HashMap<Object, LNode> nextLayerNodesToAdd = new HashMap<Object, LNode>();
        HashSet<LNode> externalNodeDummies = new HashSet<LNode>();
        ListIterator<Layer> layerIterator = layeredGraph.getLayers().listIterator();
        while (layerIterator.hasNext()) {
            Layer currentLayer = layerIterator.next();
            if (!nextLayerNodesToAdd.isEmpty()) {
                for (LNode dummy : nextLayerNodesToAdd.values()) {
                    dummy.setLayer(currentLayer);
                }
                nextLayerNodesToAdd.clear();
            }
            for (LNode currentNode : currentLayer) {
                for (LEdge edge : currentNode.getOutgoingEdges()) {
                    LNode targetNode = edge.getTarget().getNode();
                    if (!this.isNorthernSouthernDummy(targetNode)) continue;
                    externalNodeDummies.add(targetNode);
                    if (onlyReplaceOriginalDummy) continue;
                    LNode nextLayerDummy = (LNode)nextLayerNodesToAdd.get(targetNode.getProperty(Properties.ORIGIN));
                    if (nextLayerDummy == null) {
                        nextLayerDummy = this.createDummy(targetNode);
                        nextLayerNodesToAdd.put(targetNode.getProperty(Properties.ORIGIN), nextLayerDummy);
                    }
                    edge.setTarget(nextLayerDummy.getPorts().get(0));
                }
            }
        }
        if (!nextLayerNodesToAdd.isEmpty()) {
            Layer newLastLayer = new Layer(layeredGraph);
            layeredGraph.getLayers().add(newLastLayer);
            for (LNode dummy : nextLayerNodesToAdd.values()) {
                dummy.setLayer(newLastLayer);
            }
        }
        for (LNode originalDummy : externalNodeDummies) {
            if (onlyReplaceOriginalDummy) {
                LEdge[] edges;
                LNode newDummy = this.createDummy(originalDummy);
                newDummy.setLayer(originalDummy.getLayer());
                LPort originalPort = originalDummy.getPorts().get(0);
                LPort newPort = newDummy.getPorts().get(0);
                LEdge[] lEdgeArray = edges = originalPort.getIncomingEdges().toArray(new LEdge[0]);
                int n = edges.length;
                int n2 = 0;
                while (n2 < n) {
                    LEdge edge = lEdgeArray[n2];
                    edge.setTarget(newPort);
                    ++n2;
                }
            }
            originalDummy.setLayer(null);
        }
    }

    private boolean isNorthernSouthernDummy(LNode node) {
        NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
        if (nodeType == NodeType.EXTERNAL_PORT) {
            PortSide portSide = node.getProperty(Properties.EXT_PORT_SIDE);
            return portSide == PortSide.NORTH || portSide == PortSide.SOUTH;
        }
        return false;
    }

    private LNode createDummy(LNode originalDummy) {
        LNode newDummy = new LNode();
        newDummy.copyProperties(originalDummy);
        newDummy.setProperty(Properties.EXT_PORT_REPLACED_DUMMY, originalDummy);
        newDummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        newDummy.setProperty(LayoutOptions.ALIGNMENT, (Object)Alignment.CENTER);
        LPort inputPort = new LPort();
        inputPort.setNode(newDummy);
        inputPort.setSide(PortSide.WEST);
        return newDummy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeComparator
    implements Comparator<LNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(LNode node1, LNode node2) {
            NodeType nodeType1 = node1.getProperty(Properties.NODE_TYPE);
            double nodePos1 = node1.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
            NodeType nodeType2 = node2.getProperty(Properties.NODE_TYPE);
            double nodePos2 = node2.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
            if (nodeType2 != NodeType.EXTERNAL_PORT) {
                return -1;
            }
            if (nodeType1 != NodeType.EXTERNAL_PORT) {
                return 1;
            }
            if (nodePos1 == nodePos2) {
                return 0;
            }
            return nodePos1 < nodePos2 ? -1 : 1;
        }
    }
}

