/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTransformer
extends AbstractAlgorithm
implements ILayoutProcessor {
    private Mode mode;

    public GraphTransformer(Mode themode) {
        this.mode = themode;
    }

    @Override
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Graph transformation (" + (Object)((Object)this.mode) + ")", 1.0f);
        LinkedList<LNode> nodes = new LinkedList<LNode>(layeredGraph.getLayerlessNodes());
        for (Layer layer : layeredGraph.getLayers()) {
            nodes.addAll(layer.getNodes());
        }
        switch (this.mode) {
            case MIRROR: {
                this.mirror(nodes);
                break;
            }
            case TRANSPOSE: {
                this.transpose(nodes);
                this.transpose(layeredGraph.getOffset());
                this.transpose(layeredGraph.getSize());
                break;
            }
            case MIRROR_AND_TRANSPOSE: {
                this.mirror(nodes);
                this.transpose(nodes);
                this.transpose(layeredGraph.getOffset());
                this.transpose(layeredGraph.getSize());
            }
        }
        this.getMonitor().done();
    }

    private void mirror(List<LNode> nodes) {
        double maxx = 0.0;
        for (LNode node : nodes) {
            maxx = Math.max(maxx, node.getPosition().x + node.getSize().x);
        }
        for (LNode node : nodes) {
            this.mirror(node.getPosition(), maxx - node.getSize().x);
            KVector nodeSize = node.getSize();
            for (LPort port : node.getPorts()) {
                this.mirror(port.getPosition(), nodeSize.x);
                this.mirrorPortSide(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.mirror(bendPoint, maxx);
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.mirror(label.getPosition(), maxx - label.getSize().x);
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.mirror(label.getPosition(), -label.getSize().x);
                }
            }
            for (LLabel label : node.getLabels()) {
                this.mirror(label.getPosition(), nodeSize.x - label.getSize().x);
            }
        }
    }

    private void mirror(KVector v, double offset) {
        v.x = offset - v.x;
    }

    private void mirrorPortSide(LPort port) {
        switch (port.getSide()) {
            case NORTH: {
                port.setSide(PortSide.SOUTH);
                break;
            }
            case SOUTH: {
                port.setSide(PortSide.NORTH);
                break;
            }
            case EAST: {
                port.setSide(PortSide.WEST);
                break;
            }
            case WEST: {
                port.setSide(PortSide.EAST);
            }
        }
    }

    private void transpose(List<LNode> nodes) {
        for (LNode node : nodes) {
            this.transpose(node.getPosition());
            this.transpose(node.getSize());
            for (LPort port : node.getPorts()) {
                this.transpose(port.getPosition());
                this.transpose(port.getSize());
                this.transposePortSide(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.transpose(bendPoint);
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.transpose(label.getPosition());
                        this.transpose(label.getSize());
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.transpose(label.getPosition());
                    this.transpose(label.getSize());
                }
            }
            for (LLabel label : node.getLabels()) {
                this.transpose(label.getPosition());
                this.transpose(label.getSize());
            }
        }
    }

    private void transpose(KVector v) {
        double temp = v.x;
        v.x = v.y;
        v.y = temp;
    }

    private void transposePortSide(LPort p) {
        switch (p.getSide()) {
            case NORTH: {
                p.setSide(PortSide.WEST);
                break;
            }
            case WEST: {
                p.setSide(PortSide.NORTH);
                break;
            }
            case SOUTH: {
                p.setSide(PortSide.EAST);
                break;
            }
            case EAST: {
                p.setSide(PortSide.SOUTH);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MIRROR,
        TRANSPOSE,
        MIRROR_AND_TRANSPOSE;

    }
}

