/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.EdgeConstraint;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;

public class EdgeAndLayerConstraintEdgeReverser
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Edge and layer constraint edge reversal", 1.0f);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            LayerConstraint layerConstraint = node.getProperty(Properties.LAYER_CONSTRAINT);
            switch (layerConstraint) {
                case FIRST: 
                case FIRST_SEPARATE: {
                    node.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                    break;
                }
                case LAST: 
                case LAST_SEPARATE: {
                    node.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                }
            }
            EdgeConstraint edgeConstraint = node.getProperty(Properties.EDGE_CONSTRAINT);
            if (edgeConstraint == EdgeConstraint.INCOMING_ONLY) {
                this.reverseEdges(node, PortType.OUTPUT);
                continue;
            }
            if (edgeConstraint == EdgeConstraint.OUTGOING_ONLY) {
                this.reverseEdges(node, PortType.INPUT);
                continue;
            }
            if (!node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isSideFixed()) continue;
            boolean allPortsReversed = true;
            for (LPort port : node.getPorts()) {
                if (port.getSide() == PortSide.EAST && port.getNetFlow() > 0 || port.getSide() == PortSide.WEST && port.getNetFlow() < 0) continue;
                allPortsReversed = false;
                break;
            }
            if (!allPortsReversed) continue;
            this.reverseEdges(node, PortType.UNDEFINED);
        }
        this.getMonitor().done();
    }

    private void reverseEdges(LNode node, PortType type) {
        LPort[] ports;
        LPort[] lPortArray = ports = node.getPorts().toArray(new LPort[node.getPorts().size()]);
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            LPort port = lPortArray[n2];
            List<LEdge> outgoing = port.getOutgoingEdges();
            if (type != PortType.INPUT && !outgoing.isEmpty()) {
                LEdge[] edges;
                LEdge[] lEdgeArray = edges = outgoing.toArray(new LEdge[outgoing.size()]);
                n3 = edges.length;
                int n4 = 0;
                while (n4 < n3) {
                    LEdge edge = lEdgeArray[n4];
                    edge.reverse(true);
                    ++n4;
                }
            }
            List<LEdge> incoming = port.getIncomingEdges();
            if (type != PortType.OUTPUT && !incoming.isEmpty()) {
                LEdge[] edges;
                LEdge[] lEdgeArray = edges = incoming.toArray(new LEdge[incoming.size()]);
                int n5 = edges.length;
                n3 = 0;
                while (n3 < n5) {
                    LEdge edge = lEdgeArray[n3];
                    edge.reverse(true);
                    ++n3;
                }
            }
            ++n2;
        }
    }
}

