/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.CompoundKGraphImporter;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundSideProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    @Override
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Set Compound Side nodes", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        LinkedList<LNode> openingBorders = new LinkedList<LNode>();
        for (Layer layer : layers) {
            for (LNode lnode : layer) {
                if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.UPPER_COMPOUND_BORDER) continue;
                openingBorders.add(lnode);
            }
        }
        for (LNode lnode : openingBorders) {
            Layer spanEnd = CompoundSideProcessor.findSpanEnd(lnode, layers);
            int startIndex = lnode.getLayer().getIndex();
            int endIndex = spanEnd.getIndex();
            this.insertSideDummies(startIndex, endIndex, layers, lnode, null, null);
        }
        this.getMonitor().done();
    }

    private void insertSideDummies(int startIndex, int endIndex, List<Layer> layers, LNode openingBorder, LEdge lowerConnector, LEdge upperConnector) {
        KInsets insets = openingBorder.getProperty(Properties.ORIGINAL_INSETS);
        float borderSpacing = openingBorder.getProperty(Properties.BORDER_SPACING).floatValue();
        Layer layer = layers.get(startIndex);
        List<LNode> layerNodes = layer.getNodes();
        int lowerIndex = this.findUltimateIndex(layer, openingBorder, true);
        int upperIndex = this.findUltimateIndex(layer, openingBorder, false);
        LNode lowerSideDummy = new LNode();
        lowerSideDummy.setProperty(LayoutOptions.ALIGNMENT, (Object)Alignment.LEFT);
        lowerSideDummy.getSize().y = insets.getBottom() + borderSpacing;
        lowerSideDummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.COMPOUND_SIDE);
        lowerSideDummy.setProperty(Properties.SIDE_OWNER, openingBorder);
        if (layerNodes.size() == lowerIndex) {
            lowerSideDummy.setLayer(layer);
        } else {
            lowerSideDummy.setLayer(lowerIndex + 1, layer);
        }
        LNode upperSideDummy = new LNode();
        upperSideDummy.setProperty(LayoutOptions.ALIGNMENT, (Object)Alignment.LEFT);
        upperSideDummy.getSize().y = insets.getTop() + borderSpacing;
        upperSideDummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.COMPOUND_SIDE);
        upperSideDummy.setProperty(Properties.SIDE_OWNER, openingBorder);
        upperSideDummy.setLayer(upperIndex, layer);
        LPort lowPortWest = new LPort();
        lowPortWest.setSide(PortSide.WEST);
        lowPortWest.setNode(lowerSideDummy);
        LPort lowPortEast = new LPort();
        lowPortEast.setSide(PortSide.EAST);
        lowPortEast.setNode(lowerSideDummy);
        LPort highPortWest = new LPort();
        highPortWest.setSide(PortSide.WEST);
        highPortWest.setNode(upperSideDummy);
        LPort highPortEast = new LPort();
        highPortEast.setSide(PortSide.EAST);
        highPortEast.setNode(upperSideDummy);
        if (lowerConnector != null) {
            lowerConnector.setTarget(lowPortWest);
        }
        if (upperConnector != null) {
            upperConnector.setTarget(highPortWest);
        }
        if (startIndex < endIndex) {
            LEdge lowerEdge = new LEdge();
            LEdge upperEdge = new LEdge();
            lowerEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_SIDE);
            upperEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_SIDE);
            lowerEdge.setSource(lowPortEast);
            upperEdge.setSource(highPortEast);
            this.insertSideDummies(startIndex + 1, endIndex, layers, openingBorder, lowerEdge, upperEdge);
        }
    }

    public static Layer findSpanEnd(LNode upperBorder, List<Layer> layers) {
        LNode spanEndNode = null;
        block0: for (Layer layer : layers) {
            for (LNode lnode : layer) {
                if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_BORDER || lnode.getProperty(Properties.ORIGIN) != upperBorder.getProperty(Properties.ORIGIN)) continue;
                spanEndNode = lnode;
                continue block0;
            }
        }
        Layer ret = spanEndNode.getLayer();
        return ret;
    }

    private int findUltimateIndex(Layer layer, LNode upperBorder, boolean lowerSide) {
        List<LNode> nodes = layer.getNodes();
        KNode upperBorderOrigin = (KNode)upperBorder.getProperty(Properties.ORIGIN);
        int ret = 0;
        if (!lowerSide) {
            ret = nodes.size() - 1;
        }
        for (LNode lnode : nodes) {
            LNode portNode;
            KNode originPortNode;
            KNode origin;
            if (lnode.getProperty(Properties.ORIGIN) instanceof KNode && CompoundKGraphImporter.isDescendant(upperBorderOrigin, origin = (KNode)lnode.getProperty(Properties.ORIGIN))) {
                ret = this.compareIndex(lnode, ret, lowerSide);
            }
            if (lnode.getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
                LNode sourceNode = lnode.getProperty(Properties.LONG_EDGE_SOURCE).getNode();
                LNode targetNode = lnode.getProperty(Properties.LONG_EDGE_TARGET).getNode();
                if (Util.isDescendant(sourceNode, upperBorder) || Util.isDescendant(targetNode, upperBorder)) {
                    ret = this.compareIndex(lnode, ret, lowerSide);
                }
            }
            if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.NORTH_SOUTH_PORT || !KimlUtil.isDescendant(originPortNode = (KNode)(portNode = lnode.getProperty(Properties.IN_LAYER_LAYOUT_UNIT)).getProperty(Properties.ORIGIN), upperBorderOrigin)) continue;
            ret = this.compareIndex(lnode, ret, lowerSide);
        }
        return ret;
    }

    private int compareIndex(LNode lnode, int actualValue, boolean lowerSide) {
        int test = lnode.getIndex();
        int ret = 0;
        ret += actualValue;
        if (lowerSide) {
            if (test > ret) {
                ret = test;
            }
        } else if (test < ret) {
            ret = test;
        }
        return ret;
    }
}

