/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.intermediate.CompoundSideProcessor;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;

public class CompoundGraphRestorer
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Remove dummy edges and nodes, set node and edge positionsand node size for compound nodes", 1.0f);
        LinkedList<LNode> compoundNodeList = new LinkedList<LNode>();
        LinkedList<LNode> removables = new LinkedList<LNode>();
        LinkedList<LEdge> edgeList = new LinkedList<LEdge>();
        for (Layer layer : layeredGraph) {
            for (LNode lnode : layer) {
                NodeType nodeType = lnode.getProperty(Properties.NODE_TYPE);
                if (nodeType == NodeType.UPPER_COMPOUND_BORDER) {
                    compoundNodeList.add(lnode);
                } else if (nodeType == NodeType.LOWER_COMPOUND_BORDER || nodeType == NodeType.COMPOUND_SIDE || nodeType == NodeType.LOWER_COMPOUND_PORT || nodeType == NodeType.UPPER_COMPOUND_PORT) {
                    removables.add(lnode);
                }
                for (LEdge edge : lnode.getOutgoingEdges()) {
                    edgeList.add(edge);
                }
            }
        }
        for (LNode compoundNode : compoundNodeList) {
            KInsets insets = compoundNode.getProperty(Properties.ORIGINAL_INSETS);
            float ownBorderSpacing = compoundNode.getProperty(Properties.BORDER_SPACING).floatValue();
            KVector posLeftUpper = this.findSideNodePos(compoundNode, false, true, layeredGraph);
            KVector posRightUpper = this.findSideNodePos(compoundNode, false, false, layeredGraph);
            KVector posLeftLower = this.findSideNodePos(compoundNode, true, true, layeredGraph);
            KVector positionDifference = new KVector(0.0, 0.0);
            KVector compoundPosition = compoundNode.getPosition();
            positionDifference.x += compoundPosition.x;
            positionDifference.y += compoundPosition.y;
            positionDifference.sub(posLeftUpper);
            compoundNode.setProperty(Properties.POSITION_DIFFERENCE, positionDifference);
            compoundNode.getPosition().x = posLeftUpper.x;
            compoundNode.getPosition().y = posLeftUpper.y;
            compoundNode.getSize().x = posRightUpper.x - posLeftUpper.x + (double)insets.getRight() + (double)ownBorderSpacing;
            compoundNode.getSize().y = posLeftLower.y - posLeftUpper.y + (double)insets.getBottom() + (double)ownBorderSpacing;
        }
        for (LEdge ledge : edgeList) {
            EdgeType edgeType = ledge.getProperty(Properties.EDGE_TYPE);
            if (edgeType == EdgeType.COMPOUND_DUMMY || edgeType == EdgeType.COMPOUND_SIDE) {
                ledge.getSource().getOutgoingEdges().remove(ledge);
                ledge.getTarget().getIncomingEdges().remove(ledge);
                continue;
            }
            LPort sourcePort = ledge.getSource();
            LNode sourceNode = sourcePort.getNode();
            NodeType sourceNodeType = sourceNode.getProperty(Properties.NODE_TYPE);
            LNode compoundNodeSource = sourceNode.getProperty(Properties.COMPOUND_NODE);
            LPort targetPort = ledge.getTarget();
            LNode targetNode = targetPort.getNode();
            switch (sourceNodeType) {
                case LOWER_COMPOUND_BORDER: {
                    LPort newPort = this.transferPort(sourcePort, compoundNodeSource);
                    ledge.setSource(newPort);
                    break;
                }
                case UPPER_COMPOUND_PORT: 
                case LOWER_COMPOUND_PORT: {
                    LPort newPort2 = this.transferPort(sourcePort, compoundNodeSource);
                    newPort2.setProperty(Properties.ORIGIN, sourcePort.getProperty(Properties.ORIGIN));
                    ledge.setSource(newPort2);
                    break;
                }
                case UPPER_COMPOUND_BORDER: {
                    if (!Util.isDescendant(targetNode, sourceNode)) break;
                    LPort newPort3 = this.transferPort(sourcePort, compoundNodeSource);
                    ledge.setSource(newPort3);
                    break;
                }
            }
            NodeType targetNodeType = targetNode.getProperty(Properties.NODE_TYPE);
            LNode compoundNodeTarget = targetNode.getProperty(Properties.COMPOUND_NODE);
            switch (targetNodeType) {
                case LOWER_COMPOUND_BORDER: {
                    LPort newPort = this.transferPort(targetPort, compoundNodeTarget);
                    ledge.setTarget(newPort);
                    break;
                }
                case UPPER_COMPOUND_PORT: 
                case LOWER_COMPOUND_PORT: {
                    LPort newPort2 = this.transferPort(targetPort, compoundNodeTarget);
                    newPort2.setProperty(Properties.ORIGIN, targetPort.getProperty(Properties.ORIGIN));
                    ledge.setTarget(newPort2);
                    break;
                }
            }
        }
        for (LNode removable : removables) {
            List<LNode> layerNodes = removable.getLayer().getNodes();
            layerNodes.remove(removable);
        }
        this.getMonitor().done();
    }

    private LPort transferPort(LPort dummyPort, LNode compoundNode) {
        LNode dummyNode = dummyPort.getNode();
        NodeType dummyNodeType = dummyNode.getProperty(Properties.NODE_TYPE);
        LPort newPort = new LPort();
        newPort.setNode(compoundNode);
        newPort.copyProperties(dummyPort);
        newPort.getSize().x = dummyPort.getSize().x;
        newPort.getSize().y = dummyPort.getSize().y;
        PortSide newPortSide = dummyNodeType == NodeType.LOWER_COMPOUND_BORDER || dummyNodeType == NodeType.LOWER_COMPOUND_PORT ? PortSide.EAST : PortSide.WEST;
        newPort.getPosition().x = newPortSide == PortSide.EAST ? compoundNode.getSize().x + dummyPort.getSize().x / 2.0 : -(dummyPort.getSize().x / 2.0);
        double nodeDiffY = dummyNode.getPosition().y - compoundNode.getPosition().y;
        newPort.getPosition().y = dummyPort.getPosition().y + nodeDiffY;
        newPort.setSide(newPortSide);
        return newPort;
    }

    private KVector findSideNodePos(LNode lnode, boolean lower, boolean left, LayeredGraph lGraph) {
        Layer layer;
        if (left) {
            layer = lnode.getLayer();
        } else {
            List<Layer> layerList = lGraph.getLayers();
            layer = CompoundSideProcessor.findSpanEnd(lnode, layerList);
        }
        int index = layer.getNodes().size() - 1;
        if (lower) {
            index = 0;
        }
        for (LNode layerNode : layer) {
            if (layerNode.getProperty(Properties.NODE_TYPE) != NodeType.COMPOUND_SIDE || layerNode.getProperty(Properties.SIDE_OWNER) != lnode) continue;
            int test = layerNode.getIndex();
            if (lower) {
                if (test <= index) continue;
                index = test;
                continue;
            }
            if (test >= index) continue;
            index = test;
        }
        KVector ret = layer.getNodes().get(index).getPosition();
        return ret;
    }
}

