/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;

public class CompoundDummyEdgeRemover
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Removing compound dummy edges", 1.0f);
        List<Layer> layerList = layeredGraph.getLayers();
        LinkedList<LEdge> dummyEdgeList = new LinkedList<LEdge>();
        for (Layer layer : layerList) {
            for (LNode lNode : layer) {
                for (LEdge lEdge : lNode.getOutgoingEdges()) {
                    if (lEdge.getProperty(Properties.EDGE_TYPE) != EdgeType.COMPOUND_DUMMY) continue;
                    dummyEdgeList.add(lEdge);
                }
            }
        }
        for (LEdge lEdge : dummyEdgeList) {
            lEdge.getSource().getOutgoingEdges().remove(lEdge);
            lEdge.getTarget().getIncomingEdges().remove(lEdge);
        }
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                List<LPort> ports = node.getPorts();
                LinkedList<LPort> removables = new LinkedList<LPort>();
                int j = 0;
                while (j < ports.size()) {
                    LPort port = ports.get(j);
                    if (port.getIncomingEdges().isEmpty() && port.getOutgoingEdges().isEmpty()) {
                        removables.add(port);
                    }
                    ++j;
                }
                int k = 0;
                while (k < removables.size()) {
                    ports.remove(removables.get(k));
                    ++k;
                }
            }
        }
        this.getMonitor().done();
    }
}

