/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p1cycles.GreedyCycleBreaker;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundCycleProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    private HashMap<LEdge, LEdge> dummyEdgeMap = new HashMap();

    @Override
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Revert edges to remove cyclic dependencies between compound nodes", 1.0f);
        LayeredGraph cycleRemovalGraph = new LayeredGraph();
        cycleRemovalGraph.setProperty(Properties.RANDOM, layeredGraph.getProperty(Properties.RANDOM));
        List<LNode> cycleRemovalNodes = cycleRemovalGraph.getLayerlessNodes();
        HashMap<LNode, LNode> insertedNodes = new HashMap<LNode, LNode>();
        LinkedList<LEdge> toDescendantEdges = new LinkedList<LEdge>();
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            for (LEdge edge : lnode.getOutgoingEdges()) {
                int depthTarget;
                List<LEdge> portIncomingEdges;
                LNode targetNode;
                EdgeType edgeType = edge.getProperty(Properties.EDGE_TYPE);
                if (edgeType != EdgeType.NORMAL) continue;
                boolean isDescendantEdge = false;
                LNode sourceNode = edge.getSource().getNode();
                if (Util.isDescendant(sourceNode, targetNode = edge.getTarget().getNode()) || Util.isDescendant(targetNode, sourceNode)) {
                    isDescendantEdge = true;
                }
                LGraphElement sourceParent = Util.getParent(sourceNode);
                LGraphElement targetParent = Util.getParent(targetNode);
                LNode currentSource = sourceNode;
                LNode currentTarget = targetNode;
                LGraphElement currentSourceAncestor = sourceParent;
                LGraphElement currentTargetAncestor = targetParent;
                NodeType sourceNType = sourceNode.getProperty(Properties.NODE_TYPE);
                if ((sourceNType == NodeType.LOWER_COMPOUND_PORT || sourceNType == NodeType.UPPER_COMPOUND_PORT) && Util.isDescendant(targetNode, sourceNode.getProperty(Properties.COMPOUND_NODE)) && !(portIncomingEdges = edge.getSource().getIncomingEdges()).isEmpty()) {
                    boolean descendantIncoming = false;
                    for (LEdge ledge : portIncomingEdges) {
                        if (Util.isDescendant(ledge.getSource().getNode(), ledge.getTarget().getNode().getProperty(Properties.COMPOUND_NODE))) {
                            descendantIncoming = true;
                        }
                        if (!descendantIncoming) continue;
                        toDescendantEdges.add(edge);
                    }
                }
                LinkedList<LNode> sourceChildren = Util.getChildren(sourceNode);
                LinkedList<LNode> targetChildren = Util.getChildren(targetNode);
                if (!(currentSourceAncestor != currentTargetAncestor || !Util.getChildren(sourceNode).isEmpty() && !Util.getChildren(targetNode).isEmpty() || sourceChildren.isEmpty() && !targetChildren.isEmpty()) && (sourceChildren.isEmpty() || !targetChildren.isEmpty())) continue;
                int depthSource = sourceNode.getProperty(Properties.DEPTH);
                if (depthSource != (depthTarget = targetNode.getProperty(Properties.DEPTH).intValue())) {
                    int i = depthSource;
                    while (i > depthTarget) {
                        LGraphElement sourceNextParent = Util.getParent(currentSource);
                        assert (sourceNextParent instanceof LNode);
                        currentSource = (LNode)sourceNextParent;
                        --i;
                    }
                    int j = depthTarget;
                    while (j > depthSource) {
                        LGraphElement targetNextParent = Util.getParent(currentTarget);
                        assert (targetNextParent instanceof LNode);
                        currentTarget = (LNode)targetNextParent;
                        --j;
                    }
                }
                if (currentSource == currentTarget) continue;
                currentSourceAncestor = Util.getParent(currentSource);
                currentTargetAncestor = Util.getParent(currentTarget);
                while (currentSourceAncestor != currentTargetAncestor) {
                    assert (currentSourceAncestor instanceof LNode);
                    assert (currentTargetAncestor instanceof LNode);
                    currentSource = (LNode)currentSourceAncestor;
                    currentTarget = (LNode)currentTargetAncestor;
                    currentSourceAncestor = Util.getParent(currentSource);
                    currentTargetAncestor = Util.getParent(currentTarget);
                }
                NodeType sourceNodeType = currentSource.getProperty(Properties.NODE_TYPE);
                NodeType targetNodeType = currentTarget.getProperty(Properties.NODE_TYPE);
                if (sourceNodeType != NodeType.NORMAL && sourceNodeType != NodeType.UPPER_COMPOUND_BORDER) {
                    currentSource = currentSource.getProperty(Properties.COMPOUND_NODE);
                }
                if (targetNodeType != NodeType.NORMAL && targetNodeType != NodeType.UPPER_COMPOUND_BORDER) {
                    currentTarget = currentTarget.getProperty(Properties.COMPOUND_NODE);
                }
                this.insertCycleNode(currentSource, insertedNodes, cycleRemovalNodes);
                this.insertCycleNode(currentTarget, insertedNodes, cycleRemovalNodes);
                if (!isDescendantEdge) {
                    NodeType nodeTypeDummySource = currentSource.getProperty(Properties.NODE_TYPE);
                    if (nodeTypeDummySource == NodeType.NORMAL) {
                        this.insertDummyEdge(currentTarget, currentSource, edge);
                    } else {
                        for (LNode node : layeredGraph.getLayerlessNodes()) {
                            if (node.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_BORDER && node.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_PORT || node.getProperty(Properties.COMPOUND_NODE) != currentSource) continue;
                            this.insertDummyEdge(currentTarget, node, edge);
                        }
                    }
                }
                LEdge cycleGraphEdge = new LEdge();
                cycleGraphEdge.setProperty(Properties.ORIGIN, edge);
                LPort cycleSourcePort = new LPort();
                LPort cycleTargetPort = new LPort();
                cycleGraphEdge.setSource(cycleSourcePort);
                cycleGraphEdge.setTarget(cycleTargetPort);
                cycleSourcePort.setNode(insertedNodes.get(currentSource));
                cycleTargetPort.setNode(insertedNodes.get(currentTarget));
            }
        }
        this.reverseCyclicEdges(layeredGraph, cycleRemovalGraph);
        int toDescendantSize = toDescendantEdges.size();
        int i = 0;
        while (i < toDescendantSize) {
            LEdge edge;
            edge = (LEdge)toDescendantEdges.get(i);
            if (!edge.getProperty(Properties.REVERSED).booleanValue()) {
                edge.reverse(true);
            }
            ++i;
        }
        this.getMonitor().done();
    }

    private void insertDummyEdge(LNode target, LNode source, LEdge edge) {
        LEdge dummyEdge = new LEdge();
        this.dummyEdgeMap.put(edge, dummyEdge);
        dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
        LPort dummyPortSource = new LPort();
        LPort dummyPortTarget = new LPort();
        dummyEdge.setSource(dummyPortSource);
        dummyEdge.setTarget(dummyPortTarget);
        dummyPortTarget.setNode(target);
        dummyPortSource.setNode(source);
    }

    private void insertCycleNode(LNode node, HashMap<LNode, LNode> insertedNodes, List<LNode> cycleRemovalNodes) {
        if (!insertedNodes.containsKey(node)) {
            LNode cycleGraphNode = new LNode();
            cycleGraphNode.setProperty(Properties.ORIGIN, node);
            insertedNodes.put(node, cycleGraphNode);
            cycleRemovalNodes.add(cycleGraphNode);
        }
    }

    private void reverseCyclicEdges(LayeredGraph layeredGraph, LayeredGraph cycleRemovalGraph) {
        LinkedList<LEdge> edgesToReverse = new LinkedList<LEdge>();
        GreedyCycleBreaker cycleBreaker = new GreedyCycleBreaker();
        cycleBreaker.process(cycleRemovalGraph);
        for (LNode lnode : cycleRemovalGraph.getLayerlessNodes()) {
            for (LEdge ledge : lnode.getOutgoingEdges()) {
                if (!ledge.getProperty(Properties.REVERSED).booleanValue()) continue;
                edgesToReverse.add((LEdge)ledge.getProperty(Properties.ORIGIN));
            }
        }
        this.reverseEdges(edgesToReverse, layeredGraph);
    }

    private void reverseEdges(LinkedList<LEdge> edgeList, LayeredGraph layeredGraph) {
        int i = 0;
        while (i < edgeList.size()) {
            LEdge dummyEdge;
            LEdge edge = edgeList.get(i);
            LPort source = edge.getSource();
            LPort target = edge.getTarget();
            LNode sourceNode = source.getNode();
            LNode targetNode = target.getNode();
            NodeType sourceNodeType = sourceNode.getProperty(Properties.NODE_TYPE);
            NodeType targetNodeType = targetNode.getProperty(Properties.NODE_TYPE);
            LPort newSource = edge.getTarget();
            LPort newTarget = edge.getSource();
            if (sourceNodeType != NodeType.NORMAL) {
                newSource = this.getOppositePort(target, layeredGraph);
            }
            if (targetNodeType != NodeType.NORMAL) {
                newTarget = this.getOppositePort(source, layeredGraph);
            }
            edge.setSource(newSource);
            edge.setTarget(newTarget);
            edge.setProperty(Properties.REVERSED, true);
            LinkedList<LEdge> removableEdges = new LinkedList<LEdge>();
            if (sourceNodeType == NodeType.LOWER_COMPOUND_PORT) {
                for (LEdge ledge : sourceNode.getConnectedEdges()) {
                    removableEdges.add(ledge);
                }
                for (LEdge ledge : removableEdges) {
                    ledge.getTarget().getIncomingEdges().remove(ledge);
                    ledge.getSource().getOutgoingEdges().remove(ledge);
                }
                layeredGraph.getLayerlessNodes().remove(sourceNode);
            }
            if (targetNodeType == NodeType.UPPER_COMPOUND_PORT) {
                for (LEdge ledge : targetNode.getConnectedEdges()) {
                    removableEdges.add(ledge);
                }
                for (LEdge ledge : removableEdges) {
                    ledge.getTarget().getIncomingEdges().remove(ledge);
                    ledge.getSource().getOutgoingEdges().remove(ledge);
                }
                layeredGraph.getLayerlessNodes().remove(targetNode);
            }
            if ((dummyEdge = this.dummyEdgeMap.get(edge)) != null) {
                dummyEdge.getSource().getOutgoingEdges().remove(dummyEdge);
                dummyEdge.getTarget().getIncomingEdges().remove(dummyEdge);
            }
            ++i;
        }
    }

    private LPort getOppositePort(LPort port, LayeredGraph layeredGraph) {
        float edgeSpacing = layeredGraph.getProperty(Properties.EDGE_SPACING_FACTOR).floatValue() * layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        PortSide portSide = port.getSide();
        PortSide newSide = portSide == PortSide.EAST ? PortSide.WEST : PortSide.EAST;
        LPort newPort = new LPort();
        newPort.getSize().x = port.getSize().x;
        newPort.getSize().y = port.getSize().y;
        newPort.copyProperties(port);
        newPort.setSide(newSide);
        LNode node = port.getNode();
        NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
        switch (nodeType) {
            case UPPER_COMPOUND_BORDER: {
                LShape lowerBorder = null;
                for (LNode lnode : layeredGraph.getLayerlessNodes()) {
                    if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_BORDER || lnode.getProperty(Properties.COMPOUND_NODE) != node) continue;
                    lowerBorder = lnode;
                    break;
                }
                newPort.setNode((LNode)lowerBorder);
                lowerBorder.getSize().y += (double)edgeSpacing;
                break;
            }
            case UPPER_COMPOUND_PORT: {
                LNode newLowerCompoundPort = new LNode();
                newLowerCompoundPort.copyProperties(node);
                newLowerCompoundPort.setProperty(Properties.NODE_TYPE, (Object)NodeType.LOWER_COMPOUND_PORT);
                newLowerCompoundPort.setProperty(Properties.COMPOUND_NODE, node.getProperty(Properties.COMPOUND_NODE));
                LPort dummyConnectionPort = new LPort();
                dummyConnectionPort.setSide(PortSide.WEST);
                dummyConnectionPort.setNode(newLowerCompoundPort);
                for (LNode child : Util.getChildren(node)) {
                    LEdge dummyEdge = new LEdge();
                    dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                    LPort startPort = child.getPorts(PortSide.WEST).iterator().next();
                    dummyEdge.setSource(startPort);
                    dummyEdge.setTarget(dummyConnectionPort);
                }
                newPort.setNode(newLowerCompoundPort);
                layeredGraph.getLayerlessNodes().add(newLowerCompoundPort);
                break;
            }
            case LOWER_COMPOUND_BORDER: {
                LNode upperBorder = node.getProperty(Properties.COMPOUND_NODE);
                newPort.setNode(upperBorder);
                upperBorder.getSize().y += (double)edgeSpacing;
                break;
            }
            case LOWER_COMPOUND_PORT: {
                LNode newUpperCompoundPort = new LNode();
                newUpperCompoundPort.copyProperties(node);
                newUpperCompoundPort.setProperty(Properties.NODE_TYPE, (Object)NodeType.UPPER_COMPOUND_PORT);
                newUpperCompoundPort.setProperty(Properties.COMPOUND_NODE, node.getProperty(Properties.COMPOUND_NODE));
                LPort dummyConnector = new LPort();
                dummyConnector.setSide(PortSide.EAST);
                dummyConnector.setNode(newUpperCompoundPort);
                for (LNode child : Util.getChildren(node)) {
                    LEdge dummyEdge = new LEdge();
                    dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                    LPort endPort = child.getPorts(PortSide.EAST).iterator().next();
                    dummyEdge.setSource(dummyConnector);
                    dummyEdge.setTarget(endPort);
                }
                newPort.setNode(newUpperCompoundPort);
                layeredGraph.getLayerlessNodes().add(newUpperCompoundPort);
                layeredGraph.getLayerlessNodes().remove(node);
                break;
            }
        }
        return newPort;
    }
}

