/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CommentPreprocessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Comment pre-processing", 1.0f);
        Iterator<LNode> nodeIter = layeredGraph.getLayerlessNodes().iterator();
        while (nodeIter.hasNext()) {
            LNode node = nodeIter.next();
            if (!node.getProperty(LayoutOptions.COMMENT_BOX).booleanValue()) continue;
            int edgeCount = 0;
            LEdge edge = null;
            LPort oppositePort = null;
            for (LPort port : node.getPorts()) {
                edgeCount += port.getDegree();
                if (port.getIncomingEdges().size() == 1) {
                    edge = port.getIncomingEdges().get(0);
                    oppositePort = edge.getSource();
                }
                if (port.getOutgoingEdges().size() != 1) continue;
                edge = port.getOutgoingEdges().get(0);
                oppositePort = edge.getTarget();
            }
            if (edgeCount == 1 && oppositePort.getDegree() == 1 && !oppositePort.getNode().getProperty(LayoutOptions.COMMENT_BOX).booleanValue()) {
                this.processBox(node, edge, oppositePort, oppositePort.getNode());
                nodeIter.remove();
                continue;
            }
            LinkedList<LEdge> revEdges = new LinkedList<LEdge>();
            for (LPort port : node.getPorts()) {
                for (LEdge outedge : port.getOutgoingEdges()) {
                    if (outedge.getTarget().getOutgoingEdges().isEmpty()) continue;
                    revEdges.add(outedge);
                }
                for (LEdge inedge : port.getIncomingEdges()) {
                    if (inedge.getSource().getIncomingEdges().isEmpty()) continue;
                    revEdges.add(inedge);
                }
            }
            for (LEdge re : revEdges) {
                re.reverse(true);
            }
        }
        this.getMonitor().done();
    }

    private void processBox(LNode box, LEdge edge, LPort oppositePort, LNode realNode) {
        List<Object> boxList;
        boolean topFirst;
        boolean onlyTop = false;
        boolean onlyBottom = false;
        if (realNode.getProperty(LayoutOptions.PORT_CONSTRAINTS).isSideFixed()) {
            boolean hasNorth = false;
            boolean hasSouth = false;
            block0: for (LPort port1 : realNode.getPorts()) {
                for (LPort port2 : port1.getConnectedPorts()) {
                    if (port2.getNode().getProperty(LayoutOptions.COMMENT_BOX).booleanValue()) continue;
                    if (port1.getSide() == PortSide.NORTH) {
                        hasNorth = true;
                        break block0;
                    }
                    if (port1.getSide() != PortSide.SOUTH) continue;
                    hasSouth = true;
                    break block0;
                }
            }
            onlyTop = hasSouth && !hasNorth;
            boolean bl = onlyBottom = hasNorth && !hasSouth;
        }
        if (!(onlyTop || onlyBottom || realNode.getLabels().isEmpty())) {
            double labelPos = 0.0;
            for (LLabel label : realNode.getLabels()) {
                labelPos += label.getPosition().y + label.getSize().y / 2.0;
            }
            topFirst = (labelPos /= (double)realNode.getLabels().size()) >= realNode.getSize().y / 2.0;
        } else {
            boolean bl = topFirst = !onlyBottom;
        }
        if (topFirst) {
            List<LNode> topBoxes = realNode.getProperty(Properties.TOP_COMMENTS);
            if (topBoxes == null) {
                boxList = new LinkedList();
                realNode.setProperty(Properties.TOP_COMMENTS, boxList);
            } else if (onlyTop) {
                boxList = topBoxes;
            } else {
                List<LNode> bottomBoxes = realNode.getProperty(Properties.BOTTOM_COMMENTS);
                if (bottomBoxes == null) {
                    boxList = new LinkedList();
                    realNode.setProperty(Properties.BOTTOM_COMMENTS, boxList);
                } else {
                    boxList = topBoxes.size() <= bottomBoxes.size() ? topBoxes : bottomBoxes;
                }
            }
        } else {
            List<LNode> bottomBoxes = realNode.getProperty(Properties.BOTTOM_COMMENTS);
            if (bottomBoxes == null) {
                boxList = new LinkedList();
                realNode.setProperty(Properties.BOTTOM_COMMENTS, boxList);
            } else if (onlyBottom) {
                boxList = bottomBoxes;
            } else {
                List<LNode> topBoxes = realNode.getProperty(Properties.TOP_COMMENTS);
                if (topBoxes == null) {
                    boxList = new LinkedList();
                    realNode.setProperty(Properties.TOP_COMMENTS, boxList);
                } else {
                    boxList = bottomBoxes.size() <= topBoxes.size() ? bottomBoxes : topBoxes;
                }
            }
        }
        boxList.add(box);
        box.setProperty(Properties.COMMENT_CONN_PORT, oppositePort);
        if (edge.getTarget() == oppositePort) {
            edge.setTarget(null);
            if (oppositePort.getDegree() == 0) {
                oppositePort.setNode(null);
            }
        } else {
            edge.setSource(null);
            if (oppositePort.getDegree() == 0) {
                oppositePort.setNode(null);
            }
        }
        edge.getBendPoints().clear();
    }
}

