/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class BigNodesProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    private LayeredGraph layeredGraph;
    private Collection<LNode> nodes;
    private int[] width;
    private int[] layer;
    private int longestPath;
    private LinkedHashMap<LNode, Integer> nodeIDs;

    public void process(LayeredGraph theLayeredGraph) {
        assert (theLayeredGraph != null);
        this.nodes = theLayeredGraph.getLayerlessNodes();
        this.layeredGraph = theLayeredGraph;
        int counter = 0;
        for (LNode node : this.nodes) {
            node.id = counter++;
        }
        LinkedList<LNode> dummyNodes = new LinkedList<LNode>();
        double minSpacing = this.layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        int dummyID = this.nodes.size();
        LinkedList<LPort> ports = null;
        double minWidth = 3.4028234663852886E38;
        for (LNode node : this.nodes) {
            if (!(node.getSize().x < minWidth)) continue;
            minWidth = node.getSize().x;
        }
        if (this.width == null || this.width.length < this.nodes.size()) {
            this.width = new int[this.nodes.size()];
        }
        Arrays.fill(this.width, 1);
        minWidth /= 2.0;
        for (LNode node : this.nodes) {
            double threshold = 2.0 * minWidth + minSpacing;
            while (threshold <= node.getSize().x) {
                int n = node.id;
                this.width[n] = this.width[n] + 1;
                threshold += minWidth + minSpacing;
            }
            node.getSize().x = minWidth;
            if (this.width[node.id] <= 1) continue;
            ports = new LinkedList<LPort>();
            for (LPort port : node.getPorts()) {
                if (port.getOutgoingEdges().isEmpty()) continue;
                ports.add(port);
            }
            int d = 1;
            while (d < this.width[node.id]) {
                LNode dummy = new LNode();
                dummy.id = dummyID++;
                dummy.getSize().y = node.getSize().y;
                dummy.getSize().x = minWidth;
                LPort outPort = new LPort();
                LPort inPort = new LPort();
                outPort.setNode(d == 1 ? node : (LNode)dummyNodes.getLast());
                inPort.setNode(dummy);
                LEdge edge = new LEdge();
                edge.setSource(outPort);
                edge.setTarget(inPort);
                edge.setProperty(Properties.PRIORITY, 1);
                dummyNodes.add(dummy);
                ++d;
            }
            for (LPort port : ports) {
                port.setNode((LNode)dummyNodes.getLast());
            }
        }
        this.nodes.addAll(dummyNodes);
        this.nodeIDs = new LinkedHashMap(this.nodes.size());
        for (LNode node : this.nodes) {
            this.nodeIDs.put(node, new Integer(node.id));
        }
    }

    public void segmentateLayering() {
        assert (this.nodeIDs != null);
        Integer id = null;
        assert (this.nodes.size() == this.nodeIDs.size());
        for (LNode node : this.nodes) {
            id = this.nodeIDs.get(node);
            assert (id != null);
            node.id = id;
        }
        this.convertLayering();
        ArrayList buckets = new ArrayList(this.longestPath << 1);
        int i = 0;
        while (i < this.longestPath << 1) {
            buckets.add(new LinkedList());
            ++i;
        }
        LinkedList bucket = null;
        for (LNode node : this.nodes) {
            if (node.id >= this.width.length || this.width[node.id] <= 1) continue;
            bucket = (LinkedList)buckets.get(this.layer[node.id]);
            if (bucket.isEmpty() || this.width[((LNode)bucket.getFirst()).id] < this.width[node.id]) {
                bucket.addFirst(node);
                continue;
            }
            bucket.addLast(node);
        }
        int curIndex = 0;
        int targetIndex = -1;
        int restrIndex = -1;
        LNode curNode = null;
        Iterator iterator = null;
        while (curIndex < buckets.size()) {
            LinkedList curBucket = (LinkedList)buckets.get(curIndex);
            if (!curBucket.isEmpty()) {
                if (restrIndex < curIndex) {
                    restrIndex = curIndex + this.width[((LNode)curBucket.getFirst()).id] - 1;
                }
                iterator = curBucket.iterator();
                while (iterator.hasNext()) {
                    curNode = (LNode)iterator.next();
                    targetIndex = -1;
                    if (curIndex + this.width[curNode.id] - 1 > restrIndex) {
                        targetIndex = restrIndex + 1;
                    } else if (this.layer[curNode.id] > curIndex) {
                        targetIndex = this.layer[curNode.id];
                    }
                    if (targetIndex == -1) continue;
                    while (targetIndex >= buckets.size()) {
                        buckets.add(new LinkedList());
                    }
                    LinkedList targetBucket = (LinkedList)buckets.get(targetIndex);
                    if (targetBucket.isEmpty() || this.width[((LNode)targetBucket.getFirst()).id] < this.width[curNode.id]) {
                        targetBucket.addFirst(curNode);
                    } else {
                        targetBucket.addLast(curNode);
                    }
                    iterator.remove();
                    this.minimalLayer(curNode, targetIndex);
                }
            }
            ++curIndex;
        }
        this.putNodes();
    }

    private void minimalLayer(LNode node, int start) {
        this.layer[node.id] = Math.max(this.layer[node.id], start);
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getOutgoingEdges()) {
                this.minimalLayer(edge.getTarget().getNode(), start + 1);
            }
        }
        this.longestPath = Math.max(this.longestPath, this.layer[node.id]);
    }

    private void convertLayering() {
        if (this.layer == null || this.layer.length < this.nodes.size()) {
            this.layer = new int[this.nodes.size()];
        }
        int counter = 0;
        List<Layer> layers = this.layeredGraph.getLayers();
        for (Layer theLayer : layers) {
            theLayer.id = counter++;
        }
        for (LNode node : this.nodes) {
            this.layer[node.id] = node.getLayer().id;
        }
        this.longestPath = layers.size() - 1;
        layers.clear();
    }

    private void putNodes() {
        List<Layer> layers = this.layeredGraph.getLayers();
        while (this.longestPath-- >= 0) {
            layers.add(new Layer(this.layeredGraph));
        }
        for (LNode node : this.nodes) {
            node.setLayer(layers.get(this.layer[node.id]));
        }
        Iterator<Layer> iterator = layers.iterator();
        Layer curLayer = null;
        while (iterator.hasNext()) {
            curLayer = iterator.next();
            if (!curLayer.getNodes().isEmpty()) continue;
            iterator.remove();
        }
    }
}

