/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer
extends LGraphElement
implements Iterable<LNode> {
    private LayeredGraph owner;
    private KVector size = new KVector();
    private List<LNode> nodes = new LinkedList<LNode>();

    public Layer(LayeredGraph graph) {
        this.owner = graph;
    }

    public String toString() {
        return "L_" + this.getIndex() + this.nodes.toString();
    }

    public KVector getSize() {
        return this.size;
    }

    public List<LNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterator<LNode> iterator() {
        return this.nodes.iterator();
    }

    public LayeredGraph getGraph() {
        return this.owner;
    }

    public int getIndex() {
        return this.owner.getLayers().indexOf(this);
    }

    public void placeNodes(double xpos) {
        for (LNode node : this.nodes) {
            Alignment alignment = node.getProperty(LayoutOptions.ALIGNMENT);
            double room = this.size.x - node.getSize().x - node.getMargin().left - node.getMargin().right;
            double x = xpos;
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    x += room;
                    break;
                }
                case CENTER: {
                    x += room / 2.0;
                    break;
                }
                default: {
                    int inports = 0;
                    int outports = 0;
                    for (LPort port : node.getPorts()) {
                        if (!port.getIncomingEdges().isEmpty()) {
                            ++inports;
                        }
                        if (port.getOutgoingEdges().isEmpty()) continue;
                        ++outports;
                    }
                    if (inports + outports == 0) {
                        x += room / 2.0;
                        break;
                    }
                    x += room * (double)outports / (double)(inports + outports);
                }
            }
            node.getPosition().x = x + node.getMargin().left;
        }
    }
}

