/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.util.ICondition;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LPort
extends LShape {
    private LNode owner;
    private PortSide side = PortSide.UNDEFINED;
    private List<LLabel> labels = new LinkedList<LLabel>();
    private List<LEdge> incomingEdges = new LinkedList<LEdge>();
    private List<LEdge> outgoingEdges = new LinkedList<LEdge>();

    public String toString() {
        String text = this.getName();
        if (text == null) {
            return "p_" + this.id;
        }
        return "p_" + text;
    }

    public LNode getNode() {
        return this.owner;
    }

    public void setNode(LNode node) {
        if (this.owner != null) {
            this.owner.getPorts().remove(this);
        }
        this.owner = node;
        if (this.owner != null) {
            this.owner.getPorts().add(this);
        }
    }

    public PortSide getSide() {
        return this.side;
    }

    public void setSide(PortSide theside) {
        this.side = theside;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public int getDegree() {
        return this.incomingEdges.size() + this.outgoingEdges.size();
    }

    public int getNetFlow() {
        return this.incomingEdges.size() - this.outgoingEdges.size();
    }

    public List<LEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<LEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public Iterable<LEdge> getConnectedEdges() {
        return Iterables.concat(this.incomingEdges, this.outgoingEdges);
    }

    public Iterable<LPort> getPredecessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator edgesIter = LPort.this.incomingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)edgesIter.next()).getSource();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getSuccessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator edgesIter = LPort.this.outgoingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)edgesIter.next()).getTarget();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getConnectedPorts() {
        return Iterables.concat(this.getPredecessorPorts(), this.getSuccessorPorts());
    }

    public int getIndex() {
        if (this.owner == null) {
            return -1;
        }
        return this.owner.getPorts().indexOf(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SideCondition
    implements ICondition<LPort> {
        private PortSide condSide;

        public SideCondition(PortSide theside) {
            this.condSide = theside;
        }

        @Override
        public boolean evaluate(LPort object) {
            return object.side == this.condSide;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeCondition
    implements ICondition<LPort> {
        private PortType condType;

        public TypeCondition(PortType thetype) {
            this.condType = thetype;
        }

        @Override
        public boolean evaluate(LPort object) {
            switch (this.condType) {
                case INPUT: {
                    return !object.incomingEdges.isEmpty();
                }
                case OUTPUT: {
                    return !object.outgoingEdges.isEmpty();
                }
            }
            return true;
        }
    }
}

