/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.util.CompoundCondition;
import de.cau.cs.kieler.core.util.FilteredIterator;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LNode
extends LShape {
    private Layer owner;
    private List<LPort> ports = new LinkedList<LPort>();
    private List<LLabel> labels = new LinkedList<LLabel>();
    private LInsets.Double margin = new LInsets.Double();

    public String toString() {
        String name = this.getName();
        if (name == null) {
            return "n_" + this.id;
        }
        return "n_" + name;
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public Layer getLayer() {
        return this.owner;
    }

    public void setLayer(Layer layer) {
        if (this.owner != null) {
            this.owner.getNodes().remove(this);
        }
        this.owner = layer;
        if (this.owner != null) {
            this.owner.getNodes().add(this);
        }
    }

    public void setLayer(int index, Layer layer) {
        if (layer != null && (index < 0 || index > layer.getNodes().size())) {
            throw new IllegalArgumentException("index must be >= 0 and <= layer node count");
        }
        if (this.owner != null) {
            this.owner.getNodes().remove(this);
        }
        this.owner = layer;
        if (this.owner != null) {
            this.owner.getNodes().add(index, this);
        }
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    public Iterable<LPort> getPorts(PortType portType) {
        return new FilteredIterator.Iterable<LPort>(this.ports, new LPort.TypeCondition(portType));
    }

    public Iterable<LPort> getPorts(PortSide side) {
        return new FilteredIterator.Iterable<LPort>(this.ports, new LPort.SideCondition(side));
    }

    public Iterable<LPort> getPorts(PortType portType, PortSide side) {
        ArrayList conditions = new ArrayList();
        conditions.add(new LPort.TypeCondition(portType));
        conditions.add(new LPort.SideCondition(side));
        return new FilteredIterator.Iterable<LPort>(this.ports, new CompoundCondition(conditions));
    }

    public Iterable<LEdge> getIncomingEdges() {
        LinkedList<List<LEdge>> iterables = new LinkedList<List<LEdge>>();
        for (LPort port : this.ports) {
            iterables.add(port.getIncomingEdges());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<LEdge> getOutgoingEdges() {
        LinkedList<List<LEdge>> iterables = new LinkedList<List<LEdge>>();
        for (LPort port : this.ports) {
            iterables.add(port.getOutgoingEdges());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<LEdge> getConnectedEdges() {
        LinkedList<Iterable<LEdge>> iterables = new LinkedList<Iterable<LEdge>>();
        for (LPort port : this.ports) {
            iterables.add(port.getConnectedEdges());
        }
        return Iterables.concat(iterables);
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LInsets.Double getMargin() {
        return this.margin;
    }

    public int getIndex() {
        if (this.owner == null) {
            return -1;
        }
        return this.owner.getNodes().indexOf(this);
    }

    public void borderToContentAreaCoordinates(boolean horizontal, boolean vertical) {
        if (this.owner == null || this.owner.getGraph() == null) {
            throw new IllegalStateException("node is not assigned to a layer in a graph.");
        }
        LayeredGraph graph = this.owner.getGraph();
        LInsets.Double insets = graph.getInsets();
        float borderSpacing = graph.getProperty(Properties.BORDER_SPACING).floatValue();
        KVector offset = graph.getOffset();
        KVector pos = this.getPosition();
        if (horizontal) {
            pos.x = pos.x - insets.left - (double)borderSpacing - offset.x;
        }
        if (vertical) {
            pos.y = pos.y - insets.top - (double)borderSpacing - offset.y;
        }
    }

    public KVector getAnchorPointPosition(LayeredGraph graph) {
        switch (graph.getProperty(Properties.INTERACTIVE_LAYOUT_ANCHOR)) {
            case CENTER: {
                KVector nodePos = this.getPosition();
                KVector nodeSize = this.getSize();
                return new KVector(nodePos.x + nodeSize.x / 2.0, nodePos.y + nodeSize.y / 2.0);
            }
            case TOP_LEFT: {
                return new KVector(this.getPosition());
            }
        }
        return null;
    }
}

