/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LEdge
extends LGraphElement {
    private KVectorChain bendPoints = new KVectorChain();
    private LPort source;
    private LPort target;
    private List<LLabel> labels = new LinkedList<LLabel>();

    public String toString() {
        if (this.source != null && this.target != null) {
            return this.source.getNode() + "(" + this.source + ")->" + this.target.getNode() + "(" + this.target + ")";
        }
        return "e_" + this.hashCode();
    }

    public void reverse(boolean adaptPorts) {
        LPort oldSource = this.getSource();
        LPort oldTarget = this.getTarget();
        this.setSource(null);
        this.setTarget(null);
        if (adaptPorts && oldTarget.getProperty(Properties.INPUT_COLLECT).booleanValue()) {
            this.setSource(Util.provideCollectorPort(oldTarget.getNode(), PortType.OUTPUT, PortSide.EAST));
        } else {
            this.setSource(oldTarget);
        }
        if (adaptPorts && oldSource.getProperty(Properties.OUTPUT_COLLECT).booleanValue()) {
            this.setTarget(Util.provideCollectorPort(oldSource.getNode(), PortType.INPUT, PortSide.WEST));
        } else {
            this.setTarget(oldSource);
        }
        boolean reversed = this.getProperty(Properties.REVERSED);
        this.setProperty(Properties.REVERSED, !reversed);
        this.bendPoints = KVectorChain.reverse(this.bendPoints);
    }

    public LPort getSource() {
        return this.source;
    }

    public void setSource(LPort source) {
        if (this.source != null) {
            this.source.getOutgoingEdges().remove(this);
        }
        this.source = source;
        if (this.source != null) {
            this.source.getOutgoingEdges().add(this);
        }
    }

    public LPort getTarget() {
        return this.target;
    }

    public void setTarget(LPort target) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove(this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.getIncomingEdges().add(this);
        }
    }

    public KVectorChain getBendPoints() {
        return this.bendPoints;
    }

    public KVector getSourcePoint() {
        return this.source.getNode().getPosition().sumCreate(this.source.getPosition());
    }

    public KVector getTargetPoint() {
        return this.target.getNode().getPosition().sumCreate(this.target.getPosition());
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }
}

