/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static void centerPoint(KVector point, KVector boundary, PortSide side) {
        switch (side) {
            case NORTH: {
                point.x = boundary.x / 2.0;
                point.y = 0.0;
                break;
            }
            case EAST: {
                point.x = boundary.x;
                point.y = boundary.y / 2.0;
                break;
            }
            case SOUTH: {
                point.x = boundary.x / 2.0;
                point.y = boundary.y;
                break;
            }
            case WEST: {
                point.x = 0.0;
                point.y = boundary.y / 2.0;
            }
        }
    }

    public static LPort provideCollectorPort(LNode node, PortType type, PortSide side) {
        LPort port = null;
        switch (type) {
            case INPUT: {
                for (LPort inport : node.getPorts()) {
                    if (!inport.getProperty(Properties.INPUT_COLLECT).booleanValue()) continue;
                    return inport;
                }
                port = new LPort();
                port.setProperty(Properties.INPUT_COLLECT, true);
                break;
            }
            case OUTPUT: {
                for (LPort outport : node.getPorts()) {
                    if (!outport.getProperty(Properties.OUTPUT_COLLECT).booleanValue()) continue;
                    return outport;
                }
                port = new LPort();
                port.setProperty(Properties.OUTPUT_COLLECT, true);
            }
        }
        if (port != null) {
            port.setNode(node);
            port.setSide(side);
            Util.centerPoint(port.getPosition(), node.getSize(), side);
        }
        return port;
    }

    public static String getDebugOutputPath() {
        String path = System.getProperty("user.home");
        path = path.endsWith(File.separator) ? String.valueOf(path) + "tmp" + File.separator + "klay" : String.valueOf(path) + File.separator + "tmp" + File.separator + "klay";
        return path;
    }

    public static String getDebugOutputFileBaseName(LayeredGraph graph) {
        return String.valueOf(Integer.toString(graph.hashCode() & 0xFFFF)) + "-";
    }

    public static boolean isDescendant(LNode child, LNode parent) {
        LNode cParent = parent;
        LNode cChild = child;
        NodeType nodeTypeParent = parent.getProperty(Properties.NODE_TYPE);
        NodeType nodeTypeChild = child.getProperty(Properties.NODE_TYPE);
        if (nodeTypeParent != NodeType.NORMAL && nodeTypeParent != NodeType.UPPER_COMPOUND_BORDER) {
            cParent = parent.getProperty(Properties.COMPOUND_NODE);
        }
        if (nodeTypeChild != NodeType.NORMAL && nodeTypeChild != NodeType.UPPER_COMPOUND_BORDER) {
            cChild = child.getProperty(Properties.COMPOUND_NODE);
        }
        LNode current = cChild;
        LGraphElement currentParent = Util.getParent(current);
        while (currentParent instanceof LNode) {
            current = (LNode)currentParent;
            if (current == cParent) {
                return true;
            }
            currentParent = Util.getParent(current);
        }
        return false;
    }

    public static LGraphElement getParent(LNode child) {
        NodeType childNodeType = child.getProperty(Properties.NODE_TYPE);
        switch (childNodeType) {
            case NORMAL: 
            case UPPER_COMPOUND_BORDER: {
                return child.getProperty(Properties.PARENT);
            }
        }
        return child.getProperty(Properties.COMPOUND_NODE).getProperty(Properties.PARENT);
    }

    public static LinkedList<LNode> getChildren(LNode node) {
        NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
        switch (nodeType) {
            case NORMAL: 
            case UPPER_COMPOUND_BORDER: {
                return node.getProperty(Properties.CHILDREN);
            }
        }
        return node.getProperty(Properties.COMPOUND_NODE).getProperty(Properties.CHILDREN);
    }

    public static LNode getRelatedCompoundNode(LNode node, LayeredGraph layeredGraph) {
        LNode retNode = null;
        HashMap<KGraphElement, LGraphElement> elemMap = layeredGraph.getProperty(Properties.ELEMENT_MAP);
        NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
        switch (nodeType) {
            case UPPER_COMPOUND_BORDER: 
            case LOWER_COMPOUND_BORDER: 
            case UPPER_COMPOUND_PORT: 
            case LOWER_COMPOUND_PORT: {
                retNode = node.getProperty(Properties.COMPOUND_NODE);
                break;
            }
            case NORMAL: {
                KNode parent = node.getProperty(Properties.K_PARENT);
                LGraphElement parentRepresentative = elemMap.get(parent);
                if (parentRepresentative instanceof LayeredGraph) break;
                retNode = (LNode)parentRepresentative;
                break;
            }
            case LONG_EDGE: {
                LNode targetNodeCompound;
                LPort sourcePort = node.getProperty(Properties.LONG_EDGE_SOURCE);
                LPort targetPort = node.getProperty(Properties.LONG_EDGE_TARGET);
                LNode sourceNode = sourcePort.getNode();
                LNode targetNode = targetPort.getNode();
                KNode sourceNodeOrigin = (KNode)sourceNode.getProperty(Properties.ORIGIN);
                KNode targetNodeOrigin = (KNode)targetNode.getProperty(Properties.ORIGIN);
                if (KimlUtil.isDescendant(sourceNodeOrigin, targetNodeOrigin) || KimlUtil.isDescendant(targetNodeOrigin, sourceNodeOrigin)) {
                    LinkedList<LNode> sourceTargetList = new LinkedList<LNode>();
                    sourceTargetList.add(sourceNode);
                    sourceTargetList.add(targetNode);
                    Util.propagatePair(sourceTargetList, elemMap);
                    LNode newSource = sourceTargetList.getFirst();
                    KNode newSourceParent = newSource.getProperty(Properties.K_PARENT);
                    LGraphElement container = elemMap.get(newSourceParent);
                    if (container instanceof LayeredGraph) break;
                    retNode = (LNode)container;
                    break;
                }
                LNode sourceNodeCompound = Util.getRelatedCompoundNode(sourceNode, layeredGraph);
                if (sourceNodeCompound == (targetNodeCompound = Util.getRelatedCompoundNode(targetNode, layeredGraph))) {
                    retNode = sourceNodeCompound;
                    break;
                }
                retNode = targetNodeCompound;
                break;
            }
            case EXTERNAL_PORT: {
                LGraphElement nodeParentRep = elemMap.get(((KPort)node.getProperty(Properties.ORIGIN)).getNode().getParent());
                if (nodeParentRep == layeredGraph) break;
                retNode = (LNode)nodeParentRep;
                break;
            }
            case NORTH_SOUTH_PORT: {
                LNode portNode = node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                KNode portNodeParent = portNode.getProperty(Properties.K_PARENT);
                LGraphElement portNodeParentRepresentative = elemMap.get(portNodeParent);
                if (elemMap.get(portNodeParent) instanceof LayeredGraph) break;
                retNode = (LNode)portNodeParentRepresentative;
                break;
            }
            case COMPOUND_SIDE: {
                retNode = node.getProperty(Properties.SIDE_OWNER);
                break;
            }
        }
        return retNode;
    }

    public static void propagatePair(LinkedList<LNode> sourceTargetList, HashMap<KGraphElement, LGraphElement> elemMap) {
        LNode sourceNode = sourceTargetList.getFirst();
        LNode targetNode = sourceTargetList.getLast();
        KNode currentSource = Util.getRelatedKNode(sourceNode);
        KNode currentTarget = Util.getRelatedKNode(targetNode);
        int depthSource = elemMap.get(currentSource).getProperty(Properties.DEPTH);
        int depthTarget = elemMap.get(currentTarget).getProperty(Properties.DEPTH);
        assert (depthSource > 0);
        assert (depthTarget > 0);
        KNode currentSourceAncestor = currentSource.getParent();
        KNode currentTargetAncestor = currentTarget.getParent();
        if (depthSource != depthTarget) {
            int i = depthSource;
            while (i > depthTarget) {
                currentSource = currentSource.getParent();
                --i;
            }
            int j = depthTarget;
            while (j > depthSource) {
                currentTarget = currentTarget.getParent();
                --j;
            }
        }
        if (currentSourceAncestor != currentTargetAncestor) {
            currentSourceAncestor = currentSource.getParent();
            currentTargetAncestor = currentTarget.getParent();
            while (currentSourceAncestor != currentTargetAncestor) {
                currentSource = currentSource.getParent();
                currentTarget = currentTarget.getParent();
                currentSourceAncestor = currentSource.getParent();
                currentTargetAncestor = currentTarget.getParent();
            }
        }
        LNode newSource = (LNode)elemMap.get(currentSource);
        LNode newTarget = (LNode)elemMap.get(currentTarget);
        sourceTargetList.addFirst(newSource);
        sourceTargetList.addLast(newTarget);
    }

    private static KNode getRelatedKNode(LNode node) {
        KNode retNode;
        Object origin = node.getProperty(Properties.ORIGIN);
        NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
        switch (nodeType) {
            case EXTERNAL_PORT: {
                KNode portNode;
                retNode = portNode = ((KPort)node.getProperty(Properties.ORIGIN)).getNode();
                break;
            }
            case LONG_EDGE: {
                LNode edgeTarget = node.getProperty(Properties.LONG_EDGE_TARGET).getNode();
                Object edgeTargetOrigin = edgeTarget.getProperty(Properties.ORIGIN);
                assert (edgeTargetOrigin instanceof KNode);
                retNode = (KNode)edgeTargetOrigin;
                break;
            }
            case NORTH_SOUTH_PORT: {
                LNode lnode = node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                Object nodeOrigin = lnode.getProperty(Properties.ORIGIN);
                assert (nodeOrigin instanceof KNode);
                retNode = (KNode)nodeOrigin;
                break;
            }
            case COMPOUND_SIDE: {
                LNode compoundNode = node.getProperty(Properties.SIDE_OWNER);
                retNode = (KNode)compoundNode.getProperty(Properties.ORIGIN);
                break;
            }
            default: {
                assert (origin instanceof KNode);
                retNode = (KNode)origin;
            }
        }
        return retNode;
    }
}

