/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ComponentsProcessor;
import de.cau.cs.kieler.klay.layered.CompoundKGraphImporter;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingStrategy;
import de.cau.cs.kieler.klay.layered.KGraphImporter;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateLayoutProcessor;
import de.cau.cs.kieler.klay.layered.p1cycles.CycleBreakingStrategy;
import de.cau.cs.kieler.klay.layered.p1cycles.GreedyCycleBreaker;
import de.cau.cs.kieler.klay.layered.p1cycles.InteractiveCycleBreaker;
import de.cau.cs.kieler.klay.layered.p2layers.InteractiveLayerer;
import de.cau.cs.kieler.klay.layered.p2layers.LayeringStrategy;
import de.cau.cs.kieler.klay.layered.p2layers.LongestPathLayerer;
import de.cau.cs.kieler.klay.layered.p2layers.NetworkSimplexLayerer;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p3order.InteractiveCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p3order.LayerSweepCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p4nodes.LinearSegmentsNodePlacer;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalEdgeRouter;
import de.cau.cs.kieler.klay.layered.p5edges.PolylineEdgeRouter;
import de.cau.cs.kieler.klay.layered.p5edges.SplineEdgeRouter;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredLayoutProvider
extends AbstractLayoutProvider {
    private ILayoutPhase cycleBreaker;
    private ILayoutPhase layerer;
    private ILayoutPhase crossingMinimizer;
    private ILayoutPhase nodePlacer = new LinearSegmentsNodePlacer();
    private ILayoutPhase edgeRouter;
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private IntermediateProcessingStrategy intermediateProcessingStrategy = new IntermediateProcessingStrategy();
    private Map<IntermediateLayoutProcessor, ILayoutProcessor> intermediateLayoutProcessorCache = new HashMap<IntermediateLayoutProcessor, ILayoutProcessor>();
    private List<ILayoutProcessor> algorithm = new LinkedList<ILayoutProcessor>();
    private static final IntermediateProcessingStrategy BASELINE_PROCESSING_STRATEGY = new IntermediateProcessingStrategy(null, null, EnumSet.of(IntermediateLayoutProcessor.PORT_LIST_SORTER, IntermediateLayoutProcessor.PORT_SIDE_PROCESSOR), EnumSet.of(IntermediateLayoutProcessor.NODE_MARGIN_CALCULATOR, IntermediateLayoutProcessor.PORT_POSITION_PROCESSOR), null, null);
    private static final IntermediateProcessingStrategy FLATTENED_HIERARCHY_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(EnumSet.of(IntermediateLayoutProcessor.COMPOUND_CYCLE_PROCESSOR), null, EnumSet.of(IntermediateLayoutProcessor.COMPOUND_DUMMY_EDGE_REMOVER), EnumSet.of(IntermediateLayoutProcessor.SUBGRAPH_ORDERING_PROCESSOR, IntermediateLayoutProcessor.COMPOUND_SIDE_PROCESSOR), null, EnumSet.of(IntermediateLayoutProcessor.COMPOUND_GRAPH_RESTORER));

    @Override
    public void doLayout(KNode kgraph, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Layered layout", 1.0f);
        KShapeLayout sourceShapeLayout = kgraph.getData(KShapeLayout.class);
        boolean isCompound = sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        KGraphImporter graphImporter = isCompound ? new CompoundKGraphImporter() : new KGraphImporter();
        LayeredGraph layeredGraph = graphImporter.importGraph(kgraph);
        this.setOptions(layeredGraph, kgraph);
        this.updateModules(layeredGraph, kgraph.getData(KShapeLayout.class));
        List<LayeredGraph> components = this.componentsProcessor.split(layeredGraph);
        for (LayeredGraph comp : components) {
            this.layout(comp, progressMonitor.subTask(1.0f / (float)components.size()));
        }
        layeredGraph = this.componentsProcessor.pack(components);
        graphImporter.applyLayout(layeredGraph);
        progressMonitor.done();
    }

    private void setOptions(LayeredGraph layeredGraph, KNode parent) {
        Integer randomSeed = layeredGraph.getProperty(LayoutOptions.RANDOM_SEED);
        if (randomSeed != null) {
            int val = randomSeed;
            if (val == 0) {
                layeredGraph.setProperty(Properties.RANDOM, new Random());
            } else {
                layeredGraph.setProperty(Properties.RANDOM, new Random(val));
            }
        } else {
            layeredGraph.setProperty(Properties.RANDOM, new Random(1L));
        }
    }

    private void updateModules(LayeredGraph graph, KShapeLayout parentLayout) {
        CycleBreakingStrategy cycleBreaking = parentLayout.getProperty(Properties.CYCLE_BREAKING);
        switch (cycleBreaking) {
            case INTERACTIVE: {
                if (this.cycleBreaker instanceof InteractiveCycleBreaker) break;
                this.cycleBreaker = new InteractiveCycleBreaker();
                break;
            }
            default: {
                if (this.cycleBreaker instanceof GreedyCycleBreaker) break;
                this.cycleBreaker = new GreedyCycleBreaker();
            }
        }
        LayeringStrategy layering = parentLayout.getProperty(Properties.NODE_LAYERING);
        switch (layering) {
            case LONGEST_PATH: {
                if (this.layerer instanceof LongestPathLayerer) break;
                this.layerer = new LongestPathLayerer();
                break;
            }
            case INTERACTIVE: {
                if (this.layerer instanceof InteractiveLayerer) break;
                this.layerer = new InteractiveLayerer();
                break;
            }
            default: {
                if (this.layerer instanceof NetworkSimplexLayerer) break;
                this.layerer = new NetworkSimplexLayerer();
            }
        }
        CrossingMinimizationStrategy crossminStrategy = parentLayout.getProperty(Properties.CROSSMIN);
        switch (crossminStrategy) {
            case INTERACTIVE: {
                if (this.crossingMinimizer instanceof InteractiveCrossingMinimizer) break;
                this.crossingMinimizer = new InteractiveCrossingMinimizer();
                break;
            }
            default: {
                if (this.crossingMinimizer instanceof LayerSweepCrossingMinimizer) break;
                this.crossingMinimizer = new LayerSweepCrossingMinimizer();
            }
        }
        EdgeRouting routing = parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        switch (routing) {
            case ORTHOGONAL: {
                if (this.edgeRouter instanceof OrthogonalEdgeRouter) break;
                this.edgeRouter = new OrthogonalEdgeRouter();
                break;
            }
            case SPLINES: {
                if (this.edgeRouter instanceof SplineEdgeRouter) break;
                this.edgeRouter = new SplineEdgeRouter();
                break;
            }
            default: {
                if (this.edgeRouter instanceof PolylineEdgeRouter) break;
                this.edgeRouter = new PolylineEdgeRouter();
            }
        }
        this.intermediateProcessingStrategy.clear();
        this.intermediateProcessingStrategy.addAll(this.cycleBreaker.getIntermediateProcessingStrategy(graph)).addAll(this.layerer.getIntermediateProcessingStrategy(graph)).addAll(this.crossingMinimizer.getIntermediateProcessingStrategy(graph)).addAll(this.nodePlacer.getIntermediateProcessingStrategy(graph)).addAll(this.edgeRouter.getIntermediateProcessingStrategy(graph)).addAll(this.getIntermediateProcessingStrategy(graph));
        this.algorithm.clear();
        this.algorithm.addAll(this.getIntermediateProcessorList(0));
        this.algorithm.add(this.cycleBreaker);
        this.algorithm.addAll(this.getIntermediateProcessorList(1));
        this.algorithm.add(this.layerer);
        this.algorithm.addAll(this.getIntermediateProcessorList(2));
        this.algorithm.add(this.crossingMinimizer);
        this.algorithm.addAll(this.getIntermediateProcessorList(3));
        this.algorithm.add(this.nodePlacer);
        this.algorithm.addAll(this.getIntermediateProcessorList(4));
        this.algorithm.add(this.edgeRouter);
        this.algorithm.addAll(this.getIntermediateProcessorList(5));
    }

    private List<ILayoutProcessor> getIntermediateProcessorList(int slotIndex) {
        Set<IntermediateLayoutProcessor> processors = this.intermediateProcessingStrategy.getProcessors(slotIndex);
        ArrayList<ILayoutProcessor> result = new ArrayList<ILayoutProcessor>(processors.size());
        for (IntermediateLayoutProcessor processor : processors) {
            ILayoutProcessor processorImpl = this.intermediateLayoutProcessorCache.get((Object)processor);
            if (processorImpl == null) {
                processorImpl = processor.create();
                this.intermediateLayoutProcessorCache.put(processor, processorImpl);
            }
            result.add(processorImpl);
        }
        return result;
    }

    private IntermediateProcessingStrategy getIntermediateProcessingStrategy(LayeredGraph graph) {
        Set<GraphProperties> graphProperties = graph.getProperty(Properties.GRAPH_PROPERTIES);
        IntermediateProcessingStrategy strategy = new IntermediateProcessingStrategy(BASELINE_PROCESSING_STRATEGY);
        switch (graph.getProperty(LayoutOptions.DIRECTION)) {
            case LEFT: {
                strategy.addLayoutProcessor(0, IntermediateLayoutProcessor.LEFT_DIR_PREPROCESSOR);
                strategy.addLayoutProcessor(5, IntermediateLayoutProcessor.LEFT_DIR_POSTPROCESSOR);
                break;
            }
            case DOWN: {
                strategy.addLayoutProcessor(0, IntermediateLayoutProcessor.DOWN_DIR_PREPROCESSOR);
                strategy.addLayoutProcessor(5, IntermediateLayoutProcessor.DOWN_DIR_POSTPROCESSOR);
                break;
            }
            case UP: {
                strategy.addLayoutProcessor(0, IntermediateLayoutProcessor.UP_DIR_PREPROCESSOR);
                strategy.addLayoutProcessor(5, IntermediateLayoutProcessor.UP_DIR_POSTPROCESSOR);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.FLAT_HIERARCHICAL)) {
            strategy.addAll(FLATTENED_HIERARCHY_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            strategy.addLayoutProcessor(0, IntermediateLayoutProcessor.COMMENT_PREPROCESSOR);
            strategy.addLayoutProcessor(5, IntermediateLayoutProcessor.COMMENT_POSTPROCESSOR);
        }
        return strategy;
    }

    public void layout(LayeredGraph graph, IKielerProgressMonitor themonitor) {
        IKielerProgressMonitor monitor = themonitor;
        if (monitor == null) {
            monitor = new BasicProgressMonitor();
        }
        monitor.begin("Component Layout", this.algorithm.size());
        if (graph.getProperty(LayoutOptions.DEBUG_MODE).booleanValue()) {
            System.out.println("KLay Layered uses the following " + this.algorithm.size() + " modules:");
            int i = 0;
            while (i < this.algorithm.size()) {
                System.out.println("   Slot " + String.format("%1$02d", i) + ": " + this.algorithm.get(i).getClass().getName());
                ++i;
            }
            int slotIndex = 0;
            for (ILayoutProcessor processor : this.algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    graph.writeDotGraph(this.createWriter(graph, slotIndex++));
                }
                catch (IOException iOException) {}
                processor.reset(monitor.subTask(1.0f));
                processor.process(graph);
            }
            try {
                graph.writeDotGraph(this.createWriter(graph, slotIndex++));
            }
            catch (IOException iOException) {}
        } else {
            for (ILayoutProcessor processor : this.algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                processor.reset(monitor.subTask(1.0f));
                processor.process(graph);
            }
        }
        monitor.done();
    }

    private Writer createWriter(LayeredGraph graph, int slotIndex) throws IOException {
        String path = Util.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(Util.getDebugOutputFileBaseName(graph)) + "fulldebug-slot" + String.format("%1$02d", slotIndex);
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }

    @Override
    public boolean supportsHierarchy(KNode layoutNode) {
        KShapeLayout sourceShapeLayout = layoutNode.getData(KShapeLayout.class);
        return sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
    }
}

