/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.AbstractGraphImporter;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGraphImporter
extends AbstractGraphImporter<KNode> {
    @Override
    public LayeredGraph importGraph(KNode kgraph) {
        LayeredGraph layeredGraph = new LayeredGraph();
        layeredGraph.setProperty(Properties.ORIGIN, kgraph);
        KShapeLayout sourceShapeLayout = kgraph.getData(KShapeLayout.class);
        layeredGraph.copyProperties(sourceShapeLayout);
        layeredGraph.checkProperties(Properties.OBJ_SPACING, Properties.BORDER_SPACING, Properties.THOROUGHNESS, Properties.ASPECT_RATIO);
        Direction direction = layeredGraph.getProperty(LayoutOptions.DIRECTION);
        if (direction == Direction.UNDEFINED) {
            direction = Direction.RIGHT;
            layeredGraph.setProperty(LayoutOptions.DIRECTION, (Object)direction);
        }
        KInsets kinsets = sourceShapeLayout.getInsets();
        LInsets.Double linsets = layeredGraph.getInsets();
        linsets.left = kinsets.getLeft();
        linsets.right = kinsets.getRight();
        linsets.top = kinsets.getTop();
        linsets.bottom = kinsets.getBottom();
        HashMap<KGraphElement, LGraphElement> elemMap = new HashMap<KGraphElement, LGraphElement>();
        EnumSet<GraphProperties> graphProperties = EnumSet.noneOf(GraphProperties.class);
        layeredGraph.setProperty(Properties.GRAPH_PROPERTIES, graphProperties);
        boolean isCompound = sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        if (!isCompound) {
            this.transformNodesAndPorts(kgraph, layeredGraph, elemMap);
            this.transformEdges(kgraph, elemMap, layeredGraph);
        }
        layeredGraph.setProperty(Properties.ELEMENT_MAP, elemMap);
        return layeredGraph;
    }

    private void transformNodesAndPorts(KNode graph, LayeredGraph layeredGraph, Map<KGraphElement, LGraphElement> elemMap) {
        Set<GraphProperties> graphProperties = layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
        List<LNode> layeredNodes = layeredGraph.getLayerlessNodes();
        KShapeLayout layoutNodeLayout = graph.getData(KShapeLayout.class);
        KVector layoutNodeSize = new KVector(layoutNodeLayout.getWidth(), layoutNodeLayout.getHeight());
        EList<KPort> ports = graph.getPorts();
        for (KPort kport : ports) {
            int hierarchicalEdges = 0;
            for (KEdge kedge : kport.getEdges()) {
                if (!graph.equals(kedge.getSource().getParent()) && !graph.equals(kedge.getTarget().getParent())) continue;
                ++hierarchicalEdges;
            }
            if (hierarchicalEdges > 0) {
                graphProperties.add(GraphProperties.EXTERNAL_PORTS);
            }
            if (hierarchicalEdges <= 1) continue;
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
        Direction direction = layeredGraph.getProperty(LayoutOptions.DIRECTION);
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            for (KPort kport : ports) {
                this.transformExternalPort(kport, layeredNodes, graph, layoutNodeSize, elemMap, direction);
            }
        }
        for (KNode child : graph.getChildren()) {
            this.transformNode(child, layeredNodes, elemMap, graphProperties, direction);
        }
    }

    private void transformExternalPort(KPort kport, List<LNode> layeredNodes, KNode graph, KVector layoutNodeSize, Map<KGraphElement, LGraphElement> elemMap, Direction direction) {
        KShapeLayout graphLayout = graph.getData(KShapeLayout.class);
        KShapeLayout kportLayout = kport.getData(KShapeLayout.class);
        KVector kportPosition = new KVector((double)kportLayout.getXpos() + (double)kportLayout.getWidth() / 2.0, (double)kportLayout.getYpos() + (double)kportLayout.getHeight() / 2.0);
        int inEdges = 0;
        int outEdges = 0;
        for (KEdge edge : kport.getEdges()) {
            if (edge.getSourcePort() == kport && edge.getTarget().getParent() == graph) {
                ++outEdges;
            }
            if (edge.getTargetPort() != kport || edge.getSource().getParent() != graph) continue;
            ++inEdges;
        }
        PortSide portSide = KimlUtil.calcPortSide(kport, direction);
        LNode dummy = this.createExternalPortDummy(kport, graphLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS), portSide, inEdges - outEdges, layoutNodeSize, kportPosition, new KVector(kportLayout.getWidth(), kportLayout.getHeight()));
        dummy.setProperty(LayoutOptions.OFFSET, Float.valueOf(KimlUtil.calcPortOffset(kport, portSide)));
        layeredNodes.add(dummy);
        elemMap.put(kport, dummy);
    }

    protected void transformNode(KNode node, List<LNode> layeredNodes, Map<KGraphElement, LGraphElement> elemMap, Set<GraphProperties> graphProperties, Direction direction) {
        KPort[] sortedPorts;
        LNode newNode = new LNode();
        newNode.setProperty(Properties.ORIGIN, node);
        KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
        if (nodeLayout.getProperty(LayoutOptions.FIXED_SIZE).booleanValue()) {
            if (node.getChildren().isEmpty()) {
                KimlUtil.excludeLabels(node);
            }
        } else {
            KVector ratio = KimlUtil.resizeNode(node);
            if (ratio != null && (ratio.x != 1.0 || ratio.y != 1.0)) {
                newNode.setProperty(Properties.RESIZE_RATIO, ratio);
            }
        }
        newNode.getPosition().x = nodeLayout.getXpos();
        newNode.getPosition().y = nodeLayout.getYpos();
        newNode.getSize().x = nodeLayout.getWidth();
        newNode.getSize().y = nodeLayout.getHeight();
        layeredNodes.add(newNode);
        elemMap.put(node, newNode);
        PortConstraints portConstraints = nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.UNDEFINED) {
            portConstraints = PortConstraints.FREE;
        }
        for (KPort port : node.getPorts()) {
            KShapeLayout portLayout = port.getData(KShapeLayout.class);
            PortSide portSide = portLayout.getProperty(LayoutOptions.PORT_SIDE);
            if (portSide != PortSide.UNDEFINED) continue;
            portSide = KimlUtil.calcPortSide(port, direction);
            portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
        }
        if (portConstraints != PortConstraints.FREE) {
            graphProperties.add(GraphProperties.NON_FREE_PORTS);
        }
        KPort[] kPortArray = sortedPorts = KimlUtil.getSortedPorts(node);
        int portSide = sortedPorts.length;
        int n = 0;
        while (n < portSide) {
            KPort kport = kPortArray[n];
            KShapeLayout portLayout = kport.getData(KShapeLayout.class);
            int inEdges = 0;
            int outEdges = 0;
            for (KEdge edge : kport.getEdges()) {
                if (edge.getSourcePort() == kport) {
                    ++outEdges;
                }
                if (edge.getTargetPort() != kport) continue;
                ++inEdges;
            }
            if (inEdges + outEdges > 1) {
                graphProperties.add(GraphProperties.HYPEREDGES);
            }
            LPort newPort = new LPort();
            newPort.setProperty(Properties.ORIGIN, kport);
            newPort.getSize().x = portLayout.getWidth();
            newPort.getSize().y = portLayout.getHeight();
            newPort.getPosition().x = portLayout.getXpos() + portLayout.getWidth() / 2.0f;
            newPort.getPosition().y = portLayout.getYpos() + portLayout.getHeight() / 2.0f;
            newPort.setNode(newNode);
            elemMap.put(kport, newPort);
            for (KLabel klabel : kport.getLabels()) {
                KShapeLayout labelLayout = klabel.getData(KShapeLayout.class);
                LLabel newLabel = new LLabel(klabel.getText());
                newLabel.setProperty(Properties.ORIGIN, klabel);
                newLabel.getSize().x = labelLayout.getWidth();
                newLabel.getSize().y = labelLayout.getHeight();
                newLabel.getPosition().x = labelLayout.getXpos() - portLayout.getWidth() / 2.0f;
                newLabel.getPosition().y = labelLayout.getYpos() - portLayout.getHeight() / 2.0f;
                newPort.getLabels().add(newLabel);
            }
            PortSide portSide2 = portLayout.getProperty(LayoutOptions.PORT_SIDE);
            float offset = KimlUtil.calcPortOffset(kport, portSide2);
            newPort.setSide(portSide2);
            newPort.setProperty(LayoutOptions.OFFSET, Float.valueOf(offset));
            switch (direction) {
                case RIGHT: 
                case LEFT: {
                    if (portSide2 != PortSide.NORTH && portSide2 != PortSide.SOUTH) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                    break;
                }
                case DOWN: 
                case UP: {
                    if (portSide2 != PortSide.EAST && portSide2 != PortSide.WEST) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                }
            }
            ++n;
        }
        for (KLabel klabel : node.getLabels()) {
            KShapeLayout labelLayout = klabel.getData(KShapeLayout.class);
            LLabel newLabel = new LLabel(klabel.getText());
            newLabel.setProperty(Properties.ORIGIN, node);
            newLabel.getSize().x = labelLayout.getWidth();
            newLabel.getSize().y = labelLayout.getHeight();
            newLabel.getPosition().x = labelLayout.getXpos();
            newLabel.getPosition().y = labelLayout.getYpos();
            newNode.getLabels().add(newLabel);
        }
        newNode.copyProperties(nodeLayout);
        if (newNode.getProperty(LayoutOptions.COMMENT_BOX).booleanValue()) {
            graphProperties.add(GraphProperties.COMMENTS);
        }
        if (newNode.getProperty(LayoutOptions.HYPERNODE).booleanValue()) {
            graphProperties.add(GraphProperties.HYPERNODES);
            graphProperties.add(GraphProperties.HYPEREDGES);
            newNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        }
    }

    private void transformEdges(KNode graph, Map<KGraphElement, LGraphElement> elemMap, MapPropertyHolder layeredGraph) {
        this.transformExternalPortEdges(graph, graph.getIncomingEdges(), elemMap, layeredGraph);
        this.transformExternalPortEdges(graph, graph.getOutgoingEdges(), elemMap, layeredGraph);
        for (KNode child : graph.getChildren()) {
            for (KEdge kedge : child.getOutgoingEdges()) {
                if (kedge.getTarget().getParent() == child.getParent()) {
                    this.transformEdge(kedge, graph, elemMap, layeredGraph);
                    continue;
                }
                if (kedge.getTarget().getParent() == kedge.getSource() || kedge.getTarget() == kedge.getSource().getParent()) continue;
                kedge.getData(KEdgeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
                KimlUtil.excludeLabels(kedge);
            }
        }
    }

    private void transformExternalPortEdges(KNode graph, List<KEdge> edges, Map<KGraphElement, LGraphElement> elemMap, MapPropertyHolder layeredGraph) {
        for (KEdge kedge : edges) {
            if (kedge.getSource().getParent() != graph && kedge.getTarget().getParent() != graph) continue;
            this.transformEdge(kedge, graph, elemMap, layeredGraph);
        }
    }

    protected void transformEdge(KEdge kedge, KNode graph, Map<KGraphElement, LGraphElement> elemMap, MapPropertyHolder layeredGraph) {
        KEdgeLayout edgeLayout = kedge.getData(KEdgeLayout.class);
        KNode kgraph = (KNode)layeredGraph.getProperty(Properties.ORIGIN);
        KShapeLayout sourceShapeLayout = kgraph.getData(KShapeLayout.class);
        boolean isCompound = sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        LEdge newEdge = new LEdge();
        newEdge.setProperty(Properties.ORIGIN, kedge);
        if (!isCompound) {
            LNode sourceNode = null;
            Object sourcePort = null;
            LNode targetNode = null;
            LPort targetPort = null;
            if (kedge.getSource() == graph && kedge.getSourcePort() != null) {
                sourceNode = (LNode)elemMap.get(kedge.getSourcePort());
                sourcePort = sourceNode.getPorts().get(0);
            } else {
                sourceNode = (LNode)elemMap.get(kedge.getSource());
                sourcePort = (LPort)elemMap.get(kedge.getSourcePort());
            }
            if (kedge.getTarget() == graph && kedge.getTargetPort() != null) {
                targetNode = (LNode)elemMap.get(kedge.getTargetPort());
                targetPort = targetNode.getPorts().get(0);
            } else {
                targetNode = (LNode)elemMap.get(kedge.getTarget());
                targetPort = (LPort)elemMap.get(kedge.getTargetPort());
            }
            if (sourceNode == null || targetNode == null) {
                edgeLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
                KimlUtil.excludeLabels(kedge);
                return;
            }
            if (sourceNode != graph && sourceNode == targetNode) {
                Set<GraphProperties> graphProperties = layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
                graphProperties.add(GraphProperties.SELF_LOOPS);
            }
            if (sourcePort == null) {
                sourcePort = this.createPort(sourceNode, edgeLayout.getSourcePoint(), PortType.OUTPUT, layeredGraph);
            }
            if (targetPort == null) {
                targetPort = this.createPort(targetNode, edgeLayout.getTargetPoint(), PortType.INPUT, layeredGraph);
            }
            newEdge.setSource((LPort)sourcePort);
            newEdge.setTarget(targetPort);
        }
        for (KLabel klabel : kedge.getLabels()) {
            KShapeLayout labelLayout = klabel.getData(KShapeLayout.class);
            LLabel newLabel = new LLabel(klabel.getText());
            newLabel.getPosition().x = labelLayout.getXpos();
            newLabel.getPosition().y = labelLayout.getYpos();
            newLabel.getSize().x = labelLayout.getWidth();
            newLabel.getSize().y = labelLayout.getHeight();
            newLabel.setProperty(Properties.ORIGIN, klabel);
            newEdge.getLabels().add(newLabel);
        }
        if (layeredGraph.getProperty(Properties.CROSSMIN) == CrossingMinimizationStrategy.INTERACTIVE && !edgeLayout.getBendPoints().isEmpty()) {
            KVectorChain bendpoints = new KVectorChain();
            for (KPoint point : edgeLayout.getBendPoints()) {
                bendpoints.add(point.createVector());
            }
            newEdge.setProperty(Properties.ORIGINAL_BENDPOINTS, bendpoints);
        }
        newEdge.copyProperties(edgeLayout);
        if (isCompound) {
            elemMap.put(kedge, newEdge);
        }
    }

    private LPort createPort(LNode node, KPoint endPoint, PortType type, MapPropertyHolder layeredGraph) {
        LPort port;
        Direction direction = layeredGraph.getProperty(LayoutOptions.DIRECTION);
        boolean mergePorts = layeredGraph.getProperty(Properties.MERGE_PORTS);
        if ((mergePorts || node.getProperty(LayoutOptions.HYPERNODE).booleanValue()) && !node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isSideFixed()) {
            PortSide defaultSide = PortSide.fromDirection(direction);
            port = Util.provideCollectorPort(node, type, defaultSide);
        } else {
            port = new LPort();
            port.setNode(node);
            KVector pos = port.getPosition();
            pos.x = (double)endPoint.getX() - node.getPosition().x;
            pos.y = (double)endPoint.getY() - node.getPosition().y;
            KVector resizeRatio = node.getProperty(Properties.RESIZE_RATIO);
            if (resizeRatio != null) {
                pos.x *= resizeRatio.x;
                pos.y *= resizeRatio.y;
            }
            pos.applyBounds(0.0, 0.0, node.getSize().x, node.getSize().y);
            PortSide portSide = KGraphImporter.calcPortSide(node, port);
            port.setSide(portSide);
            Set<GraphProperties> graphProperties = layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
            switch (direction) {
                case RIGHT: 
                case LEFT: {
                    if (portSide != PortSide.NORTH && portSide != PortSide.SOUTH) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                    break;
                }
                case DOWN: 
                case UP: {
                    if (portSide != PortSide.EAST && portSide != PortSide.WEST) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                }
            }
        }
        return port;
    }

    private static PortSide calcPortSide(LNode node, LPort port) {
        double widthPercent = port.getPosition().x / node.getSize().x;
        double heightPercent = port.getPosition().y / node.getSize().y;
        if (widthPercent + heightPercent <= 1.0 && widthPercent - heightPercent <= 0.0) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0 && widthPercent - heightPercent >= 0.0) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    @Override
    public void applyLayout(LayeredGraph layeredGraph) {
        Object target = layeredGraph.getProperty(Properties.ORIGIN);
        if (!(target instanceof KNode)) {
            return;
        }
        KNode parentNode = (KNode)target;
        KShapeLayout parentLayout = parentNode.getData(KShapeLayout.class);
        float borderSpacing = layeredGraph.getProperty(Properties.BORDER_SPACING).floatValue();
        KVector offset = new KVector((double)borderSpacing + layeredGraph.getOffset().x, (double)borderSpacing + layeredGraph.getOffset().y);
        LinkedList<LEdge> edgeList = new LinkedList<LEdge>();
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            Object origin = lnode.getProperty(Properties.ORIGIN);
            if (origin instanceof KNode) {
                KNode kNode = (KNode)origin;
                KShapeLayout nodeLayout = kNode.getData(KShapeLayout.class);
                nodeLayout.setXpos((float)(lnode.getPosition().x + offset.x));
                nodeLayout.setYpos((float)(lnode.getPosition().y + offset.y));
                if (!nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS).isPosFixed()) {
                    for (LPort lport : lnode.getPorts()) {
                        origin = lport.getProperty(Properties.ORIGIN);
                        if (!(origin instanceof KPort)) continue;
                        KPort kport = (KPort)origin;
                        KShapeLayout portLayout = kport.getData(KShapeLayout.class);
                        portLayout.setXpos((float)(lport.getPosition().x - lport.getSize().x / 2.0));
                        portLayout.setYpos((float)(lport.getPosition().y - lport.getSize().y / 2.0));
                        KimlUtil.excludeLabels(kport);
                    }
                }
            } else if (origin instanceof KPort) {
                KPort kPort = (KPort)origin;
                KShapeLayout portLayout = kPort.getData(KShapeLayout.class);
                KVector portPosition = this.getExternalPortPosition(layeredGraph, lnode, portLayout.getWidth(), portLayout.getHeight());
                portLayout.setXpos((float)portPosition.x);
                portLayout.setYpos((float)portPosition.y);
                KimlUtil.excludeLabels(kPort);
            }
            for (LPort lPort : lnode.getPorts()) {
                edgeList.addAll(lPort.getOutgoingEdges());
            }
        }
        EdgeRouting routing = parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        boolean splinesActive = routing == EdgeRouting.SPLINES;
        for (LEdge ledge : edgeList) {
            KEdge kedge = (KEdge)ledge.getProperty(Properties.ORIGIN);
            KEdgeLayout edgeLayout = kedge.getData(KEdgeLayout.class);
            KVectorChain bendPoints = ledge.getBendPoints();
            LPort sourcePort = ledge.getSource();
            KVector sourcePoint = KVector.add(sourcePort.getPosition(), sourcePort.getNode().getPosition());
            bendPoints.addFirst(sourcePoint);
            LPort targetPort = ledge.getTarget();
            KVector targetPoint = KVector.add(targetPort.getPosition(), targetPort.getNode().getPosition());
            bendPoints.addLast(targetPoint);
            if (sourcePort.getProperty(Properties.ORIGIN) != null) {
                this.clip(sourcePoint, sourcePort.getSize(), (KVector)bendPoints.get(1));
            }
            if (targetPort.getProperty(Properties.ORIGIN) != null) {
                this.clip(targetPoint, targetPort.getSize(), (KVector)bendPoints.get(bendPoints.size() - 2));
            }
            bendPoints.translate(offset);
            edgeLayout.applyVectorChain(bendPoints);
            for (LLabel label : ledge.getLabels()) {
                KLabel klabel = (KLabel)label.getProperty(Properties.ORIGIN);
                KShapeLayout klabelLayout = klabel.getData(KShapeLayout.class);
                KVector labelPos = new KVector(ledge.getSource().getPosition().x, ledge.getSource().getPosition().y);
                labelPos.add(ledge.getSource().getNode().getPosition());
                labelPos.add(label.getPosition());
                klabelLayout.setXpos((float)(labelPos.x + offset.x));
                klabelLayout.setYpos((float)(labelPos.y + offset.y));
            }
            if (!splinesActive) continue;
            edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
        KInsets insets = parentLayout.getInsets();
        float f = (float)layeredGraph.getSize().x + 2.0f * borderSpacing + insets.getLeft() + insets.getRight();
        float height = (float)layeredGraph.getSize().y + 2.0f * borderSpacing + insets.getTop() + insets.getBottom();
        if (layeredGraph.getProperty(Properties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            parentLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
            KimlUtil.resizeNode(parentNode, f, height, false);
        } else {
            KimlUtil.resizeNode(parentNode, f, height, true);
        }
    }

    protected void clip(KVector endpoint, KVector portSize, KVector next) {
        double ydiff;
        double xdiff = Math.abs(next.x - endpoint.x);
        if (xdiff >= (ydiff = Math.abs(next.y - endpoint.y))) {
            if (next.x > endpoint.x) {
                endpoint.x += portSize.x / 2.0;
            } else if (next.x < endpoint.x) {
                endpoint.x -= portSize.x / 2.0;
            }
        } else if (next.y > endpoint.y) {
            endpoint.y += portSize.y / 2.0;
        } else if (next.y < endpoint.y) {
            endpoint.y -= portSize.y / 2.0;
        }
    }
}

