/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.klay.layered.intermediate.IntermediateLayoutProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateProcessingStrategy {
    public static final int BEFORE_PHASE_1 = 0;
    public static final int BEFORE_PHASE_2 = 1;
    public static final int BEFORE_PHASE_3 = 2;
    public static final int BEFORE_PHASE_4 = 3;
    public static final int BEFORE_PHASE_5 = 4;
    public static final int AFTER_PHASE_5 = 5;
    public static final int INTERMEDIATE_PHASE_SLOTS = 6;
    private List<Set<IntermediateLayoutProcessor>> strategy = new ArrayList<Set<IntermediateLayoutProcessor>>(6);

    public IntermediateProcessingStrategy() {
        int i = 0;
        while (i < 6) {
            this.strategy.add(EnumSet.noneOf(IntermediateLayoutProcessor.class));
            ++i;
        }
    }

    public IntermediateProcessingStrategy(IntermediateProcessingStrategy init) {
        int i = 0;
        while (i < 6) {
            this.strategy.add(EnumSet.copyOf(init.strategy.get(i)));
            ++i;
        }
    }

    public IntermediateProcessingStrategy(int slotIndex, IntermediateLayoutProcessor processor) {
        this();
        this.addAll(slotIndex, EnumSet.of(processor));
    }

    public IntermediateProcessingStrategy(int slotIndex, Collection<IntermediateLayoutProcessor> processors) {
        this();
        this.addAll(slotIndex, processors);
    }

    public IntermediateProcessingStrategy(Collection<IntermediateLayoutProcessor> beforePhase1, Collection<IntermediateLayoutProcessor> beforePhase2, Collection<IntermediateLayoutProcessor> beforePhase3, Collection<IntermediateLayoutProcessor> beforePhase4, Collection<IntermediateLayoutProcessor> beforePhase5, Collection<IntermediateLayoutProcessor> afterPhase5) {
        this();
        this.addAll(0, beforePhase1).addAll(1, beforePhase2).addAll(2, beforePhase3).addAll(3, beforePhase4).addAll(4, beforePhase5).addAll(5, afterPhase5);
    }

    public Set<IntermediateLayoutProcessor> getProcessors(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        return EnumSet.copyOf(this.strategy.get(slotIndex));
    }

    public void addLayoutProcessor(int slotIndex, IntermediateLayoutProcessor processor) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        this.strategy.get(slotIndex).add(processor);
    }

    public IntermediateProcessingStrategy addAll(int slotIndex, Collection<IntermediateLayoutProcessor> processors) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        if (processors != null) {
            this.strategy.get(slotIndex).addAll(processors);
        }
        return this;
    }

    public IntermediateProcessingStrategy addAll(IntermediateProcessingStrategy operand) {
        if (operand != null) {
            int i = 0;
            while (i < 6) {
                this.strategy.get(i).addAll((Collection<IntermediateLayoutProcessor>)operand.strategy.get(i));
                ++i;
            }
        }
        return this;
    }

    public void removeLayoutProcessor(int slotIndex, IntermediateLayoutProcessor processor) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        this.strategy.get(slotIndex).remove((Object)processor);
    }

    public void clear() {
        for (Set<IntermediateLayoutProcessor> set : this.strategy) {
            set.clear();
        }
    }
}

