/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.KGraphImporter;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundKGraphImporter
extends KGraphImporter {
    private int maximalDepth;

    @Override
    public LayeredGraph importGraph(KNode kgraph) {
        LayeredGraph layeredGraph = super.importGraph(kgraph);
        layeredGraph.getProperty(Properties.ELEMENT_MAP).put(kgraph, layeredGraph);
        Set<GraphProperties> graphProperties = layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
        graphProperties.add(GraphProperties.FLAT_HIERARCHICAL);
        List<LNode> unlayeredNodes = layeredGraph.getLayerlessNodes();
        Direction direction = layeredGraph.getProperty(LayoutOptions.DIRECTION);
        HashMap<LNode, List<LNode>> parentChildMap = new HashMap<LNode, List<LNode>>();
        this.recursiveTransformCompoundGraph(kgraph, kgraph, unlayeredNodes, layeredGraph, graphProperties, parentChildMap, direction, 0);
        layeredGraph.setProperty(Properties.GRAPH_PROPERTIES, graphProperties);
        layeredGraph.setProperty(Properties.MAX_DEPTH, this.maximalDepth);
        this.createInclusionTree(layeredGraph, kgraph);
        return layeredGraph;
    }

    void recursiveTransformCompoundGraph(KNode graph, KNode currentNode, List<LNode> layeredNodes, LayeredGraph layeredGraph, Set<GraphProperties> graphProperties, Map<LNode, List<LNode>> parentChildMap, Direction direction, int depth) {
        if (depth > this.maximalDepth) {
            this.maximalDepth = depth;
        }
        HashMap<KGraphElement, LGraphElement> elemMap = layeredGraph.getProperty(Properties.ELEMENT_MAP);
        if (currentNode.getChildren().isEmpty()) {
            this.transformLeaveNode(currentNode, layeredNodes, elemMap, graphProperties, layeredGraph.getProperty(LayoutOptions.DIRECTION), depth);
            this.transformLeaveEdges(currentNode, elemMap, direction, layeredGraph);
        } else {
            for (KNode child : currentNode.getChildren()) {
                this.recursiveTransformCompoundGraph(graph, child, layeredNodes, layeredGraph, graphProperties, parentChildMap, direction, depth + 1);
            }
            if (currentNode != graph) {
                this.transformCompoundNodeWithEdges(currentNode, layeredNodes, layeredGraph, elemMap, direction, depth);
                this.setCompoundDummyEdges(layeredNodes, parentChildMap, elemMap);
            }
        }
    }

    private void transformLeaveNode(KNode node, List<LNode> layeredNodes, Map<KGraphElement, LGraphElement> elemMap, Set<GraphProperties> graphProperties, Direction direction, int depth) {
        super.transformNode(node, layeredNodes, elemMap, (EnumSet)graphProperties, direction);
        LNode newNode = (LNode)elemMap.get(node);
        newNode.setProperty(Properties.K_PARENT, node.getParent());
        LPort dummyPortWest = this.createDummyPort(newNode, PortSide.WEST, null, elemMap);
        dummyPortWest.setProperty(Properties.LEAVE_DUMMY_PORT, true);
        LPort dummyPortEast = this.createDummyPort(newNode, PortSide.EAST, null, elemMap);
        dummyPortEast.setProperty(Properties.LEAVE_DUMMY_PORT, true);
        newNode.setProperty(Properties.DEPTH, depth);
    }

    private void transformLeaveEdges(KNode knode, Map<KGraphElement, LGraphElement> elemMap, Direction direction, LayeredGraph layeredGraph) {
        LPort port;
        LPort newPort;
        LNode representative;
        LEdge newEdge;
        KEdgeLayout edgeLayout;
        for (KEdge edge : knode.getIncomingEdges()) {
            edgeLayout = edge.getData(KEdgeLayout.class);
            newEdge = null;
            newEdge = elemMap.containsKey(edge) ? (LEdge)elemMap.get(edge) : this.createLEdgeFromKEdge(edge, elemMap, layeredGraph);
            representative = (LNode)elemMap.get(knode);
            if (edge.getTargetPort() == null) {
                newPort = this.createDummyPort(representative, PortSide.WEST, null, elemMap);
                KPoint targetPoint = edgeLayout.getTargetPoint();
                newPort.getPosition().x = (double)targetPoint.getX() - representative.getPosition().x;
                newPort.getPosition().y = (double)targetPoint.getY() - representative.getPosition().y;
                newEdge.setTarget(newPort);
                continue;
            }
            port = (LPort)elemMap.get(edge.getTargetPort());
            newEdge.setTarget(port);
        }
        for (KEdge edge : knode.getOutgoingEdges()) {
            edgeLayout = edge.getData(KEdgeLayout.class);
            newEdge = null;
            newEdge = elemMap.containsKey(edge) ? (LEdge)elemMap.get(edge) : this.createLEdgeFromKEdge(edge, elemMap, layeredGraph);
            representative = (LNode)elemMap.get(knode);
            if (edge.getSourcePort() == null) {
                newPort = this.createDummyPort(representative, PortSide.EAST, null, elemMap);
                KPoint sourcePoint = edgeLayout.getSourcePoint();
                newPort.getPosition().x = (double)sourcePoint.getX() - representative.getPosition().x;
                newPort.getPosition().y = (double)sourcePoint.getY() - representative.getPosition().y;
                newEdge.setSource(newPort);
                continue;
            }
            port = (LPort)elemMap.get(edge.getSourcePort());
            newEdge.setSource(port);
        }
    }

    private void transformCompoundNodeWithEdges(KNode node, List<LNode> layeredNodes, LayeredGraph layeredGraph, Map<KGraphElement, LGraphElement> elemMap, Direction direction, int depth) {
        LinkedList<LNode> dummyNodes = new LinkedList<LNode>();
        this.transformCompoundEdgeList(node, layeredNodes, elemMap, dummyNodes, node.getIncomingEdges(), true, layeredGraph, direction, depth);
        this.transformCompoundEdgeList(node, layeredNodes, elemMap, dummyNodes, node.getOutgoingEdges(), false, layeredGraph, direction, depth);
    }

    private void transformCompoundEdgeList(KNode node, List<LNode> layeredNodes, Map<KGraphElement, LGraphElement> elemMap, List<LNode> dummyNodes, List<KEdge> edgesList, boolean incoming, LayeredGraph layeredGraph, Direction direction, int depth) {
        KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
        KInsets insets = nodeLayout.getInsets();
        float borderSpacing = nodeLayout.getProperty(Properties.BORDER_SPACING).floatValue();
        LNode upperBorder = null;
        if (incoming) {
            upperBorder = this.createBorderDummyNode(node, NodeType.UPPER_COMPOUND_BORDER, dummyNodes, elemMap, depth);
            upperBorder.setProperty(Properties.ORIGINAL_INSETS, insets);
            upperBorder.setProperty(Properties.BORDER_SPACING, Float.valueOf(borderSpacing));
            upperBorder.getSize().x = insets.getLeft() + borderSpacing;
        } else {
            for (LNode lnode : dummyNodes) {
                if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.UPPER_COMPOUND_BORDER || lnode.getProperty(Properties.ORIGIN) != node) continue;
                upperBorder = lnode;
                break;
            }
        }
        for (KEdge kEdge : edgesList) {
            KEdgeLayout edgeLayout = kEdge.getData(KEdgeLayout.class);
            LEdge lEdge = null;
            lEdge = !elemMap.containsKey(kEdge) ? this.createLEdgeFromKEdge(kEdge, elemMap, layeredGraph) : (LEdge)elemMap.get(kEdge);
            LNode representative = null;
            boolean fromInside = false;
            fromInside = incoming ? this.isDescendantNotSelf(node, kEdge.getSource()) : !this.isDescendantNotSelf(node, kEdge.getTarget());
            KPort port = null;
            port = incoming ? kEdge.getTargetPort() : kEdge.getSourcePort();
            KShapeLayout portLayout = null;
            if (port != null) {
                portLayout = port.getData(KShapeLayout.class);
            }
            if (port == null) {
                if (fromInside) {
                    representative = this.createBorderDummyNode(node, NodeType.LOWER_COMPOUND_BORDER, dummyNodes, elemMap, depth);
                    representative.getSize().x = insets.getRight() + borderSpacing;
                } else {
                    representative = upperBorder;
                }
            } else {
                LGraphElement portRepresentative = elemMap.get(port);
                if (portRepresentative == null) {
                    if (fromInside) {
                        representative = this.createBorderDummyNode(node, NodeType.LOWER_COMPOUND_PORT, dummyNodes, elemMap, depth);
                        representative.getSize().x = insets.getRight() + borderSpacing;
                    } else {
                        representative = this.createBorderDummyNode(node, NodeType.UPPER_COMPOUND_PORT, dummyNodes, elemMap, depth);
                        representative.getSize().x = insets.getLeft() + borderSpacing;
                    }
                } else {
                    representative = ((LPort)portRepresentative).getNode();
                }
            }
            if (!layeredNodes.contains(representative)) {
                layeredNodes.add(representative);
            }
            PortSide portSide = null;
            portSide = incoming ? PortSide.WEST : PortSide.EAST;
            LPort dummyPort = this.createDummyPort(representative, portSide, port, elemMap);
            float edgeSpacing = layeredGraph.getProperty(Properties.EDGE_SPACING_FACTOR).floatValue() * layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
            representative.getSize().y += (double)edgeSpacing;
            if (incoming) {
                KPoint targetPoint = edgeLayout.getTargetPoint();
                dummyPort.getPosition().x = (double)targetPoint.getX() - representative.getPosition().x;
                lEdge.setTarget(dummyPort);
            } else {
                KPoint sourcePoint = edgeLayout.getSourcePoint();
                dummyPort.getPosition().x = (double)sourcePoint.getX() - representative.getPosition().x;
                lEdge.setSource(dummyPort);
            }
            if (port == null) continue;
            elemMap.put(port, dummyPort);
            dummyPort.setProperty(Properties.ORIGIN, port);
            dummyPort.copyProperties(portLayout);
            dummyPort.getSize().x = portLayout.getWidth();
            dummyPort.getSize().y = portLayout.getHeight();
        }
        NodeType nodeType = null;
        if (incoming) {
            if (!layeredNodes.contains(upperBorder)) {
                layeredNodes.add(upperBorder);
            }
        } else {
            nodeType = NodeType.LOWER_COMPOUND_BORDER;
            LNode dummyNode = this.createBorderDummyNode(node, nodeType, dummyNodes, elemMap, depth);
            dummyNode.getSize().x = insets.getRight() + borderSpacing;
            if (!layeredNodes.contains(dummyNode)) {
                layeredNodes.add(dummyNode);
            }
        }
    }

    private void setCompoundDummyEdges(List<LNode> layeredNodes, Map<LNode, List<LNode>> parentChildMap, HashMap<KGraphElement, LGraphElement> elemMap) {
        block4: for (LNode lNode : layeredNodes) {
            NodeType nodeType = lNode.getProperty(Properties.NODE_TYPE);
            switch (nodeType) {
                case UPPER_COMPOUND_BORDER: 
                case UPPER_COMPOUND_PORT: {
                    LinkedList<LNode> list;
                    LPort targetPort;
                    LPort sourcePort;
                    LEdge dummyEdge;
                    for (LNode childCandidate : layeredNodes) {
                        if (childCandidate.getProperty(Properties.K_PARENT) == null || childCandidate.getProperty(Properties.K_PARENT) != lNode.getProperty(Properties.ORIGIN) || parentChildMap.containsKey(lNode) && parentChildMap.get(lNode).contains(childCandidate)) continue;
                        dummyEdge = new LEdge();
                        dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                        sourcePort = lNode.getPorts(PortSide.EAST).iterator().next();
                        dummyEdge.setSource(sourcePort);
                        targetPort = this.findDummyEdgePort(childCandidate, PortSide.WEST, elemMap);
                        dummyEdge.setTarget(targetPort);
                        if (parentChildMap.containsKey(lNode)) {
                            parentChildMap.get(lNode).add(childCandidate);
                            continue;
                        }
                        list = new LinkedList<LNode>();
                        list.add(childCandidate);
                        parentChildMap.put(lNode, list);
                    }
                    continue block4;
                }
                case LOWER_COMPOUND_BORDER: 
                case LOWER_COMPOUND_PORT: {
                    LinkedList<LNode> list;
                    LPort targetPort;
                    LPort sourcePort;
                    LEdge dummyEdge;
                    for (LNode childCandidate : layeredNodes) {
                        if (childCandidate.getProperty(Properties.K_PARENT) == null || childCandidate.getProperty(Properties.K_PARENT) != lNode.getProperty(Properties.ORIGIN) || parentChildMap.containsKey(lNode) && parentChildMap.get(lNode).contains(childCandidate)) continue;
                        dummyEdge = new LEdge();
                        dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                        sourcePort = this.findDummyEdgePort(childCandidate, PortSide.EAST, elemMap);
                        dummyEdge.setSource(sourcePort);
                        targetPort = lNode.getPorts(PortSide.WEST).iterator().next();
                        dummyEdge.setTarget(targetPort);
                        if (parentChildMap.containsKey(lNode)) {
                            parentChildMap.get(lNode).add(childCandidate);
                            continue;
                        }
                        list = new LinkedList();
                        list.add(childCandidate);
                        parentChildMap.put(lNode, list);
                    }
                    continue block4;
                }
            }
        }
    }

    private LEdge createLEdgeFromKEdge(KEdge kedge, Map<KGraphElement, LGraphElement> elemMap, LayeredGraph layeredGraph) {
        super.transformEdge(kedge, (KNode)layeredGraph.getProperty(Properties.ORIGIN), elemMap, layeredGraph);
        LEdge newEdge = (LEdge)elemMap.get(kedge);
        elemMap.put(kedge, newEdge);
        return newEdge;
    }

    private LNode createBorderDummyNode(KNode node, NodeType nodeType, List<LNode> dummyList, Map<KGraphElement, LGraphElement> elemMap, int depth) {
        MapPropertyHolder dummyNode = null;
        if (nodeType == NodeType.LOWER_COMPOUND_BORDER) {
            for (LNode dummy : dummyList) {
                if (dummy.getProperty(Properties.NODE_TYPE) != nodeType) continue;
                dummyNode = dummy;
            }
        }
        if (dummyNode == null) {
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            dummyNode = new LNode();
            dummyNode.setProperty(Properties.ORIGIN, node);
            dummyNode.setProperty(Properties.K_PARENT, node.getParent());
            ((LShape)dummyNode).getPosition().x = nodeLayout.getXpos();
            dummyNode.setProperty(Properties.NODE_TYPE, (Object)nodeType);
            if (nodeType == NodeType.UPPER_COMPOUND_BORDER || nodeType == NodeType.UPPER_COMPOUND_PORT) {
                dummyNode.setProperty(LayoutOptions.ALIGNMENT, (Object)Alignment.RIGHT);
            }
            if (nodeType == NodeType.LOWER_COMPOUND_BORDER || nodeType == NodeType.LOWER_COMPOUND_PORT) {
                dummyNode.setProperty(LayoutOptions.ALIGNMENT, (Object)Alignment.LEFT);
            }
            this.createDummyPort((LNode)dummyNode, PortSide.EAST, null, elemMap);
            this.createDummyPort((LNode)dummyNode, PortSide.WEST, null, elemMap);
            if (nodeType == NodeType.UPPER_COMPOUND_BORDER) {
                this.transferNodePropertiesAndAttributes(node, (LNode)dummyNode);
            }
            dummyList.add((LNode)dummyNode);
        }
        if (nodeType == NodeType.UPPER_COMPOUND_BORDER) {
            elemMap.put(node, (LGraphElement)dummyNode);
        }
        dummyNode.setProperty(Properties.DEPTH, depth);
        dummyNode.setProperty(Properties.COMPOUND_NODE, elemMap.get(node));
        return dummyNode;
    }

    private void transferNodePropertiesAndAttributes(KNode node, LNode dummyNode) {
        KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        dummyNode.copyProperties(nodeLayout);
    }

    private LPort createDummyPort(LNode node, PortSide side, KPort port, Map<KGraphElement, LGraphElement> elemMap) {
        LPort portRepresentative = null;
        if (port != null) {
            portRepresentative = (LPort)elemMap.get(port);
        }
        if (portRepresentative == null) {
            LPort dummyPort = new LPort();
            dummyPort.setSide(side);
            dummyPort.setNode(node);
            if (port != null) {
                elemMap.put(port, dummyPort);
            }
            return dummyPort;
        }
        return portRepresentative;
    }

    private boolean isDescendantNotSelf(KNode node, KNode candidate) {
        LinkedList<KNode> descendantsList = new LinkedList<KNode>();
        CompoundKGraphImporter.listDescendants(node, descendantsList);
        if (node.equals(candidate)) {
            return false;
        }
        return descendantsList.contains(candidate);
    }

    public static boolean isDescendant(KNode node, KNode candidate) {
        LinkedList<KNode> descendantsList = new LinkedList<KNode>();
        CompoundKGraphImporter.listDescendants(node, descendantsList);
        return descendantsList.contains(candidate);
    }

    private static void listDescendants(KNode currentNode, List<KNode> descendantsList) {
        if (currentNode.getChildren().isEmpty()) {
            descendantsList.add(currentNode);
        } else {
            for (KNode child : currentNode.getChildren()) {
                CompoundKGraphImporter.listDescendants(child, descendantsList);
            }
            descendantsList.add(currentNode);
        }
    }

    private LPort findDummyEdgePort(LNode node, PortSide side, Map<KGraphElement, LGraphElement> elemMap) {
        LPort port = null;
        for (LPort portCandidate : node.getPorts(side)) {
            NodeType nodeType = portCandidate.getNode().getProperty(Properties.NODE_TYPE);
            if (nodeType != NodeType.UPPER_COMPOUND_BORDER && !portCandidate.getProperty(Properties.LEAVE_DUMMY_PORT).booleanValue()) continue;
            port = portCandidate;
            break;
        }
        if (port == null) {
            port = this.createDummyPort(node, side, null, elemMap);
        }
        return port;
    }

    @Override
    public void applyLayout(LayeredGraph layeredGraph) {
        KNode target = (KNode)layeredGraph.getProperty(Properties.ORIGIN);
        KShapeLayout parentLayout = target.getData(KShapeLayout.class);
        float graphBorderSpacing = layeredGraph.getProperty(Properties.BORDER_SPACING).floatValue();
        KVector graphOffset = layeredGraph.getOffset();
        LinkedList<LEdge> edgeList = new LinkedList<LEdge>();
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            Object origin = lnode.getProperty(Properties.ORIGIN);
            if (origin instanceof KNode) {
                boolean isCompound;
                KNode kNode = (KNode)origin;
                this.applyNodeLayout(layeredGraph, lnode);
                boolean bl = isCompound = lnode.getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER;
                if (isCompound) {
                    this.compoundApplyPortLayout(kNode, layeredGraph, lnode);
                } else {
                    this.applyPortLayout((KNode)origin, layeredGraph, lnode);
                }
            } else if (origin instanceof KPort) {
                KShapeLayout kShapeLayout = ((KPort)origin).getData(KShapeLayout.class);
                KVector portPosition = this.getExternalPortPosition(layeredGraph, lnode, kShapeLayout.getWidth(), kShapeLayout.getHeight());
                kShapeLayout.setXpos((float)portPosition.x);
                kShapeLayout.setYpos((float)portPosition.y);
            }
            for (LPort lPort : lnode.getPorts()) {
                edgeList.addAll(lPort.getOutgoingEdges());
            }
        }
        EdgeRouting routing = parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        boolean splinesActive = routing == EdgeRouting.SPLINES;
        for (LEdge ledge : edgeList) {
            this.applyEdgeLayout(ledge, graphBorderSpacing, layeredGraph, splinesActive);
        }
        KInsets insets = parentLayout.getInsets();
        float f = (float)layeredGraph.getSize().x + 2.0f * graphBorderSpacing + insets.getLeft() + insets.getRight() + (float)graphOffset.x;
        float height = (float)layeredGraph.getSize().y + 2.0f * graphBorderSpacing + insets.getTop() + insets.getBottom() + (float)graphOffset.y;
        if (layeredGraph.getProperty(Properties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            parentLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
            KimlUtil.resizeNode(target, f, height, false);
        } else {
            KimlUtil.resizeNode(target, f, height, true);
        }
    }

    private void applyEdgeLayout(LEdge ledge, double graphBorderSpacing, LayeredGraph layeredGraph, boolean splinesActive) {
        KEdge kedge = (KEdge)ledge.getProperty(Properties.ORIGIN);
        KEdgeLayout edgeLayout = kedge.getData(KEdgeLayout.class);
        KVectorChain bendPoints = ledge.getBendPoints();
        KNode kSourceNode = kedge.getSource();
        KShapeLayout kSourceNodeLayout = kSourceNode.getData(KShapeLayout.class);
        KVector kSourceNodePosition = new KVector(kSourceNodeLayout.getXpos(), kSourceNodeLayout.getYpos());
        KNode kTargetNode = kedge.getTarget();
        KShapeLayout kTargetNodeLayout = kTargetNode.getData(KShapeLayout.class);
        KVector kTargetNodePosition = new KVector(kTargetNodeLayout.getXpos(), kTargetNodeLayout.getYpos());
        boolean descendantEdge = KimlUtil.isDescendant(kTargetNode, kSourceNode);
        LPort sourcePort = ledge.getSource();
        KVector sourcePortPosition = sourcePort.getPosition();
        LPort targetPort = ledge.getTarget();
        KVector targetPortPosition = targetPort.getPosition();
        KVector offsetBorderSpacingVec = new KVector(graphBorderSpacing, graphBorderSpacing);
        KVector graphOffset = layeredGraph.getOffset();
        offsetBorderSpacingVec.add(graphOffset);
        bendPoints.translate(offsetBorderSpacingVec);
        if (kSourceNode.getParent() != (KNode)layeredGraph.getProperty(Properties.ORIGIN) || descendantEdge) {
            KVector bendpointOffset = new KVector();
            bendpointOffset = descendantEdge ? this.getAbsolute(kSourceNode) : this.getAbsolute(kSourceNode.getParent());
            bendpointOffset.negate();
            bendPoints.translate(bendpointOffset);
        }
        KVector edgeStart = new KVector(0.0, 0.0);
        if (sourcePort.getNode().getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER && sourcePort.getSide() == PortSide.WEST && !(sourcePort.getProperty(Properties.ORIGIN) instanceof KPort)) {
            edgeStart.add(sourcePortPosition);
            edgeStart.y += sourcePort.getNode().getProperty(Properties.POSITION_DIFFERENCE).y;
        } else {
            edgeStart.add(sourcePortPosition);
        }
        if (descendantEdge) {
            edgeStart.x -= (double)kSourceNodeLayout.getInsets().getLeft();
            edgeStart.y -= (double)kSourceNodeLayout.getInsets().getTop();
        } else {
            edgeStart.add(kSourceNodePosition);
        }
        KVector difference = this.getAbsolute(kTargetNode).sub(this.getAbsolute(kSourceNode));
        if (!descendantEdge) {
            KVector sourceInsets = new KVector(kSourceNodeLayout.getInsets().getLeft(), kSourceNodeLayout.getInsets().getTop());
            difference.add(sourceInsets);
        }
        KVector edgeEnd = new KVector(0.0, 0.0);
        if (targetPort.getNode().getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER && targetPort.getSide() == PortSide.WEST && !(targetPort.getProperty(Properties.ORIGIN) instanceof KPort)) {
            edgeEnd.add(targetPortPosition);
            edgeEnd.y += targetPort.getNode().getProperty(Properties.POSITION_DIFFERENCE).y;
        } else {
            edgeEnd.add(targetPortPosition);
        }
        if (kSourceNode.getParent() == kTargetNode.getParent()) {
            edgeEnd.add(kTargetNodePosition);
        } else {
            if (!descendantEdge) {
                edgeEnd.add(kSourceNodePosition);
            }
            edgeEnd.add(difference);
            edgeEnd.x -= (double)kTargetNodeLayout.getInsets().getLeft();
            edgeEnd.y -= (double)kTargetNodeLayout.getInsets().getTop();
        }
        bendPoints.addFirst(edgeStart);
        bendPoints.addLast(edgeEnd);
        if (sourcePort.getProperty(Properties.ORIGIN) != null) {
            this.clip(edgeStart, sourcePort.getSize(), (KVector)bendPoints.get(1));
        }
        if (targetPort.getProperty(Properties.ORIGIN) != null) {
            this.clip(edgeEnd, targetPort.getSize(), (KVector)bendPoints.get(bendPoints.size() - 2));
        }
        edgeLayout.applyVectorChain(bendPoints);
        if (splinesActive) {
            edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
    }

    private void applyNodeLayout(LayeredGraph layeredGraph, LNode node) {
        float graphBorderSpacing = layeredGraph.getProperty(Properties.BORDER_SPACING).floatValue();
        KNode original = (KNode)node.getProperty(Properties.ORIGIN);
        KNode parent = original.getParent();
        KShapeLayout parentLayout = parent.getData(KShapeLayout.class);
        KInsets insetsParent = parentLayout.getInsets();
        KShapeLayout nodeLayout = original.getData(KShapeLayout.class);
        LNode parentRepresentative = null;
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            if (lnode.getProperty(Properties.ORIGIN) != parent) continue;
            parentRepresentative = lnode;
            break;
        }
        boolean isCompound = node.getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER;
        KVector size = node.getSize();
        if (isCompound) {
            nodeLayout.setSize((float)size.x, (float)size.y);
        }
        KVector position = node.getPosition();
        if (original.getParent() != layeredGraph.getProperty(Properties.ORIGIN)) {
            KVector parentRepPos = parentRepresentative.getPosition();
            KVector pointOfOrigin = new KVector(parentRepPos.x, parentRepPos.y);
            pointOfOrigin.x += (double)insetsParent.getLeft();
            pointOfOrigin.y += (double)insetsParent.getTop();
            float relativeX = (float)(position.x - pointOfOrigin.x);
            float relativeY = (float)(position.y - pointOfOrigin.y);
            nodeLayout.setPos(relativeX, relativeY);
        } else {
            KVector graphOffset = layeredGraph.getOffset();
            float newX = (float)(position.x + (double)graphBorderSpacing + graphOffset.x);
            float newY = (float)(position.y + (double)graphBorderSpacing + graphOffset.y);
            nodeLayout.setPos(newX, newY);
        }
    }

    private void applyPortLayout(KNode kNode, LayeredGraph layeredGraph, LNode representative) {
        KShapeLayout nodeLayout = kNode.getData(KShapeLayout.class);
        if (!nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS).isPosFixed()) {
            for (LPort lport : representative.getPorts()) {
                Object origin = lport.getProperty(Properties.ORIGIN);
                if (!(origin instanceof KPort)) continue;
                KShapeLayout portLayout = ((KPort)origin).getData(KShapeLayout.class);
                portLayout.setXpos((float)(lport.getPosition().x - lport.getSize().x / 2.0));
                portLayout.setYpos((float)(lport.getPosition().y - lport.getSize().y / 2.0));
            }
        }
    }

    private void compoundApplyPortLayout(KNode kNode, LayeredGraph layeredGraph, LNode representative) {
        for (LPort lport : representative.getPorts()) {
            Object origin = lport.getProperty(Properties.ORIGIN);
            if (!(origin instanceof KPort)) continue;
            KShapeLayout portLayout = ((KPort)origin).getData(KShapeLayout.class);
            portLayout.setPos((float)(lport.getPosition().x - lport.getSize().x / 2.0), (float)(lport.getPosition().y - lport.getSize().y / 2.0));
        }
    }

    private KVector getAbsolute(KNode kNode) {
        KShapeLayout nodeLayout = kNode.getData(KShapeLayout.class);
        KVector purePosition = new KVector(nodeLayout.getXpos(), nodeLayout.getYpos());
        KVector insets = new KVector(nodeLayout.getInsets().getLeft(), nodeLayout.getInsets().getTop());
        KVector position = new KVector(0.0, 0.0);
        position.add(purePosition);
        position.add(insets);
        if (kNode.getParent().getParent() == null) {
            return position;
        }
        return this.getAbsolute(kNode.getParent()).add(position);
    }

    private void createInclusionTree(LayeredGraph layeredGraph, KNode knode) {
        HashMap<KGraphElement, LGraphElement> elemMap = layeredGraph.getProperty(Properties.ELEMENT_MAP);
        LGraphElement representative = elemMap.get(knode);
        LinkedList children = new LinkedList();
        representative.setProperty(Properties.CHILDREN, children);
        KNode parent = knode.getParent();
        if (parent != null) {
            LGraphElement parentRep = elemMap.get(parent);
            representative.setProperty(Properties.PARENT, parentRep);
            parentRep.getProperty(Properties.CHILDREN).add((LNode)representative);
        }
        EList<KNode> ownChildren = knode.getChildren();
        for (KNode child : ownChildren) {
            this.createInclusionTree(layeredGraph, child);
        }
    }
}

