/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsProcessor
extends AbstractAlgorithm {
    public List<LayeredGraph> split(LayeredGraph graph) {
        Boolean separate = graph.getProperty(LayoutOptions.SEPARATE_CC);
        if (!graph.getProperty(Properties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS) && (separate == null || separate.booleanValue())) {
            for (LNode node : graph.getLayerlessNodes()) {
                node.id = 0;
            }
            LinkedList<LayeredGraph> components = new LinkedList<LayeredGraph>();
            for (LNode node : graph.getLayerlessNodes()) {
                List<LNode> component = this.dfs(node, null);
                if (component == null) continue;
                LayeredGraph newGraph = new LayeredGraph();
                newGraph.copyProperties(graph);
                newGraph.getInsets().copy(graph.getInsets());
                newGraph.getLayerlessNodes().addAll(component);
                components.add(newGraph);
            }
            return components;
        }
        ArrayList<LayeredGraph> result = new ArrayList<LayeredGraph>(1);
        result.add(graph);
        return result;
    }

    private List<LNode> dfs(LNode node, List<LNode> component) {
        if (node.id == 0) {
            node.id = 1;
            List<LNode> c = component;
            if (c == null) {
                c = new LinkedList<LNode>();
            }
            c.add(node);
            for (LPort port1 : node.getPorts()) {
                for (LPort port2 : port1.getConnectedPorts()) {
                    this.dfs(port2.getNode(), c);
                }
            }
            return c;
        }
        return null;
    }

    public LayeredGraph pack(List<LayeredGraph> components) {
        if (components.size() == 1) {
            LayeredGraph graph = components.get(0);
            for (Layer layer : graph) {
                graph.getLayerlessNodes().addAll(layer.getNodes());
            }
            graph.getLayers().clear();
            return graph;
        }
        if (components.size() <= 0) {
            return new LayeredGraph();
        }
        for (LayeredGraph graph : components) {
            int priority = 0;
            for (Layer layer : graph) {
                for (LNode node : layer) {
                    priority += node.getProperty(Properties.PRIORITY).intValue();
                }
            }
            graph.id = priority;
        }
        Collections.sort(components, new Comparator<LayeredGraph>(){

            @Override
            public int compare(LayeredGraph graph1, LayeredGraph graph2) {
                int prio = graph2.id - graph1.id;
                if (prio == 0) {
                    double size1 = graph1.getSize().x * graph1.getSize().y;
                    double size2 = graph2.getSize().x * graph2.getSize().y;
                    return Double.compare(size1, size2);
                }
                return prio;
            }
        });
        LayeredGraph result = new LayeredGraph();
        result.copyProperties(components.get(0));
        result.getInsets().copy(components.get(0).getInsets());
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (LayeredGraph graph : components) {
            KVector size = graph.getSize();
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * result.getProperty(Properties.ASPECT_RATIO).floatValue()));
        double spacing = 2.0f * result.getProperty(Properties.OBJ_SPACING).floatValue();
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (LayeredGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.moveGraph(result, graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        result.getSize().x = broadestRow;
        result.getSize().y = ypos + highestBox;
        return result;
    }

    private void moveGraph(LayeredGraph destGraph, LayeredGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = sourceGraph.getOffset().translate(offsetx, offsety);
        for (Layer layer : sourceGraph) {
            for (LNode node : layer) {
                node.getPosition().add(graphOffset);
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        edge.getBendPoints().translate(graphOffset);
                        for (LLabel label : edge.getLabels()) {
                            label.getPosition().add(graphOffset);
                        }
                    }
                }
                destGraph.getLayerlessNodes().add(node);
            }
        }
    }
}

