/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.IGraphImporter;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.EdgeConstraint;
import de.cau.cs.kieler.klay.layered.properties.InLayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphImporter<T>
implements IGraphImporter<T> {
    protected LNode createExternalPortDummy(Object port, PortConstraints portConstraints, PortSide portSide, int netFlow, KVector portNodeSize, KVector portPosition, KVector portSize) {
        PortSide finalExternalPortSide = portSide;
        LNode dummy = new LNode();
        dummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.EXTERNAL_PORT);
        dummy.setProperty(Properties.ORIGIN, port);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        LPort dummyPort = new LPort();
        dummyPort.setNode(dummy);
        if (!portConstraints.isSideFixed()) {
            finalExternalPortSide = netFlow > 0 ? PortSide.EAST : PortSide.WEST;
        }
        switch (finalExternalPortSide) {
            case WEST: {
                dummy.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
                dummy.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                dummy.getSize().y = portSize.y;
                dummyPort.setSide(PortSide.EAST);
                dummyPort.getPosition().y = portSize.y / 2.0;
                break;
            }
            case EAST: {
                dummy.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
                dummy.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                dummy.getSize().y = portSize.y;
                dummyPort.setSide(PortSide.WEST);
                dummyPort.getPosition().y = portSize.y / 2.0;
                break;
            }
            case NORTH: {
                dummy.setProperty(Properties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
                dummy.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                dummy.getSize().x = portSize.x;
                dummyPort.setSide(PortSide.SOUTH);
                dummyPort.getPosition().x = portSize.x / 2.0;
                break;
            }
            case SOUTH: {
                dummy.setProperty(Properties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
                dummy.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                dummy.getSize().x = portSize.x;
                dummyPort.setSide(PortSide.NORTH);
                dummyPort.getPosition().x = portSize.x / 2.0;
                break;
            }
            default: {
                assert (false) : finalExternalPortSide;
                break;
            }
        }
        if (portConstraints.isOrderFixed()) {
            double positionOrRatio = 0.0;
            switch (finalExternalPortSide) {
                case EAST: 
                case WEST: {
                    positionOrRatio = portPosition.y;
                    if (!portConstraints.isRatioFixed()) break;
                    positionOrRatio /= portNodeSize.y;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    positionOrRatio = portPosition.x;
                    if (!portConstraints.isRatioFixed()) break;
                    positionOrRatio /= portNodeSize.x;
                }
            }
            dummy.setProperty(Properties.EXT_PORT_RATIO_OR_POSITION, positionOrRatio);
        }
        dummy.setProperty(Properties.EXT_PORT_SIDE, (Object)finalExternalPortSide);
        return dummy;
    }

    protected KVector getExternalPortPosition(LayeredGraph graph, LNode portDummy, double portWidth, double portHeight) {
        KVector portPosition = new KVector(portDummy.getPosition());
        portPosition.x += portDummy.getSize().x / 2.0;
        portPosition.y += portDummy.getSize().y / 2.0;
        float portOffset = portDummy.getProperty(LayoutOptions.OFFSET).floatValue();
        KVector size = graph.getSize();
        LInsets.Double insets = graph.getInsets();
        float borderSpacing = graph.getProperty(Properties.BORDER_SPACING).floatValue();
        KVector offset = graph.getOffset();
        switch (portDummy.getProperty(Properties.EXT_PORT_SIDE)) {
            case NORTH: {
                portPosition.x += insets.left + (double)borderSpacing + offset.x - portWidth / 2.0;
                portPosition.y = -portHeight - (double)portOffset;
                break;
            }
            case EAST: {
                portPosition.x = size.x + insets.left + insets.right + (double)(2.0f * borderSpacing) + (double)portOffset;
                portPosition.y += insets.top + (double)borderSpacing + offset.y - portHeight / 2.0;
                break;
            }
            case SOUTH: {
                portPosition.x += insets.left + (double)borderSpacing + offset.x - portWidth / 2.0;
                portPosition.y = size.y + insets.top + insets.bottom + (double)(2.0f * borderSpacing) + (double)portOffset;
                break;
            }
            case WEST: {
                portPosition.x = -portWidth - (double)portOffset;
                portPosition.y += insets.top + (double)borderSpacing + offset.y - portHeight / 2.0;
            }
        }
        return portPosition;
    }
}

