/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util.alg;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxSorter
extends AbstractAlgorithm {
    public List<KNode> sort(KNode parentNode, final boolean interactive) {
        this.getMonitor().begin("Box sorting", 1.0f);
        LinkedList<KNode> sortedBoxes = new LinkedList<KNode>(parentNode.getChildren());
        Collections.sort(sortedBoxes, new Comparator<KNode>(){

            @Override
            public int compare(KNode child1, KNode child2) {
                KShapeLayout layout2;
                Integer prio2;
                KShapeLayout layout1 = child1.getData(KShapeLayout.class);
                Integer prio1 = layout1.getProperty(LayoutOptions.PRIORITY);
                if (prio1 == null) {
                    prio1 = 0;
                }
                if ((prio2 = (layout2 = child2.getData(KShapeLayout.class)).getProperty(LayoutOptions.PRIORITY)) == null) {
                    prio2 = 0;
                }
                if (prio1 > prio2) {
                    return -1;
                }
                if (prio1 < prio2) {
                    return 1;
                }
                if (interactive) {
                    int c = Float.compare(layout1.getYpos(), layout2.getYpos());
                    if (c != 0) {
                        return c;
                    }
                    c = Float.compare(layout1.getXpos(), layout2.getXpos());
                    if (c != 0) {
                        return c;
                    }
                }
                float size1 = layout1.getWidth() * layout1.getHeight();
                float size2 = layout2.getWidth() * layout2.getHeight();
                return Float.compare(size1, size2);
            }
        });
        this.getMonitor().done();
        return sortedBoxes;
    }
}

