/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util.alg;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxPlacer
extends AbstractAlgorithm {
    public static final float DEF_ASPECT_RATIO = 1.3f;

    public void placeBoxes(List<KNode> sortedBoxes, KNode parentNode, float objSpacing, float borderSpacing, boolean expandNodes) {
        KShapeLayout parentLayout = parentNode.getData(KShapeLayout.class);
        KInsets insets = parentLayout.getInsets();
        float minWidth = Math.max(parentLayout.getProperty(LayoutOptions.MIN_WIDTH).floatValue() - insets.getLeft() - insets.getRight(), 0.0f);
        float minHeight = Math.max(parentLayout.getProperty(LayoutOptions.MIN_HEIGHT).floatValue() - insets.getTop() - insets.getBottom(), 0.0f);
        float aspectRatio = parentLayout.getProperty(LayoutOptions.ASPECT_RATIO).floatValue();
        if (aspectRatio <= 0.0f) {
            aspectRatio = 1.3f;
        }
        KVector parentSize = this.placeBoxes(sortedBoxes, objSpacing, borderSpacing, minWidth, minHeight, expandNodes, aspectRatio);
        float width = insets.getLeft() + (float)parentSize.x + insets.getRight();
        float height = insets.getTop() + (float)parentSize.y + insets.getBottom();
        KimlUtil.resizeNode(parentNode, width, height, false);
    }

    private KVector placeBoxes(List<KNode> sortedBoxes, float minSpacing, float borderSpacing, float minTotalWidth, float minTotalHeight, boolean expandNodes, float aspectRatio) {
        float maxRowWidth = 0.0f;
        float totalArea = 0.0f;
        for (KNode box : sortedBoxes) {
            KShapeLayout boxLayout = box.getData(KShapeLayout.class);
            if (!boxLayout.getProperty(LayoutOptions.FIXED_SIZE).booleanValue()) {
                KimlUtil.resizeNode(box);
            }
            for (KEdge edge : box.getOutgoingEdges()) {
                edge.getData(KEdgeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
            }
            maxRowWidth = Math.max(maxRowWidth, boxLayout.getWidth());
            totalArea += boxLayout.getWidth() * boxLayout.getHeight();
        }
        maxRowWidth = Math.max(maxRowWidth, (float)Math.sqrt(totalArea) * aspectRatio) + borderSpacing;
        float xpos = borderSpacing;
        float ypos = borderSpacing;
        float highestBox = 0.0f;
        float broadestRow = 2.0f * borderSpacing;
        LinkedList<Integer> rowIndices = new LinkedList<Integer>();
        rowIndices.add(0);
        LinkedList<Float> rowHeights = new LinkedList<Float>();
        ListIterator<KNode> boxIter = sortedBoxes.listIterator();
        while (boxIter.hasNext()) {
            KNode box = boxIter.next();
            KShapeLayout boxLayout = box.getData(KShapeLayout.class);
            float width = boxLayout.getWidth();
            float height = boxLayout.getHeight();
            if (xpos + width > maxRowWidth) {
                if (expandNodes) {
                    rowHeights.addLast(Float.valueOf(highestBox));
                    rowIndices.addLast(boxIter.previousIndex());
                }
                xpos = borderSpacing;
                ypos += highestBox + minSpacing;
                highestBox = 0.0f;
                broadestRow = Math.max(broadestRow, 2.0f * borderSpacing + width);
            }
            boxLayout.setPos(xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + width + borderSpacing);
            highestBox = Math.max(highestBox, height);
            xpos += width + minSpacing;
            KimlUtil.excludePorts(box);
            KimlUtil.excludeLabels(box);
        }
        broadestRow = Math.max(broadestRow, minTotalWidth);
        float totalHeight = ypos + highestBox + borderSpacing;
        if (totalHeight < minTotalHeight) {
            highestBox += minTotalHeight - totalHeight;
            totalHeight = minTotalHeight;
        }
        if (expandNodes) {
            xpos = borderSpacing;
            boxIter = sortedBoxes.listIterator();
            rowIndices.addLast(sortedBoxes.size());
            ListIterator rowIndexIter = rowIndices.listIterator();
            int nextRowIndex = (Integer)rowIndexIter.next();
            rowHeights.addLast(Float.valueOf(highestBox));
            ListIterator rowHeightIter = rowHeights.listIterator();
            float rowHeight = 0.0f;
            while (boxIter.hasNext()) {
                if (boxIter.nextIndex() == nextRowIndex) {
                    xpos = borderSpacing;
                    rowHeight = ((Float)rowHeightIter.next()).floatValue();
                    nextRowIndex = (Integer)rowIndexIter.next();
                }
                KNode box = boxIter.next();
                KShapeLayout boxLayout = box.getData(KShapeLayout.class);
                boxLayout.setHeight(rowHeight);
                if (boxIter.nextIndex() == nextRowIndex) {
                    float newWidth = broadestRow - xpos - borderSpacing;
                    float oldWidth = boxLayout.getWidth();
                    boxLayout.setWidth(newWidth);
                    KimlUtil.translate(box, (newWidth - oldWidth) / 2.0f, 0.0f);
                }
                xpos += boxLayout.getWidth() + minSpacing;
            }
        }
        return new KVector(broadestRow, totalHeight);
    }
}

