/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Random;

public class RandomLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "de.cau.cs.kieler.random";
    private static final float DEF_ASPECT_RATIO = 1.6f;
    private static final float DEF_SPACING = 15.0f;
    private static final int MAX_BENDS = 5;
    private static final float RAND_FACT = 0.2f;

    public void doLayout(KNode parentNode, IKielerProgressMonitor progressMonitor) {
        float offset;
        float spacing;
        progressMonitor.begin("Random Layout", 1.0f);
        if (parentNode.getChildren().size() == 0) {
            progressMonitor.done();
            return;
        }
        KShapeLayout parentLayout = parentNode.getData(KShapeLayout.class);
        Integer randomSeed = parentLayout.getProperty(LayoutOptions.RANDOM_SEED);
        Random random = randomSeed != null && randomSeed != 0 ? new Random(randomSeed.intValue()) : new Random();
        float aspectRatio = parentLayout.getProperty(LayoutOptions.ASPECT_RATIO).floatValue();
        if (aspectRatio <= 0.0f) {
            aspectRatio = 1.6f;
        }
        if ((spacing = parentLayout.getProperty(LayoutOptions.SPACING).floatValue()) <= 0.0f) {
            spacing = 15.0f;
        }
        if ((offset = parentLayout.getProperty(LayoutOptions.BORDER_SPACING).floatValue()) <= 0.0f) {
            offset = 15.0f;
        }
        this.randomize(parentNode, random, aspectRatio, spacing, offset);
        progressMonitor.done();
    }

    private void randomize(KNode parent, Random random, float aspectRatio, float spacing, float offset) {
        float nodesArea = 0.0f;
        float maxWidth = 0.0f;
        float maxHeight = 0.0f;
        int m = 1;
        for (KNode node : parent.getChildren()) {
            m += node.getOutgoingEdges().size();
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            float width = nodeLayout.getWidth();
            maxWidth = Math.max(maxWidth, width);
            float height = nodeLayout.getHeight();
            maxHeight = Math.max(maxHeight, height);
            nodesArea += width * height;
        }
        int n = parent.getChildren().size();
        float drawArea = nodesArea + 2.0f * spacing * spacing * (float)m * (float)n;
        float areaSqrt = (float)Math.sqrt(drawArea);
        float drawWidth = Math.max(areaSqrt * aspectRatio, maxWidth);
        float drawHeight = Math.max(areaSqrt / aspectRatio, maxHeight);
        for (KNode node : parent.getChildren()) {
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            float x = offset + random.nextFloat() * (drawWidth - nodeLayout.getWidth());
            float y = offset + random.nextFloat() * (drawHeight - nodeLayout.getHeight());
            nodeLayout.setPos(x, y);
            KimlUtil.excludeLabels(node);
        }
        float totalWidth = drawWidth + 2.0f * offset;
        float totalHeight = drawHeight + 2.0f * offset;
        for (KNode source : parent.getChildren()) {
            for (KEdge edge : source.getOutgoingEdges()) {
                KNode target = edge.getTarget();
                if (source.getParent() == target.getParent()) {
                    this.randomize(edge, source, target, random, totalWidth, totalHeight);
                    continue;
                }
                edge.getData(KEdgeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
            }
        }
        KShapeLayout parentLayout = parent.getData(KShapeLayout.class);
        KInsets insets = parentLayout.getInsets();
        KimlUtil.resizeNode(parent, totalWidth += insets.getLeft() + insets.getRight(), totalHeight += insets.getTop() + insets.getBottom(), false);
    }

    private void randomize(KEdge edge, KNode source, KNode target, Random random, float drawWidth, float drawHeight) {
        KEdgeLayout edgeLayout = edge.getData(KEdgeLayout.class);
        KShapeLayout sourceLayout = source.getData(KShapeLayout.class);
        float sourceX = sourceLayout.getXpos();
        float sourceY = sourceLayout.getYpos();
        float sourceWidth = sourceLayout.getWidth() / 2.0f;
        float sourceHeight = sourceLayout.getHeight() / 2.0f;
        if (edge.getSourcePort() != null) {
            KShapeLayout portLayout = edge.getSourcePort().getData(KShapeLayout.class);
            sourceWidth = portLayout.getWidth() / 2.0f;
            sourceHeight = portLayout.getHeight() / 2.0f;
            sourceX += portLayout.getXpos();
            sourceY += portLayout.getYpos();
        }
        sourceX += sourceWidth;
        sourceY += sourceHeight;
        KShapeLayout targetLayout = target.getData(KShapeLayout.class);
        float targetX = targetLayout.getXpos();
        float targetY = targetLayout.getYpos();
        float targetWidth = targetLayout.getWidth() / 2.0f;
        float targetHeight = targetLayout.getHeight() / 2.0f;
        if (edge.getTargetPort() != null) {
            KShapeLayout portLayout = edge.getTargetPort().getData(KShapeLayout.class);
            targetWidth = portLayout.getWidth() / 2.0f;
            targetHeight = portLayout.getHeight() / 2.0f;
            targetX += portLayout.getXpos();
            targetY += portLayout.getYpos();
        }
        targetY += targetHeight;
        float sourcePX = targetX += targetWidth;
        if (targetX > sourceX + sourceWidth) {
            sourcePX = sourceX + sourceWidth;
        } else if (targetX < sourceX - sourceWidth) {
            sourcePX = sourceX - sourceWidth;
        }
        float sourcePY = targetY;
        if (targetY > sourceY + sourceHeight) {
            sourcePY = sourceY + sourceHeight;
        } else if (targetY < sourceY - sourceHeight) {
            sourcePY = sourceY - sourceHeight;
        }
        if (sourcePX > sourceX - sourceWidth && sourcePX < sourceX + sourceWidth && sourcePY > sourceY - sourceHeight && sourcePY < sourceY + sourceHeight) {
            sourcePX = sourceX + sourceWidth;
        }
        KPoint sourcePoint = edgeLayout.getSourcePoint();
        sourcePoint.setPos(sourcePX, sourcePY);
        float targetPX = sourceX;
        if (sourceX > targetY + targetWidth) {
            targetPX = targetY + targetWidth;
        } else if (sourceX < targetY - targetWidth) {
            targetPX = targetY - targetWidth;
        }
        float targetPY = sourceY;
        if (sourceY > targetY + targetHeight) {
            targetPY = targetY + targetHeight;
        } else if (sourceY < targetY - targetHeight) {
            targetPY = targetY - targetHeight;
        }
        if (targetPX > targetX - targetWidth && targetPX < targetX + targetWidth && targetPY > targetY - targetHeight && targetPY < targetY + targetHeight) {
            targetPY = targetY + targetHeight;
        }
        KPoint targetPoint = edgeLayout.getTargetPoint();
        targetPoint.setPos(targetPX, targetPY);
        edgeLayout.getBendPoints().clear();
        int bendsNum = random.nextInt(5);
        if (source == target) {
            ++bendsNum;
        }
        float xdiff = targetPX - sourcePX;
        float ydiff = targetPY - sourcePY;
        float totalDist = (float)Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        float maxRand = totalDist * 0.2f;
        float xincr = xdiff / (float)(bendsNum + 1);
        float yincr = ydiff / (float)(bendsNum + 1);
        float x = sourcePX;
        float y = sourcePY;
        int i = 0;
        while (i < bendsNum) {
            x += xincr;
            y += yincr;
            float randx = x + random.nextFloat() * maxRand - maxRand / 2.0f;
            if (randx < 0.0f) {
                randx = 1.0f;
            } else if (randx > drawWidth) {
                randx = drawWidth - 1.0f;
            }
            float randy = y + random.nextFloat() * maxRand - maxRand / 2.0f;
            if (randy < 0.0f) {
                randy = 1.0f;
            } else if (randy > drawHeight) {
                randy = drawHeight - 1.0f;
            }
            KPoint bendPoint = KLayoutDataFactory.eINSTANCE.createKPoint();
            bendPoint.setX(randx);
            bendPoint.setY(randy);
            edgeLayout.getBendPoints().add(bendPoint);
            ++i;
        }
        KimlUtil.excludeLabels(edge);
    }
}

