/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KGraphFactory;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KimlUtil {
    private static final float MIN_NODE_SIZE = 16.0f;

    private KimlUtil() {
    }

    public static KNode createInitializedNode() {
        KNode layoutNode = KGraphFactory.eINSTANCE.createKNode();
        KShapeLayout layout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        layout.setInsets(KLayoutDataFactory.eINSTANCE.createKInsets());
        layoutNode.getData().add(layout);
        return layoutNode;
    }

    public static KEdge createInitializedEdge() {
        KEdge edge = KGraphFactory.eINSTANCE.createKEdge();
        KEdgeLayout edgeLayout = KLayoutDataFactory.eINSTANCE.createKEdgeLayout();
        edgeLayout.setSourcePoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edgeLayout.setTargetPoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edge.getData().add(edgeLayout);
        return edge;
    }

    public static KPort createInitializedPort() {
        KPort port = KGraphFactory.eINSTANCE.createKPort();
        KShapeLayout labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        port.getData().add(labelLayout);
        return port;
    }

    public static KLabel createInitializedLabel(KLabeledGraphElement element) {
        KLabel label = KGraphFactory.eINSTANCE.createKLabel();
        KShapeLayout labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        label.getData().add(labelLayout);
        label.setText("");
        label.setParent(element);
        return label;
    }

    public static void createIdentifier(KGraphElement element) {
        KIdentifier identifier = element.getData(KIdentifier.class);
        if (identifier == null) {
            identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
            element.getData().add(identifier);
        }
        identifier.setId(Integer.toString(element.hashCode()));
    }

    public static PortSide calcPortSide(KPort port, Direction direction) {
        KShapeLayout portLayout = port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = port.getNode().getData(KShapeLayout.class);
        float xpos = portLayout.getXpos();
        float ypos = portLayout.getYpos();
        float nodeWidth = nodeLayout.getWidth();
        float nodeHeight = nodeLayout.getHeight();
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0f) {
                    return PortSide.WEST;
                }
                if (!(xpos + portLayout.getWidth() > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0f) {
                    return PortSide.NORTH;
                }
                if (!(ypos + portLayout.getHeight() > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        float widthPercent = (xpos + portLayout.getWidth() / 2.0f) / nodeWidth;
        float heightPercent = (ypos + portLayout.getHeight() / 2.0f) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0f && widthPercent - heightPercent <= 0.0f) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0f && widthPercent - heightPercent >= 0.0f) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5f) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    public static float calcPortOffset(KPort port, PortSide side) {
        KShapeLayout portLayout = port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = port.getNode().getData(KShapeLayout.class);
        switch (side) {
            case NORTH: {
                return -(portLayout.getYpos() + portLayout.getHeight());
            }
            case EAST: {
                return portLayout.getXpos() - nodeLayout.getWidth();
            }
            case SOUTH: {
                return portLayout.getYpos() - nodeLayout.getHeight();
            }
            case WEST: {
                return -(portLayout.getXpos() + portLayout.getWidth());
            }
        }
        return 0.0f;
    }

    public static KPort[] getSortedPorts(KNode node) {
        KPort[] ports = node.getPorts().toArray(new KPort[node.getPorts().size()]);
        Arrays.sort(ports, new Comparator<KPort>(){

            @Override
            public int compare(KPort port1, KPort port2) {
                KShapeLayout port1Layout = port1.getData(KShapeLayout.class);
                PortSide port1Side = port1Layout.getProperty(LayoutOptions.PORT_SIDE);
                int port1Rank = port1Layout.getProperty(LayoutOptions.PORT_RANK);
                KShapeLayout port2Layout = port2.getData(KShapeLayout.class);
                PortSide port2Side = port2Layout.getProperty(LayoutOptions.PORT_SIDE);
                int port2Rank = port2Layout.getProperty(LayoutOptions.PORT_RANK);
                int result = 0;
                switch (port1Side) {
                    case NORTH: {
                        if (port2Side == PortSide.NORTH) {
                            result = Float.compare(port1Layout.getXpos(), port2Layout.getXpos());
                            if (result != 0) break;
                            result = port1Rank > port2Rank ? 1 : (port1Rank < port2Rank ? -1 : 0);
                            break;
                        }
                        result = -1;
                        break;
                    }
                    case EAST: {
                        if (port2Side == PortSide.NORTH) {
                            result = 1;
                            break;
                        }
                        if (port2Side == PortSide.EAST) {
                            result = Float.compare(port1Layout.getYpos(), port2Layout.getYpos());
                            if (result != 0) break;
                            result = port1Rank > port2Rank ? 1 : (port1Rank < port2Rank ? -1 : 0);
                            break;
                        }
                        result = -1;
                        break;
                    }
                    case SOUTH: {
                        if (port2Side == PortSide.NORTH || port2Side == PortSide.EAST) {
                            result = 1;
                            break;
                        }
                        if (port2Side == PortSide.SOUTH) {
                            result = Float.compare(port2Layout.getXpos(), port1Layout.getXpos());
                            if (result != 0) break;
                            result = port1Rank > port2Rank ? 1 : (port1Rank < port2Rank ? -1 : 0);
                            break;
                        }
                        result = -1;
                        break;
                    }
                    case WEST: {
                        if (port2Side == PortSide.NORTH || port2Side == PortSide.EAST || port2Side == PortSide.SOUTH) {
                            result = 1;
                            break;
                        }
                        if (port2Side == PortSide.WEST) {
                            result = Float.compare(port2Layout.getYpos(), port1Layout.getYpos());
                            if (result != 0) break;
                            result = port1Rank > port2Rank ? 1 : (port1Rank < port2Rank ? -1 : 0);
                            break;
                        }
                        result = -1;
                    }
                }
                return result;
            }
        });
        return ports;
    }

    public static void calcPortRanks(KNode node) {
        KPort[] ports = KimlUtil.getSortedPorts(node);
        int i = 0;
        while (i < ports.length) {
            ports[i].getData(KShapeLayout.class).setProperty(LayoutOptions.PORT_RANK, i);
            ++i;
        }
    }

    public static void fillPortInfo(KNode node, Direction direction) {
        KShapeLayout layoutData = node.getData(KShapeLayout.class);
        PortConstraints portConstraints = layoutData.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.FREE) {
            switch (direction) {
                case DOWN: {
                    Iterator iterator = node.getPorts().iterator();
                    while (iterator.hasNext()) {
                        KPort port;
                        port.getData(KShapeLayout.class).setProperty(LayoutOptions.PORT_SIDE, (Object)(KimlUtil.calcFlow(port = (KPort)iterator.next()) < 0 ? PortSide.NORTH : PortSide.SOUTH));
                    }
                    break;
                }
                case UP: {
                    Iterator iterator = node.getPorts().iterator();
                    while (iterator.hasNext()) {
                        KPort port;
                        port.getData(KShapeLayout.class).setProperty(LayoutOptions.PORT_SIDE, (Object)(KimlUtil.calcFlow(port = (KPort)iterator.next()) < 0 ? PortSide.SOUTH : PortSide.NORTH));
                    }
                    break;
                }
                case LEFT: {
                    Iterator iterator = node.getPorts().iterator();
                    while (iterator.hasNext()) {
                        KPort port;
                        port.getData(KShapeLayout.class).setProperty(LayoutOptions.PORT_SIDE, (Object)(KimlUtil.calcFlow(port = (KPort)iterator.next()) < 0 ? PortSide.EAST : PortSide.WEST));
                    }
                    break;
                }
                default: {
                    Iterator iterator = node.getPorts().iterator();
                    while (iterator.hasNext()) {
                        KPort port;
                        port.getData(KShapeLayout.class).setProperty(LayoutOptions.PORT_SIDE, (Object)(KimlUtil.calcFlow(port = (KPort)iterator.next()) < 0 ? PortSide.WEST : PortSide.EAST));
                    }
                    break block0;
                }
            }
            layoutData.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
        } else if (portConstraints != PortConstraints.UNDEFINED) {
            boolean ranksUndefined = false;
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = port.getData(KShapeLayout.class);
                if (portLayout.getProperty(LayoutOptions.PORT_RANK) < 0) {
                    ranksUndefined = true;
                }
                if (portLayout.getProperty(LayoutOptions.PORT_SIDE) != PortSide.UNDEFINED) continue;
                portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)KimlUtil.calcPortSide(port, direction));
            }
            if (ranksUndefined) {
                KimlUtil.calcPortRanks(node);
            }
        }
    }

    public static void placePoints(List<KPoint> points, float minPos, float maxPos, float offset, boolean vertical, boolean forward) {
        float pos;
        float dist = (maxPos - minPos) / (float)(points.size() + 1);
        if (forward) {
            pos = minPos + offset;
        } else {
            pos = maxPos + offset;
            dist = -dist;
        }
        if (vertical) {
            for (KPoint point : points) {
                point.setY(pos += dist);
            }
        } else {
            for (KPoint point : points) {
                point.setX(pos += dist);
            }
        }
    }

    public static KVector resizeNode(KNode node) {
        KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
        PortConstraints portConstraints = nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        float minNorth = 2.0f;
        float minEast = 2.0f;
        float minSouth = 2.0f;
        float minWest = 2.0f;
        Direction direction = node.getParent() == null ? nodeLayout.getProperty(LayoutOptions.DIRECTION) : node.getParent().getData(KShapeLayout.class).getProperty(LayoutOptions.DIRECTION);
        for (KPort port : node.getPorts()) {
            KShapeLayout portLayout = port.getData(KShapeLayout.class);
            PortSide portSide = portLayout.getProperty(LayoutOptions.PORT_SIDE);
            if (portSide == PortSide.UNDEFINED) {
                portSide = KimlUtil.calcPortSide(port, direction);
                portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
            }
            if (portConstraints == PortConstraints.FIXED_POS) {
                switch (portSide) {
                    case NORTH: {
                        minNorth = Math.max(minNorth, portLayout.getXpos() + portLayout.getWidth());
                        break;
                    }
                    case EAST: {
                        minEast = Math.max(minEast, portLayout.getYpos() + portLayout.getHeight());
                        break;
                    }
                    case SOUTH: {
                        minSouth = Math.max(minSouth, portLayout.getXpos() + portLayout.getWidth());
                        break;
                    }
                    case WEST: {
                        minWest = Math.max(minWest, portLayout.getYpos() + portLayout.getHeight());
                    }
                }
                continue;
            }
            switch (portSide) {
                case NORTH: {
                    minNorth += portLayout.getWidth() + 2.0f;
                    break;
                }
                case EAST: {
                    minEast += portLayout.getHeight() + 2.0f;
                    break;
                }
                case SOUTH: {
                    minSouth += portLayout.getWidth() + 2.0f;
                    break;
                }
                case WEST: {
                    minWest += portLayout.getHeight() + 2.0f;
                }
            }
        }
        float newWidth = KielerMath.maxf(16.0f, minNorth, minSouth);
        float newHeight = KielerMath.maxf(16.0f, minEast, minWest);
        return KimlUtil.resizeNode(node, newWidth, newHeight, true);
    }

    public static KVector resizeNode(KNode node, float newWidth, float newHeight, boolean movePorts) {
        KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
        if (nodeLayout.getProperty(LayoutOptions.NO_LAYOUT).booleanValue()) {
            return null;
        }
        KVector oldSize = new KVector(nodeLayout.getWidth(), nodeLayout.getHeight());
        KVector newSize = new KVector(Math.max(newWidth, nodeLayout.getProperty(LayoutOptions.MIN_WIDTH).floatValue()), Math.max(newHeight, nodeLayout.getProperty(LayoutOptions.MIN_HEIGHT).floatValue()));
        float widthRatio = (float)(newSize.x / oldSize.x);
        float heightRatio = (float)(newSize.y / oldSize.y);
        float widthDiff = (float)(newSize.x - oldSize.x);
        float heightDiff = (float)(newSize.y - oldSize.y);
        if (movePorts) {
            Direction direction = node.getParent() == null ? nodeLayout.getProperty(LayoutOptions.DIRECTION) : node.getParent().getData(KShapeLayout.class).getProperty(LayoutOptions.DIRECTION);
            boolean fixedPorts = nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS;
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = port.getData(KShapeLayout.class);
                PortSide portSide = portLayout.getProperty(LayoutOptions.PORT_SIDE);
                if (portSide == PortSide.UNDEFINED) {
                    portSide = KimlUtil.calcPortSide(port, direction);
                    portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
                }
                switch (portSide) {
                    case NORTH: {
                        if (fixedPorts) break;
                        portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        break;
                    }
                    case EAST: {
                        portLayout.setXpos(portLayout.getXpos() + widthDiff);
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                        break;
                    }
                    case SOUTH: {
                        if (!fixedPorts) {
                            portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        }
                        portLayout.setYpos(portLayout.getYpos() + heightDiff);
                        break;
                    }
                    case WEST: {
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                    }
                }
            }
        }
        nodeLayout.setSize((float)newSize.x, (float)newSize.y);
        for (KLabel label : node.getLabels()) {
            float midy;
            float heightPercent;
            KShapeLayout labelLayout = label.getData(KShapeLayout.class);
            float midx = labelLayout.getXpos() + labelLayout.getWidth() / 2.0f;
            float widthPercent = midx / (float)oldSize.x;
            if (!(widthPercent + (heightPercent = (midy = labelLayout.getYpos() + labelLayout.getHeight() / 2.0f) / (float)oldSize.y) >= 1.0f)) continue;
            if (widthPercent - heightPercent > 0.0f && midy >= 0.0f) {
                labelLayout.setXpos(labelLayout.getXpos() + widthDiff);
                labelLayout.setYpos(labelLayout.getYpos() + heightDiff * heightPercent);
                continue;
            }
            if (!(widthPercent - heightPercent < 0.0f) || !(midx >= 0.0f)) continue;
            labelLayout.setXpos(labelLayout.getXpos() + widthDiff * widthPercent);
            labelLayout.setYpos(labelLayout.getYpos() + heightDiff);
        }
        nodeLayout.setProperty(LayoutOptions.FIXED_SIZE, true);
        return new KVector(widthRatio, heightRatio);
    }

    public static int calcFlow(KPort port) {
        int flow = 0;
        for (KEdge edge : port.getEdges()) {
            KPort sourcePort = edge.getSourcePort();
            KPort targetPort = edge.getTargetPort();
            KNode otherNode = null;
            if (sourcePort == port) {
                otherNode = edge.getTarget();
            } else if (targetPort == port) {
                otherNode = edge.getSource();
            }
            if (otherNode == null) continue;
            if (KimlUtil.isDescendant(otherNode, port.getNode())) {
                if (sourcePort == port) {
                    --flow;
                }
                if (targetPort != port) continue;
                ++flow;
                continue;
            }
            if (sourcePort == port) {
                ++flow;
            }
            if (targetPort != port) continue;
            --flow;
        }
        return flow;
    }

    public static boolean isDescendant(KNode child, KNode parent) {
        KNode current = child;
        while (current.getParent() != null) {
            if ((current = current.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    public static void toAbsolute(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.translate(nodeLayout.getXpos() + insets.getLeft(), nodeLayout.getYpos() + insets.getTop());
            node = node.getParent();
        }
    }

    public static void toRelative(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.translate(-nodeLayout.getXpos() - insets.getLeft(), -nodeLayout.getYpos() - insets.getTop());
            node = node.getParent();
        }
    }

    public static void translate(KNode parent, float xoffset, float yoffset) {
        for (KNode node : parent.getChildren()) {
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            nodeLayout.setXpos(nodeLayout.getXpos() + xoffset);
            nodeLayout.setYpos(nodeLayout.getYpos() + yoffset);
            for (KEdge edge : node.getOutgoingEdges()) {
                KEdgeLayout edgeLayout = edge.getData(KEdgeLayout.class);
                KimlUtil.translate(edgeLayout.getSourcePoint(), xoffset, yoffset);
                for (KPoint bendPoint : edgeLayout.getBendPoints()) {
                    KimlUtil.translate(bendPoint, xoffset, yoffset);
                }
                KimlUtil.translate(edgeLayout.getTargetPoint(), xoffset, yoffset);
                for (KLabel edgeLabel : edge.getLabels()) {
                    KShapeLayout labelLayout = edgeLabel.getData(KShapeLayout.class);
                    labelLayout.setXpos(labelLayout.getXpos() + xoffset);
                    labelLayout.setYpos(labelLayout.getYpos() + yoffset);
                }
            }
        }
    }

    public static void translate(KPoint point, float xoffset, float yoffset) {
        point.setX(point.getX() + xoffset);
        point.setY(point.getY() + yoffset);
    }

    public static void excludeContent(KNode node) {
        for (KNode child : node.getChildren()) {
            child.getData(KShapeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
            KimlUtil.excludeLabels(child);
            KimlUtil.excludePorts(child);
            for (KEdge edge : child.getOutgoingEdges()) {
                edge.getData(KEdgeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
                KimlUtil.excludeLabels(edge);
            }
            KimlUtil.excludeContent(child);
        }
    }

    public static void excludeLabels(KLabeledGraphElement element) {
        for (KLabel label : element.getLabels()) {
            label.getData(KShapeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
        }
    }

    public static void excludePorts(KNode node) {
        for (KPort port : node.getPorts()) {
            port.getData(KShapeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
            for (KLabel label : port.getLabels()) {
                label.getData(KShapeLayout.class).setProperty(LayoutOptions.NO_LAYOUT, true);
            }
        }
    }

    public static void setOption(KGraphData graphData, String id, String value) {
        Object obj;
        LayoutDataService dataService = LayoutDataService.getInstance();
        LayoutOptionData<?> optionData = dataService.getOptionData(id);
        if (optionData != null && (obj = optionData.parseValue(value)) != null) {
            graphData.setProperty(optionData, obj);
        }
    }

    public static void persistDataElements(KNode graph) {
        TreeIterator<EObject> iterator = graph.eAllContents();
        EObject eObject = null;
        while (iterator.hasNext()) {
            eObject = (EObject)iterator.next();
            if (!(eObject instanceof KGraphData)) continue;
            ((KGraphData)eObject).makePersistent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PortComparator
    implements Comparator<KPort>,
    Serializable {
        private static final long serialVersionUID = 7489650936528433087L;
        private boolean forward;
        private Direction layoutDirection;

        public PortComparator(boolean theforward, Direction thelayoutDirection) {
            this.forward = theforward;
            this.layoutDirection = thelayoutDirection;
        }

        @Override
        public int compare(KPort port1, KPort port2) {
            PortSide side2;
            KShapeLayout layout1 = port1.getData(KShapeLayout.class);
            KShapeLayout layout2 = port2.getData(KShapeLayout.class);
            int rank1 = layout1.getProperty(LayoutOptions.PORT_RANK);
            int rank2 = layout2.getProperty(LayoutOptions.PORT_RANK);
            PortSide side1 = layout1.getProperty(LayoutOptions.PORT_SIDE);
            if (side1 == (side2 = layout2.getProperty(LayoutOptions.PORT_SIDE))) {
                return this.layoutDirection == Direction.DOWN && !this.forward || this.layoutDirection == Direction.RIGHT && this.forward ? rank1 - rank2 : rank2 - rank1;
            }
            if (this.layoutDirection == Direction.DOWN) {
                if (this.forward) {
                    return side1 == PortSide.NORTH || side1 == PortSide.EAST && (side2 == PortSide.SOUTH || side2 == PortSide.WEST) || side1 == PortSide.SOUTH && side2 == PortSide.WEST ? 1 : -1;
                }
                return side1 == PortSide.SOUTH || side1 == PortSide.EAST && (side2 == PortSide.NORTH || side2 == PortSide.WEST) || side1 == PortSide.NORTH && side2 == PortSide.WEST ? 1 : -1;
            }
            if (this.forward) {
                return side1 == PortSide.WEST || side1 == PortSide.SOUTH && (side2 == PortSide.EAST || side2 == PortSide.NORTH) || side1 == PortSide.EAST && side2 == PortSide.NORTH ? 1 : -1;
            }
            return side1 == PortSide.EAST || side1 == PortSide.SOUTH && (side2 == PortSide.WEST || side2 == PortSide.NORTH) || side1 == PortSide.WEST && side2 == PortSide.NORTH ? 1 : -1;
        }
    }
}

