/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;

public class FixedLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "de.cau.cs.kieler.fixed";
    private static final float DEF_BORDER_SPACING = 15.0f;

    public void doLayout(KNode layoutNode, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Fixed Layout", 1.0f);
        float maxx = 0.0f;
        float maxy = 0.0f;
        for (KNode node : layoutNode.getChildren()) {
            KVector maxv;
            KShapeLayout nodeLayout = node.getData(KShapeLayout.class);
            KVector pos = nodeLayout.getProperty(LayoutOptions.POSITION);
            if (pos == null) {
                if (node.getChildren().isEmpty()) {
                    nodeLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
                }
            } else {
                nodeLayout.applyVector(pos);
                if (!nodeLayout.getProperty(LayoutOptions.FIXED_SIZE).booleanValue()) {
                    float width = nodeLayout.getProperty(LayoutOptions.MIN_WIDTH).floatValue();
                    float height = nodeLayout.getProperty(LayoutOptions.MIN_HEIGHT).floatValue();
                    if (width > 0.0f && height > 0.0f) {
                        KimlUtil.resizeNode(node, width, height, true);
                    }
                }
            }
            for (KLabel label : node.getLabels()) {
                KShapeLayout labelLayout = label.getData(KShapeLayout.class);
                pos = labelLayout.getProperty(LayoutOptions.POSITION);
                if (pos == null) {
                    labelLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
                } else {
                    labelLayout.applyVector(pos);
                }
                maxx = KielerMath.maxf(maxx, nodeLayout.getXpos() + nodeLayout.getWidth(), nodeLayout.getXpos() + labelLayout.getXpos() + labelLayout.getWidth());
                maxy = KielerMath.maxf(maxy, nodeLayout.getYpos() + nodeLayout.getHeight(), nodeLayout.getYpos() + labelLayout.getYpos() + labelLayout.getHeight());
            }
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = port.getData(KShapeLayout.class);
                pos = portLayout.getProperty(LayoutOptions.POSITION);
                if (pos == null) {
                    portLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
                } else {
                    portLayout.setXpos((float)pos.x);
                    portLayout.setYpos((float)pos.y);
                }
                for (KLabel label : port.getLabels()) {
                    KShapeLayout labelLayout = label.getData(KShapeLayout.class);
                    pos = labelLayout.getProperty(LayoutOptions.POSITION);
                    if (pos == null) {
                        labelLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
                    } else {
                        labelLayout.setXpos((float)pos.x);
                        labelLayout.setYpos((float)pos.y);
                    }
                    float portx = nodeLayout.getXpos() + portLayout.getXpos();
                    float porty = nodeLayout.getYpos() + portLayout.getYpos();
                    maxx = KielerMath.maxf(maxx, portx + portLayout.getWidth(), portx + labelLayout.getXpos() + labelLayout.getWidth());
                    maxy = KielerMath.maxf(maxy, porty + portLayout.getHeight(), porty + labelLayout.getYpos() + labelLayout.getHeight());
                }
            }
            for (KEdge edge : node.getOutgoingEdges()) {
                maxv = this.processEdge(edge);
                maxx = Math.max(maxx, (float)maxv.x);
                maxy = Math.max(maxy, (float)maxv.y);
            }
            for (KEdge edge : node.getIncomingEdges()) {
                if (edge.getSource().getParent() == layoutNode) continue;
                maxv = this.processEdge(edge);
                maxx = Math.max(maxx, (float)maxv.x);
                maxy = Math.max(maxy, (float)maxv.y);
            }
        }
        KShapeLayout parentLayout = layoutNode.getData(KShapeLayout.class);
        float borderSpacing = parentLayout.getProperty(LayoutOptions.BORDER_SPACING).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = 15.0f;
        }
        KInsets insets = parentLayout.getInsets();
        float newWidth = maxx + borderSpacing + insets.getLeft() + insets.getRight();
        float newHeight = maxy + borderSpacing + insets.getTop() + insets.getBottom();
        KimlUtil.resizeNode(layoutNode, newWidth, newHeight, true);
        progressMonitor.done();
    }

    private KVector processEdge(KEdge edge) {
        KEdgeLayout edgeLayout = edge.getData(KEdgeLayout.class);
        boolean sameHierarchy = edge.getSource().getParent() == edge.getTarget().getParent();
        KVector maxv = new KVector();
        KVectorChain bendPoints = edgeLayout.getProperty(LayoutOptions.BEND_POINTS);
        if (bendPoints == null || bendPoints.size() < 2) {
            edgeLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
        } else {
            edgeLayout.applyVectorChain(bendPoints);
        }
        if (sameHierarchy) {
            for (KPoint point : edgeLayout.getBendPoints()) {
                maxv.x = Math.max(maxv.x, (double)point.getX());
                maxv.y = Math.max(maxv.y, (double)point.getY());
            }
        }
        for (KLabel label : edge.getLabels()) {
            KShapeLayout labelLayout = label.getData(KShapeLayout.class);
            KVector pos = labelLayout.getProperty(LayoutOptions.POSITION);
            if (pos == null) {
                labelLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
            } else {
                labelLayout.applyVector(pos);
            }
            if (!sameHierarchy) continue;
            maxv.x = Math.max(maxv.x, (double)(labelLayout.getXpos() + labelLayout.getWidth()));
            maxv.y = Math.max(maxv.y, (double)(labelLayout.getYpos() + labelLayout.getHeight()));
        }
        return maxv;
    }
}

