/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.alg.BoxPlacer;
import de.cau.cs.kieler.kiml.util.alg.BoxSorter;
import java.util.List;

public class BoxLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "de.cau.cs.kieler.box";
    private static final float DEFAULT_SPACING = 15.0f;
    private BoxSorter boxSorter = new BoxSorter();
    private BoxPlacer boxPlacer = new BoxPlacer();

    public void doLayout(KNode layoutNode, IKielerProgressMonitor progressMonitor) {
        float borderSpacing;
        progressMonitor.begin("Box layout", 2.0f);
        KShapeLayout parentLayout = layoutNode.getData(KShapeLayout.class);
        float objSpacing = parentLayout.getProperty(LayoutOptions.SPACING).floatValue();
        if (objSpacing < 0.0f) {
            objSpacing = 15.0f;
        }
        if ((borderSpacing = parentLayout.getProperty(LayoutOptions.BORDER_SPACING).floatValue()) < 0.0f) {
            borderSpacing = 15.0f;
        }
        boolean expandNodes = parentLayout.getProperty(LayoutOptions.EXPAND_NODES);
        boolean interactive = parentLayout.getProperty(LayoutOptions.INTERACTIVE);
        List<KNode> sortedBoxes = this.boxSorter.sort(layoutNode, interactive);
        this.boxPlacer.placeBoxes(sortedBoxes, layoutNode, objSpacing, borderSpacing, expandNodes);
        progressMonitor.done();
    }
}

