/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.kgraph.util.KGraphSwitch;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLayoutConfig
implements ILayoutConfig {
    public static final int PRIORITY = 0;
    public static final IProperty<Boolean> OPT_MAKE_OPTIONS = new Property<Boolean>("context.makeOptions", Boolean.valueOf(false));
    public static final IProperty<List<LayoutOptionData<?>>> OPTIONS = new Property("context.options");
    public static final IProperty<String> CONTENT_HINT = new Property<String>("context.contentHint");
    public static final IProperty<String> CONTENT_DIAGT = new Property<String>("context.contentDiagramType");
    public static final IProperty<LayoutAlgorithmData> CONTENT_ALGO = new Property<LayoutAlgorithmData>("context.contentAlgorithm");
    public static final IProperty<String> CONTAINER_HINT = new Property<String>("context.containerHint");
    public static final IProperty<String> CONTAINER_DIAGT = new Property<String>("context.containerDiagramType");
    public static final IProperty<LayoutAlgorithmData> CONTAINER_ALGO = new Property<LayoutAlgorithmData>("context.containerAlgorithm");
    public static final IProperty<Boolean> HAS_PORTS = new Property<Boolean>("context.hasPorts", Boolean.valueOf(false));
    private final KGraphSwitch<Set<LayoutOptionData.Target>> kgraphSwitch = new KGraphSwitch<Set<LayoutOptionData.Target>>(){

        @Override
        public Set<LayoutOptionData.Target> caseKNode(KNode node) {
            EnumSet<LayoutOptionData.Target> targets = EnumSet.noneOf(LayoutOptionData.Target.class);
            if (node.getParent() != null) {
                targets.add(LayoutOptionData.Target.NODES);
            }
            if (node.getChildren().size() != 0) {
                targets.add(LayoutOptionData.Target.PARENTS);
            }
            return targets;
        }

        @Override
        public Set<LayoutOptionData.Target> caseKEdge(KEdge edge) {
            return EnumSet.of(LayoutOptionData.Target.EDGES);
        }

        @Override
        public Set<LayoutOptionData.Target> caseKPort(KPort port) {
            return EnumSet.of(LayoutOptionData.Target.PORTS);
        }

        @Override
        public Set<LayoutOptionData.Target> caseKLabel(KLabel label) {
            return EnumSet.of(LayoutOptionData.Target.LABELS);
        }
    };

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void enrich(LayoutContext context) {
        KGraphElement graphElem = context.getProperty(LayoutContext.GRAPH_ELEM);
        if (context.getProperty(HAS_PORTS) == null && graphElem instanceof KNode) {
            context.setProperty(HAS_PORTS, !((KNode)graphElem).getPorts().isEmpty());
        }
        Set<LayoutOptionData.Target> optionTargets = context.getProperty(LayoutContext.OPT_TARGETS);
        KGraphElement graphElement = context.getProperty(LayoutContext.GRAPH_ELEM);
        if (optionTargets == null && graphElement != null) {
            optionTargets = (Set<LayoutOptionData.Target>)this.kgraphSwitch.doSwitch(graphElement);
            context.setProperty(LayoutContext.OPT_TARGETS, optionTargets);
        }
        if (context.getProperty(OPT_MAKE_OPTIONS).booleanValue()) {
            if (optionTargets == null) {
                optionTargets = Collections.emptySet();
            }
            LayoutDataService layoutDataService = LayoutDataService.getInstance();
            LinkedList optionData = new LinkedList();
            for (LayoutOptionData.Target target : optionTargets) {
                LayoutAlgorithmData algoData;
                switch (target) {
                    case PARENTS: {
                        algoData = DefaultLayoutConfig.getLayouterData(context.getProperty(CONTENT_HINT), context.getProperty(CONTENT_DIAGT));
                        context.setProperty(CONTENT_ALGO, algoData);
                        break;
                    }
                    default: {
                        algoData = DefaultLayoutConfig.getLayouterData(context.getProperty(CONTAINER_HINT), context.getProperty(CONTAINER_DIAGT));
                        context.setProperty(CONTAINER_ALGO, algoData);
                    }
                }
                optionData.addAll(layoutDataService.getOptionData(algoData, target));
            }
            context.setProperty(OPTIONS, optionData);
        }
    }

    @Override
    public Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        Object result = null;
        LayoutAlgorithmData contentAlgoData = context.getProperty(CONTENT_ALGO);
        if (contentAlgoData != null && optionData.hasTarget(LayoutOptionData.Target.PARENTS) && (result = contentAlgoData.getDefaultValue(optionData)) != null) {
            return result;
        }
        LayoutAlgorithmData containerAlgoData = context.getProperty(CONTAINER_ALGO);
        if (containerAlgoData != null && (result = containerAlgoData.getDefaultValue(optionData)) != null) {
            return result;
        }
        result = optionData.getDefault();
        if (result != null) {
            return result;
        }
        return optionData.getDefaultDefault();
    }

    public static LayoutAlgorithmData getLayouterData(String theLayoutHint, String diagramType) {
        String layoutHint;
        String chDiagType = diagramType == null ? "de.cau.cs.kieler.layout.diagrams.general" : diagramType;
        LayoutDataService layoutServices = LayoutDataService.getInstance();
        LayoutAlgorithmData directHitData = layoutServices.getAlgorithmData(layoutHint = theLayoutHint);
        if (directHitData != null) {
            return directHitData;
        }
        LayoutAlgorithmData bestProvider = null;
        int bestPrio = -536870912;
        boolean matchesLayoutType = false;
        boolean matchesDiagramType = false;
        boolean matchesGeneralDiagram = false;
        for (LayoutAlgorithmData providerData : layoutServices.getAlgorithmData()) {
            int currentPrio = providerData.getSupportedPriority(chDiagType);
            if (matchesLayoutType) {
                if (!providerData.getType().equals(layoutHint)) continue;
                if (matchesDiagramType) {
                    if (currentPrio <= bestPrio) continue;
                    bestProvider = providerData;
                    bestPrio = currentPrio;
                    continue;
                }
                if (currentPrio > -536870912) {
                    bestProvider = providerData;
                    bestPrio = currentPrio;
                    matchesDiagramType = true;
                    matchesGeneralDiagram = false;
                    continue;
                }
                currentPrio = providerData.getSupportedPriority("de.cau.cs.kieler.layout.diagrams.general");
                if (matchesGeneralDiagram) {
                    if (currentPrio <= bestPrio) continue;
                    bestProvider = providerData;
                    bestPrio = currentPrio;
                    continue;
                }
                if (currentPrio > -536870912) {
                    bestProvider = providerData;
                    bestPrio = currentPrio;
                    matchesGeneralDiagram = true;
                    continue;
                }
                if (bestProvider != null) continue;
                bestProvider = providerData;
                continue;
            }
            if (providerData.getType().equals(layoutHint)) {
                bestProvider = providerData;
                matchesLayoutType = true;
                if (currentPrio > -536870912) {
                    bestPrio = currentPrio;
                    matchesDiagramType = true;
                    matchesGeneralDiagram = false;
                    continue;
                }
                matchesDiagramType = false;
                currentPrio = providerData.getSupportedPriority("de.cau.cs.kieler.layout.diagrams.general");
                if (currentPrio > -536870912) {
                    bestPrio = currentPrio;
                    matchesGeneralDiagram = true;
                    continue;
                }
                matchesGeneralDiagram = false;
                continue;
            }
            if (matchesDiagramType) {
                if (currentPrio <= bestPrio) continue;
                bestProvider = providerData;
                bestPrio = currentPrio;
                continue;
            }
            if (currentPrio > -536870912) {
                bestProvider = providerData;
                bestPrio = currentPrio;
                matchesDiagramType = true;
                matchesGeneralDiagram = false;
                continue;
            }
            currentPrio = providerData.getSupportedPriority("de.cau.cs.kieler.layout.diagrams.general");
            if (matchesGeneralDiagram) {
                if (currentPrio <= bestPrio) continue;
                bestProvider = providerData;
                bestPrio = currentPrio;
                continue;
            }
            if (currentPrio > -536870912) {
                bestProvider = providerData;
                bestPrio = currentPrio;
                matchesGeneralDiagram = true;
                continue;
            }
            if (bestProvider != null) continue;
            bestProvider = providerData;
        }
        return bestProvider;
    }

    @Override
    public void transferValues(KGraphData graphData, LayoutContext context) {
    }
}

