/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundLayoutConfig
implements IMutableLayoutConfig {
    private LinkedList<ILayoutConfig> configs = new LinkedList();

    public void add(ILayoutConfig conf) {
        ListIterator<ILayoutConfig> configIter = this.configs.listIterator();
        int prio = conf.getPriority();
        while (configIter.hasNext()) {
            ILayoutConfig nextConf = (ILayoutConfig)configIter.next();
            if (nextConf.getPriority() > prio) continue;
            configIter.previous();
            break;
        }
        configIter.add(conf);
    }

    public void addAll(Collection<ILayoutConfig> confs) {
        for (ILayoutConfig conf : confs) {
            this.add(conf);
        }
    }

    public void remove(ILayoutConfig conf) {
        this.configs.remove(conf);
    }

    public void removeAll(Collection<ILayoutConfig> confs) {
        this.configs.removeAll(confs);
    }

    @Override
    public int getPriority() {
        if (this.configs.isEmpty()) {
            return 0;
        }
        return this.configs.getFirst().getPriority();
    }

    @Override
    public void enrich(LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            conf.enrich(context);
        }
    }

    @Override
    public Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            Object value = conf.getValue(optionData, context);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void transferValues(KGraphData graphData, LayoutContext context) {
        ListIterator<ILayoutConfig> configIter = this.configs.listIterator(this.configs.size());
        while (configIter.hasPrevious()) {
            ILayoutConfig conf = configIter.previous();
            conf.transferValues(graphData, context);
        }
    }

    @Override
    public void clearValues(LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            if (!(conf instanceof IMutableLayoutConfig)) continue;
            IMutableLayoutConfig mlc = (IMutableLayoutConfig)conf;
            mlc.clearValues(context);
        }
    }

    @Override
    public void setValue(LayoutOptionData<?> optionData, LayoutContext context, Object value) {
        for (ILayoutConfig conf : this.configs) {
            if (!(conf instanceof IMutableLayoutConfig)) continue;
            IMutableLayoutConfig mlc = (IMutableLayoutConfig)conf;
            mlc.setValue(optionData, context, value);
            return;
        }
    }

    @Override
    public boolean isSet(LayoutOptionData<?> optionData, LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            IMutableLayoutConfig mlc;
            if (!(conf instanceof IMutableLayoutConfig) || !(mlc = (IMutableLayoutConfig)conf).isSet(optionData, context)) continue;
            return true;
        }
        return false;
    }
}

