/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.core.alg.InstancePool;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.ILayoutData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutAlgorithmData
implements ILayoutData {
    public static final int MIN_PRIORITY = -536870912;
    public static final String DEFAULT_LAYOUTER_NAME = "<Unnamed Layouter>";
    private String id = "";
    private String name = "";
    private InstancePool<AbstractLayoutProvider> providerPool;
    private String type = "";
    private String category = "";
    private String description = "";
    private Object imageData;
    private Map<LayoutOptionData<?>, Object> knownOptions = Maps.newHashMap();
    private List<SupportedDiagram> supportedDiagrams = new LinkedList<SupportedDiagram>();

    public boolean equals(Object obj) {
        if (obj instanceof LayoutAlgorithmData) {
            return this.id.equals(((LayoutAlgorithmData)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        if (this.name != null && this.name.length() > 0) {
            String categoryName = LayoutDataService.getInstance().getCategoryName(this.category);
            if (categoryName == null) {
                return this.name;
            }
            return String.valueOf(this.name) + " (" + categoryName + ")";
        }
        return DEFAULT_LAYOUTER_NAME;
    }

    public void setOption(LayoutOptionData<?> optionData, Object defaultValue) {
        if (optionData != null) {
            this.knownOptions.put(optionData, defaultValue);
        }
    }

    public boolean knowsOption(LayoutOptionData<?> optionData) {
        return this.knownOptions.containsKey(optionData);
    }

    public Object getDefaultValue(LayoutOptionData<?> optionData) {
        return this.knownOptions.get(optionData);
    }

    public void setDiagramSupport(String diagramType, int priority) {
        if (priority > -536870912) {
            SupportedDiagram supportedDiagram0 = null;
            for (SupportedDiagram supportedDiagram1 : this.supportedDiagrams) {
                if (!diagramType.equals(supportedDiagram1.type)) continue;
                supportedDiagram0 = supportedDiagram1;
                break;
            }
            if (supportedDiagram0 == null) {
                supportedDiagram0 = new SupportedDiagram();
                supportedDiagram0.type = diagramType;
                this.supportedDiagrams.add(supportedDiagram0);
            }
            supportedDiagram0.priority = priority;
        } else {
            ListIterator<SupportedDiagram> suppdIter = this.supportedDiagrams.listIterator();
            while (suppdIter.hasNext()) {
                SupportedDiagram supportedDiagram = suppdIter.next();
                if (!diagramType.equals(supportedDiagram.type)) continue;
                suppdIter.remove();
                break;
            }
        }
    }

    public int getSupportedPriority(String diagramType) {
        if (diagramType != null) {
            for (SupportedDiagram supportedDiagram : this.supportedDiagrams) {
                if (!diagramType.equals(supportedDiagram.type)) continue;
                return supportedDiagram.priority;
            }
        }
        return -536870912;
    }

    @Override
    public void setId(String theid) {
        assert (theid != null);
        this.id = theid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String thename) {
        this.name = thename == null || thename.length() == 0 ? DEFAULT_LAYOUTER_NAME : thename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String thedescription) {
        this.description = thedescription == null ? "" : thedescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void createPool(IFactory<AbstractLayoutProvider> providerFactory) {
        this.providerPool = new InstancePool<AbstractLayoutProvider>(providerFactory);
    }

    public InstancePool<AbstractLayoutProvider> getProviderPool() {
        return this.providerPool;
    }

    public void setType(String thetype) {
        this.type = thetype;
    }

    public String getType() {
        return this.type;
    }

    public void setCategory(String thecategory) {
        this.category = thecategory == null ? "" : thecategory;
    }

    public String getCategory() {
        return this.category;
    }

    public Object getPreviewImage() {
        return this.imageData;
    }

    public void setPreviewImage(Object thepreviewImage) {
        this.imageData = thepreviewImage;
    }

    private static final class SupportedDiagram {
        private String type;
        private int priority = 0;

        private SupportedDiagram() {
        }
    }
}

