/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.util;

import java.io.IOException;
import java.io.InputStream;

public class NonBlockingInputStream
extends InputStream {
    private static final int UNAVAIL_WAIT = 5;
    private InputStream inputStream;

    public NonBlockingInputStream(InputStream theinputStream) {
        this.inputStream = theinputStream;
    }

    public int read() throws IOException {
        if (this.inputStream.available() > 0) {
            return this.inputStream.read();
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {}
        return this.inputStream.available() > 0 ? this.inputStream.read() : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.inputStream.available();
        if (avail > 0) {
            return this.inputStream.read(b, off, len <= avail ? len : avail);
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {}
        avail = this.inputStream.available();
        return avail > 0 ? this.inputStream.read(b, off, len <= avail ? len : avail) : -1;
    }

    public void close() {
    }

    public void forceClose() throws IOException {
        this.inputStream.close();
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public void reset() throws IOException {
        this.inputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }
}

