/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.util;

import de.cau.cs.kieler.core.util.ICondition;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredIterator<E>
implements ListIterator<E> {
    private ListIterator<E> wrappedIter;
    private ICondition<E> condition;
    private E next;
    private E previous;
    private int nextIndex;

    public FilteredIterator(ListIterator<E> thewrappedIter, ICondition<E> thecondition) {
        this.wrappedIter = thewrappedIter;
        this.condition = thecondition;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            Object elem = null;
            while (this.wrappedIter.hasNext()) {
                elem = this.wrappedIter.next();
                if (this.condition.evaluate(elem)) break;
                elem = null;
            }
            this.next = elem;
        }
        return this.next != null;
    }

    @Override
    public boolean hasPrevious() {
        if (this.previous == null) {
            Object elem = null;
            while (this.wrappedIter.hasPrevious()) {
                elem = this.wrappedIter.previous();
                if (this.condition.evaluate(elem)) break;
                elem = null;
            }
            this.previous = elem;
        }
        return this.previous != null;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            ++this.nextIndex;
            E newNext = this.next;
            this.next = null;
            return newNext;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        if (this.hasPrevious()) {
            --this.nextIndex;
            E newPrevious = this.previous;
            this.previous = null;
            return newPrevious;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void add(E e) {
        this.wrappedIter.add(e);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterable<E>
    implements java.lang.Iterable<E> {
        private List<E> wrappedList;
        private ICondition<E> condition;

        public Iterable(List<E> thewrappedList, ICondition<E> thecondition) {
            this.wrappedList = thewrappedList;
            this.condition = thecondition;
        }

        @Override
        public Iterator<E> iterator() {
            return new FilteredIterator<E>(this.wrappedList.listIterator(), this.condition);
        }
    }
}

