/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.util;

import de.cau.cs.kieler.core.util.Dependency;
import de.cau.cs.kieler.core.util.IDependencyGraph;
import de.cau.cs.kieler.core.util.IDepending;
import de.cau.cs.kieler.core.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraph<S extends Comparable<S>, T extends IDepending<S>>
implements IDependencyGraph<S, T> {
    private static final int MARKER_REMOVED = 0;
    private static final int MARKER_NOT_VISITED_AND_KNOWN = 1;
    private static final int MARKER_NOT_VISITED = 2;
    private static final int MARKER_VISITED = 3;
    private Map<S, Node> nodes = new HashMap<S, Node>();

    @Override
    public boolean add(T object) {
        Node node = new Node(this, object);
        this.nodes.put(object.getId(), node);
        if (!node.initDependencies()) {
            this.nodes.remove(object.getId());
            return false;
        }
        return true;
    }

    @Override
    public List<T> remove(T object) {
        if (this.nodes.containsKey(object.getId())) {
            List<Node> removedNodes = this.removeNodeAndDependencies(this.nodes.get(object.getId()));
            LinkedList removedObjects = new LinkedList();
            for (Node node : removedNodes) {
                removedObjects.add(node.getObject());
            }
            return removedObjects;
        }
        return new LinkedList();
    }

    @Override
    public List<T> addAll(Collection<T> objects) {
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        LinkedList<T> invalidObjects = new LinkedList<T>();
        for (IDepending object : objects) {
            Node node = new Node(this, object);
            this.nodes.put(object.getId(), node);
            nodeQueue.add(node);
        }
        LinkedList<Node> invalidNodes = new LinkedList<Node>();
        while (!nodeQueue.isEmpty()) {
            Node node = (Node)nodeQueue.remove();
            if (node.initDependencies()) continue;
            invalidNodes.add(node);
        }
        for (Node invalidNode : invalidNodes) {
            List<Node> removedNodes = this.removeNodeAndDependencies(invalidNode);
            for (Node node : removedNodes) {
                invalidObjects.add(node.getObject());
            }
        }
        invalidObjects.addAll(this.removeCycles());
        return invalidObjects;
    }

    @Override
    public T get(S id) {
        if (this.nodes.containsKey(id)) {
            return this.nodes.get(id).getObject();
        }
        return null;
    }

    @Override
    public List<T> dependencySort(List<T> objects) {
        LinkedList sorted = new LinkedList();
        for (Node node : this.nodes.values()) {
            node.setMarker(2);
        }
        Stack<Node> stack = new Stack<Node>();
        for (IDepending object : objects) {
            Node node = this.nodes.get(object.getId());
            if (node == null) continue;
            node.setMarker(1);
            stack.add(node);
        }
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            if (node.getMarker() < 3) {
                node.setMarker(3);
                stack.add(node);
                for (Node dependency : node.getStrongDependencies()) {
                    stack.add(dependency);
                }
                for (Node dependency : node.getWeakDependencies()) {
                    if (dependency.getMarker() != 1) continue;
                    stack.add(dependency);
                }
                continue;
            }
            if (node.getMarker() == 4) continue;
            node.setMarker(4);
            sorted.addLast(node.getObject());
        }
        return sorted;
    }

    @Override
    public <R> R deriveObject(T object, IDependencyGraph.DerivationDetail<T, R> derivationDetail) {
        Node node = this.nodes.get(object.getId());
        if (node == null) {
            return null;
        }
        R derivative = derivationDetail.derive(node.getObject());
        if (derivative == null) {
            return null;
        }
        LinkedList<Pair<Node, R>> nodeQueue = new LinkedList<Pair<Node, R>>();
        nodeQueue.add(new Pair<Node, R>(node, derivative));
        while (!nodeQueue.isEmpty()) {
            Pair currentPair = (Pair)nodeQueue.poll();
            Object currentDerivative = currentPair.getSecond();
            for (Node dependency : ((Node)currentPair.getFirst()).getStrongDependencies()) {
                R dependencyDerivative = derivationDetail.derive(dependency.getObject());
                if (dependencyDerivative == null) {
                    return null;
                }
                derivationDetail.makeDependent(currentDerivative, dependencyDerivative, dependency.getObject());
                nodeQueue.add(new Pair<Node, R>(dependency, dependencyDerivative));
            }
        }
        return derivative;
    }

    private List<T> removeCycles() {
        LinkedList removedObjects = new LinkedList();
        for (Node node : this.nodes.values()) {
            node.setMarker(2);
        }
        int i = 0;
        LinkedList<Node> allNodes = new LinkedList<Node>(this.nodes.values());
        while (!allNodes.isEmpty()) {
            Node node = (Node)allNodes.remove();
            Stack<Node> stack = new Stack<Node>();
            node.setMarker(3 + i);
            stack.addAll(node.getStrongDependants());
            while (!stack.isEmpty()) {
                Node currentNode = (Node)stack.pop();
                if (currentNode.getMarker() != 3 + i) {
                    currentNode.setMarker(3 + i);
                    stack.addAll(currentNode.getStrongDependants());
                    continue;
                }
                if (node != currentNode) continue;
                List<Node> removedNodes = this.removeNodeAndDependencies(currentNode);
                stack.removeAll(removedNodes);
                allNodes.removeAll(removedNodes);
                for (Node removedNode : removedNodes) {
                    removedObjects.add(removedNode.getObject());
                }
            }
            ++i;
        }
        return removedObjects;
    }

    private List<Node> removeNodeAndDependencies(Node node) {
        LinkedList<Node> removedNodes = new LinkedList<Node>();
        LinkedList<Node> nodesToRemove = new LinkedList<Node>();
        node.setMarker(0);
        nodesToRemove.add(node);
        while (!nodesToRemove.isEmpty()) {
            Node removeNode = (Node)nodesToRemove.remove();
            removedNodes.add(removeNode);
            for (Node dependantNode : removeNode.getStrongDependants()) {
                if (dependantNode.getMarker() == 0) continue;
                dependantNode.getStrongDependencies().remove(removeNode);
                dependantNode.setMarker(0);
                nodesToRemove.add(dependantNode);
            }
            for (Node dependencyNode : removeNode.getWeakDependencies()) {
                dependencyNode.getWeakDependants().remove(removeNode);
            }
            for (Node dependencyNode : removeNode.getStrongDependencies()) {
                dependencyNode.getStrongDependants().remove(removeNode);
            }
            this.nodes.remove(removeNode.getObject().getId());
        }
        return removedNodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private List<Node> weakDependants = new LinkedList<Node>();
        private List<Node> strongDependants = new LinkedList<Node>();
        private List<Node> weakDependencies = new LinkedList<Node>();
        private List<Node> strongDependencies = new LinkedList<Node>();
        private T object;
        private int marker = 0;
        final /* synthetic */ DependencyGraph this$0;

        public Node(T obj) {
            this.this$0 = var1_1;
            this.object = obj;
        }

        public boolean initDependencies() {
            if (this.object.getDependencies() != null) {
                for (Dependency dependency : this.object.getDependencies()) {
                    Node depNode = (Node)this.this$0.nodes.get(dependency.getID());
                    if (depNode != null) {
                        if (dependency.isWeak()) {
                            this.weakDependencies.add(depNode);
                            continue;
                        }
                        this.strongDependencies.add(depNode);
                        continue;
                    }
                    return false;
                }
                for (Node node : this.weakDependencies) {
                    node.getWeakDependants().add(this);
                }
                for (Node node : this.strongDependencies) {
                    node.getStrongDependants().add(this);
                }
            }
            return true;
        }

        public List<Node> getWeakDependants() {
            return this.weakDependants;
        }

        public List<Node> getStrongDependants() {
            return this.strongDependants;
        }

        public List<Node> getWeakDependencies() {
            return this.weakDependencies;
        }

        public List<Node> getStrongDependencies() {
            return this.strongDependencies;
        }

        public T getObject() {
            return this.object;
        }

        public int getMarker() {
            return this.marker;
        }

        public void setMarker(int newMarker) {
            this.marker = newMarker;
        }
    }
}

