/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.properties;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyHolder
implements IPropertyHolder {
    private Map<IProperty<?>, Object> propertyMap = null;

    @Override
    public void setProperty(IProperty<?> property, Object value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        if (value == null) {
            this.propertyMap.remove(property);
        } else {
            this.propertyMap.put(property, value);
        }
    }

    @Override
    public <T> T getProperty(IProperty<T> property) {
        Object value;
        if (this.propertyMap != null && (value = this.propertyMap.get(property)) != null) {
            return (T)value;
        }
        return property.getDefault();
    }

    public <T> T getProperty(Class<T> clazz) {
        if (this.propertyMap != null) {
            for (Object value : this.propertyMap.values()) {
                if (!clazz.isInstance(value)) continue;
                return clazz.cast(value);
            }
        }
        return null;
    }

    @Override
    public void copyProperties(IPropertyHolder other) {
        Map<IProperty<?>, Object> otherMap = other.getAllProperties();
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap(otherMap);
        } else {
            this.propertyMap.putAll(otherMap);
        }
    }

    @Override
    public Map<IProperty<?>, Object> getAllProperties() {
        if (this.propertyMap == null) {
            return Collections.emptyMap();
        }
        return this.propertyMap;
    }

    public void checkProperties(IProperty<?> ... newProperties) {
        IProperty<?>[] iPropertyArray = newProperties;
        int n = newProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty<?> property = iPropertyArray[n2];
            Object value = this.propertyMap.get(property);
            if (value != null) {
                Comparable<?> lowbo = property.getLowerBound();
                Comparable<?> uppbo = property.getUpperBound();
                if (lowbo.compareTo(value) > 0 || uppbo.compareTo(value) < 0) {
                    this.propertyMap.remove(property);
                }
            }
            ++n2;
        }
    }
}

