/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.math;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KielerMath {
    private static final long[] FACT_TABLE = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L};
    private static final int W_DEGREE = 5;
    private static final int DEGREE = 3;
    private static final double[][] CUBIC_Z = new double[][]{{1.0, 0.6, 0.3, 0.1}, {0.4, 0.6, 0.6, 0.4}, {0.1, 0.3, 0.6, 1.0}};
    private static final int MAXDEPTH = 64;
    private static final double EPSILON = 1.0 * Math.pow(2.0, -65.0);

    private KielerMath() {
    }

    public static long factl(int x) {
        long result = 1L;
        int i = x;
        while (i > 1) {
            if (i < FACT_TABLE.length) {
                return result * FACT_TABLE[i];
            }
            result *= (long)i;
            --i;
        }
        return result;
    }

    public static double factd(int x) {
        if (x < 0) {
            return 1.0;
        }
        if (x < FACT_TABLE.length) {
            return FACT_TABLE[x];
        }
        return Math.sqrt(Math.PI * 2 * (double)x) * ((double)KielerMath.pow(x, x) / KielerMath.pow(Math.E, x));
    }

    public static long binomiall(int n, int k) {
        if (n <= 0 || k <= 0 || k >= n) {
            return 1L;
        }
        if (n < FACT_TABLE.length) {
            return KielerMath.factl(n) / (KielerMath.factl(k) * KielerMath.factl(n - k));
        }
        return KielerMath.binomiall(n - 1, k - 1) + KielerMath.binomiall(n - 1, k);
    }

    public static double binomiald(int n, int k) {
        if (n <= 0 || k <= 0 || k >= n) {
            return 1.0;
        }
        return KielerMath.factd(n) / (KielerMath.factd(k) * KielerMath.factd(n - k));
    }

    public static double pow(double a, int b) {
        double result = 1.0;
        double base = a;
        int exp = b >= 0 ? b : -b;
        while (exp > 0) {
            if (exp % 2 == 0) {
                base *= base;
                exp /= 2;
                continue;
            }
            result *= base;
            --exp;
        }
        if (b < 0) {
            return 1.0 / result;
        }
        return result;
    }

    public static float pow(float a, int b) {
        float result = 1.0f;
        float base = a;
        int exp = b >= 0 ? b : -b;
        while (exp > 0) {
            if (exp % 2 == 0) {
                base *= base;
                exp /= 2;
                continue;
            }
            result *= base;
            --exp;
        }
        if (b < 0) {
            return 1.0f / result;
        }
        return result;
    }

    public static KVector[] calcBezierPoints(List<KVector> controlPoints, int resultSize) {
        if (resultSize <= 0) {
            return new KVector[0];
        }
        KVector[] result = new KVector[resultSize];
        int n = controlPoints.size() - 1;
        double dt = 1.0 / (double)resultSize;
        double t = 0.0;
        int i = 0;
        while (i < resultSize) {
            t += dt;
            double x = 0.0;
            double y = 0.0;
            int j = 0;
            while (j <= n) {
                KVector p = controlPoints.get(j);
                double factor = KielerMath.binomiald(n, j) * KielerMath.pow(1.0 - t, n - j) * KielerMath.pow(t, j);
                x += p.x * factor;
                y += p.y * factor;
                ++j;
            }
            result[i] = new KVector(x, y);
            ++i;
        }
        return result;
    }

    public static KVector[] calcBezierPoints(int resultSize, KVector ... controlPoints) {
        if (resultSize <= 0) {
            return new KVector[0];
        }
        KVector[] result = new KVector[resultSize];
        int n = controlPoints.length - 1;
        double dt = 1.0 / (double)resultSize;
        double t = 0.0;
        int i = 0;
        while (i < resultSize) {
            t += dt;
            double x = 0.0;
            double y = 0.0;
            int j = 0;
            while (j <= n) {
                KVector p = controlPoints[j];
                double factor = KielerMath.binomiald(n, j) * KielerMath.pow(1.0 - t, n - j) * KielerMath.pow(t, j);
                x += p.x * factor;
                y += p.y * factor;
                ++j;
            }
            result[i] = new KVector(x, y);
            ++i;
        }
        return result;
    }

    public static KVector[] calcBezierPoints(KVector ... controlPoints) {
        return KielerMath.calcBezierPoints(KielerMath.getApproximationCount(controlPoints), controlPoints);
    }

    public static int getApproximationCount(KVector ... controlPoints) {
        return controlPoints.length;
    }

    public static KVectorChain appoximateSpline(KVectorChain controlPoints) {
        int ctrlPtCount = controlPoints.size();
        KVectorChain spline = new KVectorChain();
        ListIterator controlIter = controlPoints.listIterator();
        KVector currentPoint = (KVector)controlIter.next();
        spline.add(currentPoint);
        while (controlIter.hasNext()) {
            int remainingPoints = ctrlPtCount - controlIter.nextIndex();
            if (remainingPoints == 1) {
                spline.add((KVector)controlIter.next());
                continue;
            }
            if (remainingPoints == 2) {
                spline.addAll(KielerMath.calcBezierPoints(currentPoint, (KVector)controlIter.next(), (KVector)controlIter.next()));
                continue;
            }
            KVector control1 = (KVector)controlIter.next();
            KVector control2 = (KVector)controlIter.next();
            KVector nextPoint = (KVector)controlIter.next();
            spline.addAll(KielerMath.calcBezierPoints(currentPoint, control1, control2, nextPoint));
            currentPoint = nextPoint;
        }
        return spline;
    }

    public static double distanceFromSpline(KVector start, KVector c1, KVector c2, KVector end, KVector needle) {
        double[] tCandidate = new double[5];
        KVector[] v = new KVector[]{start, c1, c2, end};
        KVector[] w = KielerMath.convertToBezierForm(v, needle);
        int nSolutions = KielerMath.findRoots(w, 5, tCandidate, 0);
        double minDistance = needle.distance(start);
        double t = 0.0;
        int i = 0;
        while (i < nSolutions) {
            KVector p = KielerMath.bezier(v, 3, tCandidate[i], null, null);
            double distance = needle.distance(p);
            if (distance < minDistance) {
                minDistance = distance;
                t = tCandidate[i];
            }
            ++i;
        }
        double distance = needle.distance(end);
        if (distance < minDistance) {
            minDistance = distance;
            t = 1.0;
        }
        KVector pn = new KVector(KielerMath.bezier(v, 3, t, null, null));
        return Math.sqrt(pn.distance(needle));
    }

    private static KVector[] convertToBezierForm(KVector[] v, KVector pa) {
        KVector[] c = new KVector[4];
        KVector[] d = new KVector[3];
        double[][] cdTable = new double[3][4];
        KVector[] w = new KVector[6];
        int i = 0;
        while (i <= 3) {
            c[i] = new KVector(v[i].x - pa.x, v[i].y - pa.y);
            ++i;
        }
        double s = 3.0;
        int i2 = 0;
        while (i2 <= 2) {
            d[i2] = new KVector(s * (v[i2 + 1].x - v[i2].x), s * (v[i2 + 1].y - v[i2].y));
            ++i2;
        }
        int row = 0;
        while (row <= 2) {
            int column = 0;
            while (column <= 3) {
                cdTable[row][column] = d[row].x * c[column].x + d[row].y * c[column].y;
                ++column;
            }
            ++row;
        }
        i2 = 0;
        while (i2 <= 5) {
            w[i2] = new KVector((double)i2 / 5.0, 0.0);
            ++i2;
        }
        int n = 3;
        int m = 2;
        int k = 0;
        while (k <= n + m) {
            int lb = Math.max(0, k - m);
            int ub = Math.min(k, n);
            int i3 = lb;
            while (i3 <= ub) {
                int j = k - i3;
                w[i3 + j].y += cdTable[j][i3] * CUBIC_Z[j][i3];
                ++i3;
            }
            ++k;
        }
        return w;
    }

    private static int findRoots(KVector[] w, int degree, double[] t, int depth) {
        switch (KielerMath.crossingCount(w, degree)) {
            case 0: {
                return 0;
            }
            case 1: {
                if (depth >= 64) {
                    t[0] = (w[0].x + w[5].x) / 2.0;
                    return 1;
                }
                if (!KielerMath.controlPolygonFlatEnough(w, degree)) break;
                t[0] = KielerMath.computeXIntercept(w, degree);
                return 1;
            }
        }
        KVector[] left = new KVector[6];
        KVector[] right = new KVector[6];
        double[] leftT = new double[6];
        double[] rightT = new double[6];
        KielerMath.bezier(w, degree, 0.5, left, right);
        int leftCount = KielerMath.findRoots(left, degree, leftT, depth + 1);
        int rightCount = KielerMath.findRoots(right, degree, rightT, depth + 1);
        int i = 0;
        while (i < leftCount) {
            t[i] = leftT[i];
            ++i;
        }
        i = 0;
        while (i < rightCount) {
            t[i + leftCount] = rightT[i];
            ++i;
        }
        return leftCount + rightCount;
    }

    private static boolean controlPolygonFlatEnough(KVector[] v, int degree) {
        double a = v[0].y - v[degree].y;
        double b = v[degree].x - v[0].x;
        double c = v[0].x * v[degree].y - v[degree].x * v[0].y;
        double abSquared = a * a + b * b;
        double[] distance = new double[degree + 1];
        int i = 1;
        while (i < degree) {
            distance[i] = a * v[i].x + b * v[i].y + c;
            if (distance[i] > 0.0) {
                distance[i] = distance[i] * distance[i] / abSquared;
            }
            if (distance[i] < 0.0) {
                distance[i] = -(distance[i] * distance[i] / abSquared);
            }
            ++i;
        }
        double maxDistanceAbove = 0.0;
        double maxDistanceBelow = 0.0;
        int i2 = 1;
        while (i2 < degree) {
            if (distance[i2] < 0.0) {
                maxDistanceBelow = Math.min(maxDistanceBelow, distance[i2]);
            }
            if (distance[i2] > 0.0) {
                maxDistanceAbove = Math.max(maxDistanceAbove, distance[i2]);
            }
            ++i2;
        }
        double a1 = 0.0;
        double b1 = 1.0;
        double c1 = 0.0;
        double a2 = a;
        double b2 = b;
        double c2 = c + maxDistanceAbove;
        double det = a1 * b2 - a2 * b1;
        double dInv = 1.0 / det;
        double intercept1 = (b1 * c2 - b2 * c1) * dInv;
        a2 = a;
        b2 = b;
        c2 = c + maxDistanceBelow;
        det = a1 * b2 - a2 * b1;
        dInv = 1.0 / det;
        double intercept2 = (b1 * c2 - b2 * c1) * dInv;
        double leftIntercept = Math.min(intercept1, intercept2);
        double rightIntercept = Math.max(intercept1, intercept2);
        double error = (rightIntercept - leftIntercept) / 2.0;
        return error < EPSILON;
    }

    private static double computeXIntercept(KVector[] v, int degree) {
        double xnm = v[degree].x - v[0].x;
        double ynm = v[degree].y - v[0].y;
        double xmk = v[0].x;
        double ymk = v[0].y;
        double detInv = -1.0 / ynm;
        return (xnm * ymk - ynm * xmk) * detInv;
    }

    private static int crossingCount(KVector[] v, int degree) {
        int sign;
        int nCrossings = 0;
        int oldSign = sign = v[0].y < 0.0 ? -1 : 1;
        int i = 1;
        while (i <= degree) {
            int n = sign = v[i].y < 0.0 ? -1 : 1;
            if (sign != oldSign) {
                ++nCrossings;
            }
            oldSign = sign;
            ++i;
        }
        return nCrossings;
    }

    private static KVector bezier(KVector[] c, int degree, double t, KVector[] left, KVector[] right) {
        KVector[][] p = new KVector[6][6];
        int j = 0;
        while (j <= degree) {
            p[0][j] = new KVector(c[j]);
            ++j;
        }
        int i = 1;
        while (i <= degree) {
            int j2 = 0;
            while (j2 <= degree - i) {
                p[i][j2] = new KVector((1.0 - t) * p[i - 1][j2].x + t * p[i - 1][j2 + 1].x, (1.0 - t) * p[i - 1][j2].y + t * p[i - 1][j2 + 1].y);
                ++j2;
            }
            ++i;
        }
        if (left != null) {
            j = 0;
            while (j <= degree) {
                left[j] = p[j][0];
                ++j;
            }
        }
        if (right != null) {
            j = 0;
            while (j <= degree) {
                right[j] = p[degree - j][j];
                ++j;
            }
        }
        return p[degree][0];
    }

    public static int maxi(int ... values) {
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static int mini(int ... values) {
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static int averagei(int ... values) {
        int avg = 0;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / values.length;
    }

    public static long maxl(long ... values) {
        long max = Integer.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static long minl(long ... values) {
        long min = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static long averagei(long ... values) {
        long avg = 0L;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / (long)values.length;
    }

    public static float maxf(float ... values) {
        float max = -3.4028235E38f;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static float minf(float ... values) {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static float averagef(float ... values) {
        float avg = 0.0f;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / (float)values.length;
    }

    public static double maxd(double ... values) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static double mind(double ... values) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static double averaged(double ... values) {
        double avg = 0.0;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / (double)values.length;
    }
}

