/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.math;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.util.IDataObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KVectorChain
extends LinkedList<KVector>
implements IDataObject {
    private static final long serialVersionUID = -7978287459602078559L;

    public KVectorChain() {
    }

    public KVectorChain(Collection<KVector> collection) {
        super(collection);
    }

    public KVectorChain(KVector[] vectors) {
        this.addAll(vectors);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            KVector vector = (KVector)iter.next();
            builder.append(String.valueOf(vector.x) + "," + vector.y);
            if (!iter.hasNext()) continue;
            builder.append("; ");
        }
        return builder.append(")").toString();
    }

    @Override
    public void parse(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",;()[]{} \t\n");
        this.clear();
        try {
            while (tokenizer.countTokens() >= 2) {
                double x = Double.parseDouble(tokenizer.nextToken());
                double y = Double.parseDouble(tokenizer.nextToken());
                this.add(new KVector(x, y));
            }
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("The given string does not match the expected format for vectors." + exception);
        }
    }

    public void add() {
        this.add(new KVector());
    }

    public void add(double x, double y) {
        this.add(new KVector(x, y));
    }

    public void addFirst() {
        this.addFirst(new KVector());
    }

    public void addFirst(double x, double y) {
        this.addFirst(new KVector(x, y));
    }

    public void addLast() {
        this.addLast(new KVector());
    }

    public void addLast(double x, double y) {
        this.addLast(new KVector(x, y));
    }

    public void addAll(KVector[] vectors) {
        KVector[] kVectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            KVector vector = kVectorArray[n2];
            this.add(vector);
            ++n2;
        }
    }

    public void translate(KVector offset) {
        for (KVector vector : this) {
            vector.add(offset);
        }
    }

    public void translate(double dx, double dy) {
        for (KVector vector : this) {
            vector.translate(dx, dy);
        }
    }

    public double getLength() {
        double length = 0.0;
        if (this.size() >= 2) {
            Iterator iter = this.iterator();
            KVector point1 = (KVector)iter.next();
            do {
                KVector point2 = (KVector)iter.next();
                length += KVector.distance(point1, point2);
                point1 = point2;
            } while (iter.hasNext());
        }
        return length;
    }

    public KVector getPointOnLine(double dist) {
        if (this.size() >= 2) {
            double absDistance = Math.abs(dist);
            double distanceSum = 0.0;
            if (dist >= 0.0) {
                ListIterator iter = this.listIterator();
                KVector currentPoint = (KVector)iter.next();
                while (iter.hasNext()) {
                    double oldDistanceSum = distanceSum;
                    KVector nextPoint = (KVector)iter.next();
                    double additionalDistanceToNext = KVector.distance(currentPoint, nextPoint);
                    if (additionalDistanceToNext > 0.0 && (distanceSum += additionalDistanceToNext) >= absDistance) {
                        double thisRelative = (absDistance - oldDistanceSum) / additionalDistanceToNext;
                        KVector result = nextPoint.differenceCreate(currentPoint);
                        result.scale(thisRelative);
                        result.add(currentPoint);
                        return result;
                    }
                    currentPoint = nextPoint;
                }
                return (KVector)iter.previous();
            }
            ListIterator iter = this.listIterator(this.size() - 1);
            KVector currentPoint = (KVector)iter.previous();
            while (iter.hasPrevious()) {
                double oldDistanceSum = distanceSum;
                KVector nextPoint = (KVector)iter.previous();
                double additionalDistanceToNext = KVector.distance(currentPoint, nextPoint);
                if (additionalDistanceToNext > 0.0 && (distanceSum += additionalDistanceToNext) >= absDistance) {
                    double thisRelative = (absDistance - oldDistanceSum) / additionalDistanceToNext;
                    KVector result = nextPoint.differenceCreate(currentPoint);
                    result.scale(thisRelative);
                    result.add(currentPoint);
                    return result;
                }
                currentPoint = nextPoint;
            }
            return (KVector)iter.next();
        }
        if (this.size() == 1) {
            return (KVector)this.get(0);
        }
        throw new IllegalStateException("Cannot determine a point on an empty vector chain.");
    }

    public static KVectorChain reverse(KVectorChain chain) {
        KVectorChain result = new KVectorChain();
        for (KVector vector : chain) {
            result.add(0, new KVector(vector));
        }
        return result;
    }
}

