/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.math;

import de.cau.cs.kieler.core.util.IDataObject;
import java.util.Random;
import java.util.StringTokenizer;

public class KVector
implements IDataObject,
Cloneable {
    private static final long serialVersionUID = -4780985519832787684L;
    public double x;
    public double y;
    public static final double FULL_CIRCLE = 360.0;

    public KVector() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public KVector(double thex, double they) {
        this.x = thex;
        this.y = they;
    }

    public KVector(KVector v) {
        this.x = v.x;
        this.y = v.y;
    }

    public KVector(double alpha) {
        if (alpha < 0.0 || alpha >= 360.0) {
            throw new IllegalArgumentException("Value for angle has to be within [0, 360)! Given Value: " + alpha);
        }
        double rad = Math.toRadians(alpha);
        this.x = Math.sin(rad);
        this.y = Math.cos(rad);
    }

    public KVector clone() {
        return new KVector(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof KVector) {
            KVector other = (KVector)obj;
            return this.x == other.x && this.y == other.y;
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.x).hashCode() + Integer.reverse(Double.valueOf(this.y).hashCode());
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getSquareLength() {
        return this.x * this.x + this.y * this.y;
    }

    public final KVector reset() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public final KVector add(KVector v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public static KVector add(KVector v1, KVector v2) {
        return new KVector(v1.x + v2.x, v1.y + v2.y);
    }

    public final KVector sub(KVector v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public static KVector sub(KVector v1, KVector v2) {
        return new KVector(v1.x - v2.x, v1.y - v2.y);
    }

    public final KVector scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        return this;
    }

    public final KVector scale(double scalex, double scaley) {
        this.x *= scalex;
        this.y *= scaley;
        return this;
    }

    public final KVector translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public KVector normalize() {
        double length = this.getLength();
        if (length > 0.0) {
            this.x /= length;
            this.y /= length;
        }
        return this;
    }

    public KVector scaleToLength(double length) {
        this.normalize();
        this.scale(length);
        return this;
    }

    public KVector negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public double toDegrees() {
        KVector temp = this.clone();
        temp.normalize();
        double sin = Math.toDegrees(Math.asin(temp.x));
        double cos = Math.toDegrees(Math.acos(temp.y));
        if (this.y < 0.0 && this.x < 0.0) {
            return 180.0 - sin;
        }
        if (this.y < 0.0) {
            return cos;
        }
        if (this.x < 0.0) {
            return 360.0 + sin;
        }
        return cos;
    }

    public final void wiggle(Random random, double amount) {
        this.x += random.nextDouble() * amount - amount / 2.0;
        this.y += random.nextDouble() * amount - amount / 2.0;
    }

    public final KVector scaledCreate(double lambda) {
        return new KVector(this).scale(lambda);
    }

    public final KVector normalizedCreate() {
        return new KVector(this).normalize();
    }

    public final KVector sumCreate(KVector v) {
        return new KVector(this).add(v);
    }

    public final KVector differenceCreate(KVector v) {
        return new KVector(this).sub(v);
    }

    public double distance(KVector v2) {
        double dx = this.x - v2.x;
        double dy = this.y - v2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distance(KVector v1, KVector v2) {
        double dx = v1.x - v2.x;
        double dy = v1.y - v2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double productDot(KVector v2) {
        return this.x * v2.x + this.y * v2.y;
    }

    public static double productDot(KVector v1, KVector v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public KVector applyBounds(double lowx, double lowy, double highx, double highy) {
        if (this.x < lowx) {
            this.x = lowx;
        } else if (this.x > highx) {
            this.x = highx;
        }
        if (this.y < lowy) {
            this.y = lowy;
        } else if (this.y > highy) {
            this.y = highy;
        }
        return this;
    }

    public void parse(String string) {
        int start = 0;
        while (start < string.length() && KVector.isdelim(string.charAt(start), "([{\"' \t\r\n")) {
            ++start;
        }
        int end = string.length();
        while (end > 0 && KVector.isdelim(string.charAt(end - 1), ")]}\"' \t\r\n")) {
            --end;
        }
        if (start >= end) {
            throw new IllegalArgumentException("The given string does not contain any numbers.");
        }
        StringTokenizer tokenizer = new StringTokenizer(string.substring(start, end), ",; \t\r\n");
        if (tokenizer.countTokens() != 2) {
            throw new IllegalArgumentException("Exactly two numbers are expected, " + tokenizer.countTokens() + " were found.");
        }
        try {
            this.x = Double.parseDouble(tokenizer.nextToken());
            this.y = Double.parseDouble(tokenizer.nextToken());
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("The given string contains parts that cannot be parsed as numbers." + exception);
        }
    }

    private static boolean isdelim(char c, String delims) {
        int i = 0;
        while (i < delims.length()) {
            if (c == delims.charAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

