/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.alg;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicProgressMonitor
implements IKielerProgressMonitor {
    private BasicProgressMonitor parentMonitor = null;
    private boolean closed = false;
    private List<IKielerProgressMonitor> children = new LinkedList<IKielerProgressMonitor>();
    private float currentChildWork = -1.0f;
    private long startTime;
    private double totalTime;
    private String taskName;
    private float completedWork = 0.0f;
    private float totalWork;
    private int maxLevels;
    private static final double NANO_FACT = 1.0E-9;

    public BasicProgressMonitor() {
        this.maxLevels = -1;
    }

    public BasicProgressMonitor(int themaxLevels) {
        this.maxLevels = themaxLevels;
    }

    @Override
    public final void begin(String name, float thetotalWork) {
        if (!this.closed) {
            this.taskName = name;
            this.totalWork = thetotalWork;
            this.doBegin(name, thetotalWork, this.parentMonitor == null, this.maxLevels);
            this.startTime = System.nanoTime();
        }
    }

    protected void doBegin(String name, float newTotalWork, boolean topInstance, int maxHierarchyLevels) {
    }

    @Override
    public final void done() {
        if (!this.closed) {
            this.totalTime = (double)(System.nanoTime() - this.startTime) * 1.0E-9;
            if (this.completedWork < this.totalWork) {
                this.internalWorked(this.totalWork - this.completedWork);
            }
            this.doDone(this.parentMonitor == null, this.maxLevels);
            this.closed = true;
        }
    }

    protected void doDone(boolean topInstance, int maxHierarchyLevels) {
    }

    @Override
    public final double getExecutionTime() {
        return this.totalTime;
    }

    @Override
    public final List<IKielerProgressMonitor> getSubMonitors() {
        return this.children;
    }

    @Override
    public final IKielerProgressMonitor getParentMonitor() {
        return this.parentMonitor;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public final IKielerProgressMonitor subTask(float work) {
        if (!this.closed) {
            BasicProgressMonitor subMonitor = this.doSubTask(work, this.maxLevels);
            this.children.add(subMonitor);
            subMonitor.parentMonitor = this;
            this.currentChildWork = work;
            return subMonitor;
        }
        return null;
    }

    protected BasicProgressMonitor doSubTask(float work, int maxHierarchyLevels) {
        if (maxHierarchyLevels > 0) {
            return new BasicProgressMonitor(maxHierarchyLevels - 1);
        }
        return new BasicProgressMonitor(maxHierarchyLevels);
    }

    @Override
    public final void worked(float work) {
        if (work > 0.0f && !this.closed) {
            this.internalWorked(work);
        }
    }

    private void internalWorked(float work) {
        if (this.totalWork > 0.0f && this.completedWork < this.totalWork) {
            this.completedWork += work;
            this.doWorked(work, this.completedWork, this.parentMonitor == null);
            if (this.parentMonitor != null && this.parentMonitor.currentChildWork > 0.0f && this.maxLevels != 0) {
                this.parentMonitor.internalWorked(work / this.totalWork * this.parentMonitor.currentChildWork);
            }
        }
    }

    protected void doWorked(float work, float thecompletedWork, boolean topInstance) {
    }
}

