/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core;

import de.cau.cs.kieler.core.IKielerPreferenceStore;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapPreferenceStore
implements IKielerPreferenceStore {
    private Map<String, Object> currentMap = new LinkedHashMap<String, Object>();
    private Map<String, Object> defaultMap = new LinkedHashMap<String, Object>();

    public boolean contains(String name) {
        return this.currentMap.get(name) != null || this.defaultMap.get(name) != null;
    }

    public boolean getBoolean(String name) {
        Object currentValue = this.currentMap.get(name);
        if (currentValue instanceof Boolean) {
            return (Boolean)currentValue;
        }
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Boolean) {
            return (Boolean)defaultValue;
        }
        return false;
    }

    public boolean getDefaultBoolean(String name) {
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Boolean) {
            return (Boolean)defaultValue;
        }
        return false;
    }

    public double getDefaultDouble(String name) {
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Double) {
            return (Double)defaultValue;
        }
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Float) {
            return ((Float)defaultValue).floatValue();
        }
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Integer) {
            return (Integer)defaultValue;
        }
        return 0;
    }

    public long getDefaultLong(String name) {
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Long) {
            return (Long)defaultValue;
        }
        return 0L;
    }

    public String getDefaultString(String name) {
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof String) {
            return (String)defaultValue;
        }
        return "";
    }

    public double getDouble(String name) {
        Object currentValue = this.currentMap.get(name);
        if (currentValue instanceof Double) {
            return (Double)currentValue;
        }
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Double) {
            return (Double)defaultValue;
        }
        return 0.0;
    }

    public float getFloat(String name) {
        Object currentValue = this.currentMap.get(name);
        if (currentValue instanceof Float) {
            return ((Float)currentValue).floatValue();
        }
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Float) {
            return ((Float)defaultValue).floatValue();
        }
        return 0.0f;
    }

    public int getInt(String name) {
        Object currentValue = this.currentMap.get(name);
        if (currentValue instanceof Integer) {
            return (Integer)currentValue;
        }
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Integer) {
            return (Integer)defaultValue;
        }
        return 0;
    }

    public long getLong(String name) {
        Object currentValue = this.currentMap.get(name);
        if (currentValue instanceof Long) {
            return (Long)currentValue;
        }
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof Long) {
            return (Long)defaultValue;
        }
        return 0L;
    }

    public String getString(String name) {
        Object currentValue = this.currentMap.get(name);
        if (currentValue instanceof String) {
            return (String)currentValue;
        }
        Object defaultValue = this.defaultMap.get(name);
        if (defaultValue instanceof String) {
            return (String)defaultValue;
        }
        return "";
    }

    public boolean isDefault(String name) {
        Object currentValue = this.currentMap.get(name);
        Object defaultValue = this.defaultMap.get(name);
        return defaultValue != null && (currentValue == null || currentValue.equals(defaultValue));
    }

    public void setDefault(String name, double value) {
        this.defaultMap.put(name, value);
    }

    public void setDefault(String name, float value) {
        this.defaultMap.put(name, Float.valueOf(value));
    }

    public void setDefault(String name, int value) {
        this.defaultMap.put(name, value);
    }

    public void setDefault(String name, long value) {
        this.defaultMap.put(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.defaultMap.put(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.defaultMap.put(name, value);
    }

    public void setToDefault(String name) {
        this.currentMap.remove(name);
    }

    public void setValue(String name, double value) {
        this.currentMap.put(name, value);
    }

    public void setValue(String name, float value) {
        this.currentMap.put(name, Float.valueOf(value));
    }

    public void setValue(String name, int value) {
        this.currentMap.put(name, value);
    }

    public void setValue(String name, long value) {
        this.currentMap.put(name, value);
    }

    public void setValue(String name, String value) {
        this.currentMap.put(name, value);
    }

    public void setValue(String name, boolean value) {
        this.currentMap.put(name, value);
    }
}

