/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.ch3and4bookstore;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.examples.userguide.ch3and4bookstore.MyResponseTimeRecord;

@Plugin(name="Response time filter", description="Filters incoming response times based on a threshold", outputPorts={@OutputPort(name="validResponseTimes", description="Outputs response times satisfying the threshold", eventTypes={MyResponseTimeRecord.class}), @OutputPort(name="invalidResponseTimes", description="Outputs response times exceeding the threshold", eventTypes={MyResponseTimeRecord.class})}, configuration={@Property(name="thresholdNanos", defaultValue="1000000")})
public class MyResponseTimeFilter
extends AbstractFilterPlugin {
    public static final String OUTPUT_PORT_NAME_RT_VALID = "validResponseTimes";
    public static final String OUTPUT_PORT_NAME_RT_EXCEED = "invalidResponseTimes";
    public static final String CONFIG_PROPERTY_NAME_TS_NANOS = "thresholdNanos";
    private final long rtThresholdNanos;
    public static final String INPUT_PORT_NAME_RESPONSE_TIMES = "newResponseTime";

    public MyResponseTimeFilter(Configuration configuration, IProjectContext iProjectContext) {
        super(configuration, iProjectContext);
        this.rtThresholdNanos = configuration.getLongProperty(CONFIG_PROPERTY_NAME_TS_NANOS);
    }

    @InputPort(name="newResponseTime", description="Filter the given record depending on the response time", eventTypes={MyResponseTimeRecord.class})
    public void newResponseTime(MyResponseTimeRecord myResponseTimeRecord) {
        if (myResponseTimeRecord.getResponseTimeNanos() > this.rtThresholdNanos) {
            super.deliver(OUTPUT_PORT_NAME_RT_EXCEED, (Object)myResponseTimeRecord);
        } else {
            super.deliver(OUTPUT_PORT_NAME_RT_VALID, (Object)myResponseTimeRecord);
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TS_NANOS, Long.toString(this.rtThresholdNanos));
        return configuration;
    }
}

