/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.ch3and4bookstore;

import java.util.Properties;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.examples.userguide.ch3and4bookstore.MyNamedPipeManager;
import kieker.examples.userguide.ch3and4bookstore.MyPipe;
import kieker.examples.userguide.ch3and4bookstore.PipeData;
import kieker.monitoring.writer.AbstractMonitoringWriter;

public class MyPipeWriter
extends AbstractMonitoringWriter {
    public static final String CONFIG_PROPERTY_NAME_PIPE_NAME = MyPipeWriter.class.getName() + ".pipeName";
    private volatile MyPipe pipe;
    private final String pipeName;

    public MyPipeWriter(Configuration configuration) {
        super(configuration);
        this.pipeName = configuration.getStringProperty(CONFIG_PROPERTY_NAME_PIPE_NAME);
    }

    public boolean newMonitoringRecord(IMonitoringRecord iMonitoringRecord) {
        try {
            this.pipe.put(new PipeData(iMonitoringRecord.getLoggingTimestamp(), iMonitoringRecord.toArray(), iMonitoringRecord.getClass()));
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration((Properties)super.getDefaultConfiguration());
        configuration.setProperty(CONFIG_PROPERTY_NAME_PIPE_NAME, "kieker-pipe");
        return configuration;
    }

    protected void init() throws Exception {
        this.pipe = MyNamedPipeManager.getInstance().acquirePipe(this.pipeName);
    }

    public void terminate() {
    }
}

