/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.ch3and4bookstore;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.examples.userguide.ch3and4bookstore.MyNamedPipeManager;
import kieker.examples.userguide.ch3and4bookstore.MyPipe;
import kieker.examples.userguide.ch3and4bookstore.PipeData;

@Plugin(name="Pipe reader", description="Reads records from a configured pipe", outputPorts={@OutputPort(name="outputPort", description="Outputs any received record", eventTypes={IMonitoringRecord.class})}, configuration={@Property(name="pipeName", defaultValue="kieker-pipe")})
public class MyPipeReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME = "outputPort";
    public static final String CONFIG_PROPERTY_NAME_PIPE_NAME = "pipeName";
    private static final Log LOG = LogFactory.getLog(MyPipeReader.class);
    private final String pipeName;
    private volatile MyPipe pipe;

    public MyPipeReader(Configuration configuration, IProjectContext iProjectContext) {
        super(configuration, iProjectContext);
        this.pipeName = configuration.getStringProperty(CONFIG_PROPERTY_NAME_PIPE_NAME);
        try {
            this.pipe = MyNamedPipeManager.getInstance().acquirePipe(this.pipeName);
        }
        catch (Exception exception) {
            LOG.error("Failed to acquire pipe '" + this.pipeName + "'", (Throwable)exception);
        }
    }

    public boolean read() {
        try {
            PipeData pipeData = this.pipe.poll(4L);
            while (pipeData != null) {
                IMonitoringRecord iMonitoringRecord = AbstractMonitoringRecord.createFromArray(pipeData.getRecordType(), (Object[])pipeData.getRecordData());
                iMonitoringRecord.setLoggingTimestamp(pipeData.getLoggingTimestamp());
                super.deliver(OUTPUT_PORT_NAME, (Object)iMonitoringRecord);
                pipeData = this.pipe.poll(4L);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration(null);
        configuration.setProperty(CONFIG_PROPERTY_NAME_PIPE_NAME, this.pipeName);
        return configuration;
    }

    public void terminate(boolean bl) {
    }
}

