/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.util.AjaxRequestBuilder;

public abstract class CoreRenderer
extends Renderer {
    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(context, child);
        }
    }

    protected void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else {
            this.renderChildren(context, child);
        }
        child.encodeEnd(context);
    }

    protected String getActionURL(FacesContext context) {
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, context.getViewRoot().getViewId());
        return context.getExternalContext().encodeActionURL(actionURL);
    }

    protected String getResourceURL(FacesContext context, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(url);
    }

    protected String getResourceRequestPath(FacesContext context, String resourceName) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName, "primefaces");
        return resource.getRequestPath();
    }

    public boolean isPostback(FacesContext context) {
        return context.getRenderKit().getResponseStateManager().isPostback(context);
    }

    public boolean isAjaxRequest(FacesContext context) {
        return context.getPartialViewContext().isAjaxRequest();
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected boolean isPostBack() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getRenderKit().getResponseStateManager().isPostback(context);
    }

    public String getEscapedClientId(String clientId) {
        return "#" + clientId.replaceAll(":", "\\\\\\\\:");
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected String buildAjaxRequest(FacesContext context, AjaxSource source, UIComponent form) {
        UIComponent component = (UIComponent)source;
        String clientId = component.getClientId(context);
        AjaxRequestBuilder builder = new AjaxRequestBuilder();
        builder.source(clientId).process(context, component, source.getProcess()).update(context, component, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).partialSubmit(source.isPartialSubmit(), source.isPartialSubmitSet()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).params(component);
        if (form != null) {
            builder.form(form.getClientId(context));
        }
        builder.preventDefault();
        return builder.build();
    }

    protected String buildNonAjaxRequest(FacesContext context, UIComponent component, UIComponent form, String decodeParam, boolean submit) {
        StringBuilder request = new StringBuilder();
        String formId = form.getClientId(context);
        HashMap<String, String> params = new HashMap<String, String>();
        if (decodeParam != null) {
            params.put(decodeParam, decodeParam);
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            params.put(param.getName(), String.valueOf(param.getValue()));
        }
        if (!params.isEmpty()) {
            request.append("PrimeFaces.addSubmitParam('").append(formId).append("',{");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)params.get(key);
                request.append("'").append(key).append("':'").append(value).append("'");
                if (!it.hasNext()) continue;
                request.append(",");
            }
            request.append("})");
        }
        if (submit) {
            request.append(".submit('").append(formId).append("');");
        }
        return request.toString();
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map behaviorEvents = component.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            writer.write(",behaviors:{");
            Iterator eventIterator = behaviorEvents.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event;
                String domEvent = event = (String)eventIterator.next();
                if (event.equalsIgnoreCase("valueChange")) {
                    domEvent = "change";
                } else if (event.equalsIgnoreCase("action")) {
                    domEvent = "click";
                }
                writer.write(domEvent + ":");
                writer.write("function(event) {");
                for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                    ClientBehaviorContext cbc;
                    String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params));
                    if (script == null) continue;
                    writer.write(script);
                }
                writer.write("}");
                if (!eventIterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("}");
        }
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (null != behaviorEvent && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && !behaviorsForEvent.isEmpty()) {
            String behaviorSource = (String)params.get("javax.faces.source");
            String clientId = component.getClientId();
            if (behaviorSource != null && clientId.startsWith(behaviorSource)) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
        }
    }

    protected void startScript(ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("id", (Object)(clientId + "_s"), null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
    }

    protected void endScript(ResponseWriter writer) throws IOException {
        writer.endElement("script");
    }

    protected String escapeText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected String getOnclickBehaviors(FacesContext context, ClientBehaviorHolder cbh) {
        List behaviors = (List)cbh.getClientBehaviors().get("action");
        StringBuilder sb = new StringBuilder();
        if (behaviors != null && !behaviors.isEmpty()) {
            UIComponent component = (UIComponent)cbh;
            String clientId = component.getClientId(context);
            List params = Collections.emptyList();
            for (ClientBehavior behavior : behaviors) {
                ClientBehaviorContext cbc;
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)"action", (String)clientId, params));
                if (script == null) continue;
                sb.append(script).append(";");
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    protected boolean shouldWriteId(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)component).getClientBehaviors().isEmpty());
    }
}

