/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanybutton;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectmanybutton.SelectManyButton;
import org.primefaces.renderkit.SelectManyRenderer;

public class SelectManyButtonRenderer
extends SelectManyRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectMany", "javax.faces.Checkbox").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyButton button = (SelectManyButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SelectManyButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String style = button.getStyle();
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanybutton ui-buttonset ui-widget" : "ui-selectmanybutton ui-buttonset ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, button);
        writer.endElement("div");
    }

    protected void encodeSelectItems(FacesContext context, SelectManyButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)button);
        Converter converter = button.getConverter();
        Object values = this.getValues((UIComponent)button);
        Object submittedValues = this.getSubmittedValues((UIComponent)button);
        int selectItemsSize = selectItems.size();
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, (UIInput)button, values, submittedValues, converter, selectItem, ++idx, selectItemsSize);
        }
    }

    protected void encodeOption(FacesContext context, UIInput component, Object values, Object submittedValues, Converter converter, SelectItem option, int idx, int size) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        SelectManyButton button = (SelectManyButton)component;
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)component, converter, option.getValue());
        String name = button.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean bl = disabled = option.isDisabled() || button.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)component, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        String buttonStyle = "ui-button ui-widget ui-state-default ui-button-text-only";
        if (idx == 0) {
            buttonStyle = buttonStyle + " ui-corner-left";
        } else if (idx == size - 1) {
            buttonStyle = buttonStyle + " ui-corner-right";
        }
        buttonStyle = selected ? buttonStyle + " ui-state-active" : buttonStyle;
        buttonStyle = disabled ? buttonStyle + " ui-state-disabled" : buttonStyle;
        buttonStyle = !button.isValid() ? buttonStyle + " ui-state-error" : buttonStyle;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)buttonStyle, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (button.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)button.getOnchange(), null);
        }
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.writeText((Object)option.getLabel(), "itemLabel");
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectManyButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('SelectManyButton','" + button.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeClientBehaviors(context, button);
        writer.write("});");
        this.endScript(writer);
    }

    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }
}

