/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rating;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.rating.Rating;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;

public class RatingRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Rating rating = (Rating)component;
        if (rating.isDisabled() || rating.isReadonly()) {
            return;
        }
        String clientId = rating.getClientId();
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        rating.setSubmittedValue(submittedValue);
        this.decodeBehaviors(context, (UIComponent)rating);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Rating rating = (Rating)component;
        this.encodeMarkup(context, rating);
        this.encodeScript(context, rating);
    }

    private void encodeScript(FacesContext context, Rating rating) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = rating.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Rating','" + rating.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (rating.getOnRate() != null) {
            writer.write(",onRate:function(value) {" + rating.getOnRate() + ";}");
        }
        if (rating.isReadonly()) {
            writer.write(",readonly:true");
        }
        if (rating.isDisabled()) {
            writer.write(",disabled:true");
        }
        this.encodeClientBehaviors(context, rating);
        writer.write("},'rating');});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Rating rating) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = rating.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)rating);
        Integer value = this.isValueBlank(valueToRender) ? null : Integer.valueOf(valueToRender);
        int stars = rating.getStars();
        boolean disabled = rating.isDisabled();
        boolean readonly = rating.isReadonly();
        String style = rating.getStyle();
        String styleClass = rating.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-rating" : "ui-rating " + styleClass;
        if (disabled) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)rating);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (rating.isCancel() && !disabled && !readonly) {
            this.encodeIcon(context, "ui-rating-cancel");
        }
        for (int i = 0; i < stars; ++i) {
            String starClass = value != null && i < value ? "ui-rating-star ui-rating-star-on" : "ui-rating-star";
            this.encodeIcon(context, starClass);
        }
        this.encodeInput(context, clientId + "_input", valueToRender);
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("a", null);
        writer.endElement("a");
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, String id, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }
}

