/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.progressbar;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.progressbar.ProgressBar;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;

public class ProgressBarRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        ProgressBar progressBar = (ProgressBar)component;
        String clientId = progressBar.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            RequestContext.getCurrentInstance().addCallbackParam(progressBar.getClientId(context) + "_value", progressBar.getValue());
        }
        this.decodeBehaviors(context, (UIComponent)progressBar);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ProgressBar progressBar = (ProgressBar)component;
        this.encodeMarkup(context, progressBar);
        if (!progressBar.isDisplayOnly()) {
            this.encodeScript(context, progressBar);
        }
    }

    protected void encodeMarkup(FacesContext context, ProgressBar progressBar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int value = progressBar.getValue();
        String labelTemplate = progressBar.getLabelTemplate();
        String style = progressBar.getStyle();
        String styleClass = progressBar.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-progressbar ui-widget ui-widget-content ui-corner-all" : "ui-progressbar ui-widget ui-widget-content ui-corner-all " + styleClass;
        if (progressBar.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("id", (Object)progressBar.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("class", (Object)"ui-progressbar-value ui-widget-header ui-corner-all", null);
        if (value != 0) {
            writer.writeAttribute("style", (Object)("display:block;width:" + value + "%"), style);
        }
        writer.endElement("div");
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("class", (Object)"ui-progressbar-label", null);
        if (labelTemplate != null && value != 0) {
            writer.writeAttribute("style", (Object)"display:block", style);
            writer.write(labelTemplate.replaceAll("\\{value\\}", String.valueOf(value)));
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ProgressBar progressBar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = progressBar.getClientId(context);
        boolean isAjax = progressBar.isAjax();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('ProgressBar','" + progressBar.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",initialValue:" + progressBar.getValue());
        writer.write(",ajax:" + isAjax);
        if (progressBar.getLabelTemplate() != null) {
            writer.write(",labelTemplate:'" + progressBar.getLabelTemplate() + "'");
        }
        if (isAjax) {
            writer.write(",interval:" + progressBar.getInterval());
            this.encodeClientBehaviors(context, progressBar);
        }
        writer.write("});});");
        this.endScript(writer);
    }
}

