/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtextarea;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.event.AutoCompleteEvent;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputTextareaRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputTextarea inputTextarea = (InputTextarea)component;
        if (inputTextarea.isDisabled() || inputTextarea.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputTextarea);
        String clientId = inputTextarea.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)params.get(clientId);
        inputTextarea.setSubmittedValue(submittedValue);
        String query = (String)params.get(clientId + "_query");
        if (query != null) {
            AutoCompleteEvent autoCompleteEvent = new AutoCompleteEvent((UIComponent)inputTextarea, query);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            inputTextarea.queueEvent(autoCompleteEvent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputTextarea inputTextarea = (InputTextarea)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String query = (String)params.get(inputTextarea.getClientId(context) + "_query");
        if (query != null) {
            this.encodeSuggestions(context, inputTextarea, query);
        } else {
            this.encodeMarkup(context, inputTextarea);
            this.encodeScript(context, inputTextarea);
        }
    }

    public void encodeSuggestions(FacesContext context, InputTextarea inputTextarea, String query) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List items = inputTextarea.getSuggestions();
        writer.startElement("ul", (UIComponent)inputTextarea);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        for (Object item : items) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-list-item ui-corner-all", null);
            writer.writeAttribute("data-item-value", item, null);
            writer.writeText(item, null);
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    protected void encodeScript(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        boolean autoResize = inputTextarea.isAutoResize();
        String counter = inputTextarea.getCounter();
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('InputTextarea','" + inputTextarea.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",autoResize:" + autoResize);
        if (inputTextarea.getScrollHeight() != Integer.MAX_VALUE) {
            writer.write(",scrollHeight:" + inputTextarea.getScrollHeight());
        }
        if (inputTextarea.getMaxlength() != Integer.MAX_VALUE) {
            writer.write(",maxlength:" + inputTextarea.getMaxlength());
        }
        if (counter != null) {
            String counterTemplate = inputTextarea.getCounterTemplate();
            UIComponent counterComponent = inputTextarea.findComponent(counter);
            if (counterComponent == null) {
                throw new FacesException("Cannot find component \"" + counter + "\" in view.");
            }
            writer.write(",counter:'" + counterComponent.getClientId(context) + "'");
            if (counterTemplate != null) {
                writer.write(",counterTemplate:'" + counterTemplate + "'");
            }
        }
        if (inputTextarea.getCompleteMethod() != null) {
            writer.write(",autoComplete:true");
            writer.write(",minQueryLength:" + inputTextarea.getMinQueryLength());
            writer.write(",queryDelay:" + inputTextarea.getQueryDelay());
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputTextarea);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        this.renderPassThruAttributes(context, (UIComponent)inputTextarea, HTML.INPUT_TEXTAREA_ATTRS);
        if (inputTextarea.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (inputTextarea.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (inputTextarea.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputTextarea.getStyle(), null);
        }
        writer.writeAttribute("class", (Object)this.createStyleClass(inputTextarea), "styleClass");
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputTextarea);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    protected String createStyleClass(InputTextarea inputTextarea) {
        String defaultClass = "ui-inputfield ui-inputtextarea ui-widget ui-state-default ui-corner-all";
        defaultClass = inputTextarea.isValid() ? defaultClass : defaultClass + " ui-state-error";
        defaultClass = !inputTextarea.isDisabled() ? defaultClass : defaultClass + " ui-state-disabled";
        String styleClass = inputTextarea.getStyleClass();
        String string = styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        if (inputTextarea.isAutoResize()) {
            styleClass = styleClass + " ui-inputtextarea-resizable";
        }
        return styleClass;
    }
}

