/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.galleria;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.galleria.Galleria;
import org.primefaces.renderkit.CoreRenderer;

public class GalleriaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Galleria galleria = (Galleria)component;
        this.encodeMarkup(context, (UIComponent)galleria);
        this.encodeScript(context, (UIComponent)galleria);
    }

    public void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Galleria galleria = (Galleria)component;
        String styleClass = galleria.getStyleClass();
        styleClass = styleClass == null ? "ui-galleria" : "ui-galleria " + styleClass;
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)galleria.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, "style");
        if (galleria.getStyle() != null) {
            writer.writeAttribute("style", (Object)galleria.getStyle(), "style");
        }
        if (galleria.getVar() == null) {
            for (UIComponent child : galleria.getChildren()) {
                if (!child.isRendered()) continue;
                writer.startElement("li", null);
                child.encodeAll(context);
                writer.endElement("li");
            }
        } else {
            for (int i = 0; i < galleria.getRowCount(); ++i) {
                galleria.setRowIndex(i);
                writer.startElement("li", null);
                this.renderChildren(context, (UIComponent)galleria);
                writer.endElement("li");
            }
            galleria.setRowIndex(-1);
        }
        writer.endElement("ul");
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Galleria galleria = (Galleria)component;
        String clientId = galleria.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Galleria','" + galleria.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",panel_animation:'" + galleria.getEffect() + "'");
        writer.write(",transition_speed:" + galleria.getEffectSpeed());
        writer.write(",transition_interval:" + galleria.getTransitionInterval());
        if (galleria.getPanelWidth() != 600) {
            writer.write(",panel_width:" + galleria.getPanelWidth());
        }
        if (galleria.getPanelHeight() != 400) {
            writer.write(",panel_height:" + galleria.getPanelHeight());
        }
        if (galleria.getFrameWidth() != 60) {
            writer.write(",frame_width:" + galleria.getFrameWidth());
        }
        if (galleria.getFrameHeight() != 40) {
            writer.write(",frame_height:" + galleria.getFrameHeight());
        }
        if (galleria.getFilmstripStyle() != null) {
            writer.write(",filmstrip_style:'" + galleria.getFilmstripStyle() + "'");
        }
        if (galleria.getFilmstripPosition() != null) {
            writer.write(",filmstrip_position:'" + galleria.getFilmstripPosition() + "'");
        }
        if (!galleria.isShowFilmstrip()) {
            writer.write(",show_filmstrip:false");
        }
        if (galleria.isShowCaptions()) {
            writer.write(",show_captions:true");
        }
        if (galleria.isShowOverlays()) {
            writer.write(",show_overlays:true");
        }
        writer.write("},'galleria');});");
        this.endScript(writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

