/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datagrid.DataGrid;
import org.primefaces.renderkit.DataRenderer;

public class DataGridRenderer
extends DataRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataGrid grid = (DataGrid)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (grid.isPaginationRequest(context)) {
            grid.updatePaginationData(context, grid);
            if (grid.isLazy()) {
                grid.loadLazyData();
            }
            this.encodeTable(context, grid);
        } else {
            this.encodeMarkup(context, grid);
            this.encodeScript(context, grid);
        }
    }

    protected void encodeMarkup(FacesContext context, DataGrid grid) throws IOException {
        String contentClass;
        if (grid.isLazy()) {
            grid.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId();
        boolean hasPaginator = grid.isPaginator();
        boolean empty = grid.getRowCount() == 0;
        String paginatorPosition = grid.getPaginatorPosition();
        String styleClass = grid.getStyleClass() == null ? "ui-datagrid ui-widget" : "ui-datagrid ui-widget " + grid.getStyleClass();
        String string = contentClass = empty ? "ui-datagrid-content  ui-datagrid-content-empty ui-widget-content" : "ui-datagrid-content ui-widget-content";
        if (hasPaginator) {
            grid.calculatePage();
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        this.encodeFacet(context, grid, "header", "ui-datagrid-header ui-widget-header ui-corner-top");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, grid, "top");
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (empty) {
            writer.write(grid.getEmptyMessage());
        } else {
            this.encodeTable(context, grid);
        }
        writer.endElement("div");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, grid, "bottom");
        }
        this.encodeFacet(context, grid, "footer", "ui-datagrid-footer ui-widget-header ui-corner-bottom");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId();
        this.startScript(writer, clientId);
        writer.write("$(function() { ");
        writer.write("PrimeFaces.cw('DataGrid','" + grid.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (grid.isPaginator()) {
            this.encodePaginatorConfig(context, grid);
        }
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeTable(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        int itemsToRender = rows != 0 ? rows : grid.getRowCount();
        int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
        int renderedItems = 0;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("class", (Object)"ui-datagrid-data", null);
        writer.startElement("tbody", null);
        for (int i = 0; i < numberOfRowsToRender; ++i) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-datagrid-row", null);
            for (int j = 0; j < columns; ++j) {
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)"ui-datagrid-column", null);
                if (renderedItems < itemsToRender) {
                    grid.setRowIndex(rowIndex);
                    if (grid.isRowAvailable()) {
                        this.renderChildren(context, (UIComponent)grid);
                        ++rowIndex;
                        ++renderedItems;
                    }
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        grid.setRowIndex(-1);
        writer.endElement("tbody");
        writer.endElement("table");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

