/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.calendar.Calendar;

public class CalendarUtils {
    public static String getValueAsString(FacesContext context, Calendar calendar) {
        Object submittedValue = calendar.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsString(context, (UIComponent)calendar, value);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendar.calculatePattern(), calendar.calculateLocale(context));
        dateFormat.setTimeZone(calendar.calculateTimeZone());
        return dateFormat.format(value);
    }

    public static String getValueAsString(FacesContext context, Calendar calendar, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(calendar.calculatePattern(), calendar.calculateLocale(context));
            dateFormat.setTimeZone(calendar.calculateTimeZone());
            return dateFormat.format((Date)value);
        }
        throw new FacesException("Value could be either String or java.util.Date");
    }

    public static String getTimeOnlyValueAsString(FacesContext context, Calendar calendar) {
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(calendar.calculateTimeOnlyPattern(), calendar.calculateLocale(context));
            format.setTimeZone(calendar.calculateTimeZone());
            return format.format(calendar.getValue());
        }
        throw new FacesException("Value could be either String or java.util.Date");
    }

    public static String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        pattern = (pattern = pattern.replaceAll("yy", "y")).indexOf("MMM") != -1 ? pattern.replaceAll("MMM", "M") : pattern.replaceAll("M", "m");
        if ((pattern = pattern.replaceAll("EEE", "D")).indexOf("H") != -1 || pattern.indexOf("h") != -1) {
            pattern = pattern.replaceAll("H", "h").replaceAll("a", "TT");
        }
        return pattern;
    }
}

