/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.button;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.button.Button;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.HTML;

public class ButtonRenderer
extends OutcomeTargetRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Button button = (Button)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    public void encodeMarkup(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String value = (String)button.getValue();
        String icon = button.resolveIcon();
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.writeAttribute("onclick", (Object)this.buildOnclick(context, button), null);
        if (icon != null) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon" : "ui-button-icon-right ui-icon";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        if (value == null) {
            writer.write("ui-button");
        } else if (button.isEscape()) {
            writer.writeText((Object)value, "value");
        } else {
            writer.write(value);
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeScript(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Button','" + button.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write("});");
        this.endScript(writer);
    }

    protected String buildOnclick(FacesContext context, Button button) {
        String onclickBehaviors;
        String userOnclick = button.getOnclick();
        StringBuilder onclick = new StringBuilder();
        String targetURL = this.getTargetURL(context, button);
        if (userOnclick != null) {
            onclick.append(userOnclick).append(";");
        }
        if ((onclickBehaviors = this.getOnclickBehaviors(context, (ClientBehaviorHolder)button)) != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        if (targetURL != null) {
            onclick.append("window.location.href='").append(targetURL).append("'");
        }
        return onclick.toString();
    }
}

